<?php
/**
 * @author       Aicha Vack
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2021 vi-solutions
 * @since        Joomla 1.6
 */

namespace Visolutions\Module\Visforms\Site\Helper;

// no direct access
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Uri\Uri;
use Visolutions\Component\Visforms\Site\Model\VisformsModel;

class VisformsHelper
{
	public static function getForm(&$params) {

		$app = Factory::getApplication();
        $wa = $app->getDocument()->getWebAssetManager();
		$id = $params->get('catid', 0);
		$context = $params->get('context', '');
		// Get an instance of the generic visforms model
		$model = new VisformsModel(array('ignore_request' => true, 'id' => $id, 'context' => $context));
		$visforms = $model->getForm();
		if (empty($visforms)) {
			return $visforms;
		}
		//check if user access level allows view
		$user = Factory::getApplication()->getIdentity();
		$groups = $user->getAuthorisedViewLevels();
		$access = (isset($visforms->access) && in_array($visforms->access, $groups)) ? true : false;
		if ($access == false) {
			$app->setUserState('com_visforms.' . $visforms->context, null);
			//don't process fields if user cannot view form (avoid "nothing to setup javascript error of data fields)
			return $visforms;
		}
		$canDo = \VisformsHelper::getActions($visforms->id);
        // option singlesubmission is set and a logged in user
        if (!empty($visforms->singlesubmission) && $user->id !== 0 && \VisformsAEF::checkAEF(\VisformsAEF::$subscription)) {
            // check if we already have a submission for this user and this form
            $datas = $model->getRecords();
            $hasAlreadySubmitted = 0;
            if (!empty($datas)) {
                $hasAlreadySubmitted = 1;
            }
            if ($hasAlreadySubmitted === 1) {
                // ToDo Implement Support for redirect $this->visforms->redirecttoeditview == 2; Handle potential infinte redirects problem
                // if ((!empty($visforms->redirecttoeditview)) && (!empty($visforms->dataEditMenuExists)) && ($visforms->redirecttoeditview == 1 || $visforms->redirecttoeditview == 2)) {
                if ((!empty($visforms->redirecttoeditview)) && (!empty($visforms->dataEditMenuExists)) && ($visforms->redirecttoeditview == 1)) {
                    $editIds = array();
                    // check if user can edit their own data
                    // get a list of the id's of all data already submitted by this user
                    if ($canDo->get('core.edit.own.data')) {
                        if (!empty($datas)) {
                            foreach ($datas as $data) {
                                if ((is_object($data)) && (!empty($data)) && !empty($data->id) && isset($data->published)) {
                                    if (!empty($data->published) || $canDo->get('core.edit.data.state') || $canDo->get('core.edit.own.data.state')) {
                                        $editIds[] = (int)$data->id;
                                    }
                                }
                            }
                        }
                    }
                    // display an edit link or redirect to edit view
                    if (!empty($editIds)) {
                        if ($visforms->redirecttoeditview == 1) {
                            $app->setUserState('com_visforms.' . $visforms->context, null);
                            PluginHelper::importPlugin('visforms');
                            // Add frontend web assets to edit link view
                            $app->triggerEvent('onVisformsAddWebAssets', array('com_visforms.form.edit_link', $visforms->id));
                            $params->set('editIds', $editIds);
                            $params->set('layout', 'editlink');
                            return $visforms;
                        }
                        // ToDo Implement Support for redirect $visforms->redirecttoeditview == 2; Handle potential infinte redirects problem
                        /* if ($visforms->redirecttoeditview == 2) {
                            // empty page, if form is not published
                            if ($visforms->published != '1') {
                                return $visforms;
                            }
                            // pick first id from $editlinks
                            // redirect to edit view of this record set
                            $app->setUserState('com_visforms.' . $visforms->context, null);
                            $recordId = $editIds[0];
                            $redirectUri = '&return=' . HTMLHelper::_('visforms.base64_url_encode', 'index.php?Itemid=' . $visforms->dataEditMenuExists);
                            $link = Uri::base() . 'index.php?option=com_visforms&view=edit&layout=edit&task=edit.editdata&id=' . (int)$visforms->id . '&cid=' . (int)$recordId . $redirectUri . '&Itemid=' . $visforms->dataEditMenuExists;
                            $app->redirect($link, 200);
                        } */
                    }
                    // default to display message 'form can only be submitted once'
                    else {
                        $alreadySubmittedMessage = Text::_('COM_VISFORMS_FORM_WAS_ALREADY_SUBMITTED');
                        $app->setUserState('com_visforms.' . $visforms->context, null);
                        PluginHelper::importPlugin('visforms');
                        // Add frontend web assets to edit link view
                        $app->triggerEvent('onVisformsAddWebAssets', array('com_visforms.form.already_submitted_message', $visforms->id));
                        $params->set('alreadySubmittedMessage', $alreadySubmittedMessage);
                        $params->set('layout', 'alreadysubmittedmessage');
                        return $visforms;
                    }
                }
                // display message 'form can only be submitted once'
                else {
                    $alreadySubmittedMessage = Text::_('COM_VISFORMS_FORM_WAS_ALREADY_SUBMITTED');
                    $app->setUserState('com_visforms.' . $visforms->context, null);
                    PluginHelper::importPlugin('visforms');
                    // Add frontend web assets to edit link view
                    $app->triggerEvent('onVisformsAddWebAssets', array('com_visforms.form.already_submitted_message', $visforms->id));
                    $params->set('alreadySubmittedMessage', $alreadySubmittedMessage);
                    $params->set('layout', 'alreadysubmittedmessage');
                    return $visforms;
                }
            }
        }
        $currentDate = Factory::getDate()->format('Y-m-d H:i:s');
        $isNotPublishedYet = $visforms->publish_up > $currentDate;
        $isExpired = !is_null($visforms->publish_down) && $visforms->publish_down < $currentDate;
		$fields = $model->getFields();
		$successMessage = $app->getUserState('com_visforms.messages.' . $visforms->context, '');
		PluginHelper::importPlugin('content');
		$successMessage = (!empty($successMessage)) ? HTMLHelper::_('content.prepare', $successMessage) : $successMessage;
		$app->setUserState('com_visforms.messages.' . $visforms->context, null);
		$app->setUserState('com_visforms.' . $visforms->context . '.fields', null);
		$app->setUserState('com_visforms.' . $visforms->context, null);
		$visforms->fields = $fields;
		$visforms->parentFormId = 'mod-visform' . $visforms->id;
		//Trigger onFormPrepare event
		PluginHelper::importPlugin('visforms');
		$app->triggerEvent('onVisformsFormPrepare', array('mod_visforms.form', $visforms, $params));
        // empty page, if form is not published
        if ($visforms->published != '1') {
            return $visforms;
        }
        // empty page, if form is published down
        if ($isNotPublishedYet || $isExpired) {
            return $visforms;
        }
        // Add frontend web assets and all js to form view
        foreach ($visforms->fields as $field) {
            if (!empty($field->customJs) && is_array($field->customJs)) {
                foreach ($field->customJs as $script) {
                    $wa->addInlineScript($script);
                }
            }
        }
        // Add frontend web assets to form view
        $app->triggerEvent( 'onVisformsAddWebAssets', array('com_visforms.form.form', $visforms->id) );
		$nbFields = count($visforms->fields);
		//get some infos to look whether it's neccessary to add Javascript or special HTML-Code or not
		//variables are set to true if they are true for at least one field
		$required = false;
		$upload = false;
		$textareaRequired = false;
		$hasHTMLEditor = false;
		//helper, used to set focus on first visible field default is no focus
		$firstControl = true;
		$setFocus = (!empty($visforms->setfocus)) ? true : false;
		$steps = (!empty($visforms->steps)) ? (int) $visforms->steps : (int) 1;

		for ($i = 0; $i < $nbFields; $i++) {
			$field = $visforms->fields[$i];
			//set the controll variables
			if (isset($field->attribute_required) && ($field->attribute_required == "required")) {
				$required = true;
			}
			if (isset($field->typefield) && $field->typefield == "file") {
				$upload = true;
			}
			if (isset($field->textareaRequired) && $field->textareaRequired === true) {
				//we have some work to do to use Javascript to validate that the textarea has content
				$textareaRequired = true;
			}
			if (isset($field->hasHTMLEditor) && $field->hasHTMLEditor == true) {
				$hasHTMLEditor = true;
			}
		}

		//push helper variabels into params
		$params->set('nbFields', $nbFields);
		$params->set('required', $required);
		$params->set('upload', $upload);
		$params->set('textareaRequired', $textareaRequired);
		$params->set('hasHTMLEditor', $hasHTMLEditor);
		$params->set('firstControl', $firstControl);
		$params->set('setFocus', $setFocus);
		$params->set('steps', $steps);
		$params->set('successMessage', $successMessage);

		$options = HTMLHelper::_('visforms.getLayoutOptions', $visforms);

		// process form layout
		$olayout = \VisformsLayout::getInstance($visforms->formlayout, $options);
		if (is_object($olayout)) {
			//add layout specific css
			$olayout->addCss();
		}
        // add form specific css
        if (!empty($visforms->css)) {
            $wa->addInlineStyle($visforms->css);
        }
        // add form specific js
        if (!empty($visforms->js)) {
            $wa->addInlineScript($visforms->js);
        }

		return $visforms;
	}
}