<?php
/**
 * @author       Aicha Vack
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2021 vi-solutions
 * @since        Joomla 1.6
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Log\Log;

class plgvisformsspambotcheckInstallerScript {
	private $release;
	private $oldRelease;
	private $name;
	private $loggerName;

	// construction

	public function __construct($adapter) {
		$this->initializeLogger($adapter);
		$this->addLogEntry('****** script file loaded: spambotcheck package - plugins/visforms/spambotcheck/script.php ******', Log::INFO);
	}

	// interface

    public function preflight($route, $adapter) {
	    $this->addLogEntry('start preflight', Log::INFO);

        $this->release = $adapter->getManifest()->version;
	    $this->oldRelease = "";
		$this->name = $adapter->getManifest()->name;
        $date = new JDate('now');

		$this->addLogEntry('*** start ' . $route . ' of extension ' . $this->name . ' ' . $this->release . ': ' . $date . ' ***', \JLog::INFO);
        // must get old Release in preflight!
        if ( $route == 'update' ) {
	        $this->oldRelease = $this->getParam('version', $this->name);
			$this->addLogEntry('trying to update from version ' . $this->oldRelease . ' to ' . $this->release, \JLog::INFO);
        }

	    $this->addLogEntry('end preflight', Log::INFO);
	    return true;
    }

    public function install($adapter) {
	    $this->addLogEntry('start install', Log::INFO);
	    // Give a warning if cURL is not enabled on system; plugin will not be able to identify spammer
	    $extension = 'curl';
	    if (!extension_loaded($extension)) {
		    $this->addLogEntry(Text::_('PLG_VISFORMS_SPAMBOTCHECK_CURL_MISSING'), \JLog::WARNING);
	    }
	    $this->addLogEntry('end install', Log::INFO);
    }

    public function update($adapter) {
	    $this->addLogEntry('start update', Log::INFO);

		if (version_compare($this->oldRelease, '3.1.0', 'lt')) {
			$this->addLogEntry('*** trying to remove params of Plugin Visforms Spambotcheck ***', \JLog::INFO);
            // remove params
			$db = Factory::getDbo();
			$query = $db->getQuery(true);
			$fields = array(
				$db->qn('params')  . ' = ' . $db->q('{}')
			);
			$conditions = array(
				$db->qn('name') . ' = ' . $db->q('plg_visforms_spambotcheck'),
				$db->qn('folder') . ' = ' . $db->q('visforms')
			);
            $query->update($db->qn('#__extensions'))
				->set($fields)
				->where($conditions);
            try {
	            $db->setQuery($query);
                $db->execute();
	            $this->addLogEntry('params removed', \JLog::INFO);
            }
            catch (Exception $e) {
	            $this->addLogEntry('unable to remove params: ' . $e->getMessage(), \JLog::ERROR);
            }
		}

	    $this->addLogEntry('end update', Log::INFO);
	}
	
	public function postflight($route, $adapter) {
		$this->addLogEntry('start postflight', Log::INFO);
		$this->addLogEntry($route . ' successful', \JLog::INFO);
		$this->addLogEntry('end postflight', Log::INFO);
	}

	// implementation

	private function getParam($pname, $name) {
		// get a variable from the manifest cache in database
		$db = Factory::getDbo();
		$query = $db->getQuery(true);
		$query->select($db->qn('manifest_cache'))
			->from($db->qn('#__extensions'))
			->where($db->qn('name') . ' = ' . $db->q($name));
		try {
			$db->setQuery($query);
			$result = $db->loadResult();
			if (empty($result)) {
				return '';
			}
			$manifest = json_decode($result, true);
			if (isset($manifest[$pname])) {
				return $manifest[$pname];
			}
			return '';
		}
		catch (Exception $e) {
			$this->addLogEntry('unable to get ' . $name . ' ' . $pname . ' from manifest cache in database, ' . $e->getMessage(), \JLog::ERROR);
			return false;
		}
	}

	// logging

	private function initializeLogger($adapter) {
		$this->loggerName               = 'visforms';
		$options['format']              = "{CODE}\t{MESSAGE}";
		$options['text_entry_format']   = "{PRIORITY}\t{MESSAGE}";
		$options['text_file']           = 'visforms_update.php';
		try {
			Log::addLogger($options, Log::ALL, array($this->loggerName, 'jerror'));
		}
		catch (RuntimeException $e) {}
	}

	private function addLogEntry($message, $code = Log::ERROR) {
		try {
			Log::add($message, $code, $this->loggerName);
		}
		catch (RuntimeException $exception)
		{
			// prevent installation routine from failing due to problems with logger
		}
	}
}