<?php
/**
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2018 vi-solutions
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\HTML\HTMLHelper;
require_once __DIR__ . '/select.php';

class VisformsPlaceholderEntrySelectsql extends VisformsPlaceholderEntrySelect {

    // display as list not yet supported because it is unclear how the returned html could look like
    protected static $customParams = array (
	    'DISPLAYOPTIONLABEL' => 'COM_VISFORMS_PLACEHOLDER_PARAM_OPTION_LABEL',
        'DISPLAYOPTIONLABELASLIST' => 'COM_VISFORMS_PLACEHOLDER_PARAM_OPTION_LABEL_AS_LIST',
        'DISPLAYOPTIONVALUE' => 'COM_VISFORMS_PLACEHOLDER_PARAM_OPTION_VALUE',
        'DISPLAYOPTIONVALUEASLIST' => 'COM_VISFORMS_PLACEHOLDER_PARAM_OPTION_VALUE_AS_LIST',
	);

	public function getReplaceValue() {
		if (isset($this->rawData) && ($this->rawData === '')) {
			return '';
		}
		$customParams = self::$customParams;
		if (!empty($this->param) && array_key_exists($this->param, $customParams)) {
			switch ($this->param) {
				case 'DISPLAYOPTIONVALUE' :
					return HTMLHelper::_('visformsselect.removeNullbyte', $this->rawData);
                case 'DISPLAYOPTIONVALUEASLIST' :
                    // Comma separated data string
                    $data = HTMLHelper::_('visformsselect.removeNullbyte', $this->rawData);
                    $list = $this->getListHtml($data);
                    return $list;
                case 'DISPLAYOPTIONLABELASLIST' :
                    // Comma separated data string
                    $data = HTMLHelper::_('visformsselect.mapDbValueToSqlOptionLabel', $this->rawData, $this->field->sql);
                    $list = $this->getListHtml($data);
                    return $list;
                case 'DISPLAYOPTIONLABEL':
				default:
					return implode(', ', HTMLHelper::_('visformsselect.mapDbValueToSqlOptionLabel', $this->rawData, $this->field->sql));
			}
		}
		// legacy for old field option useoptionvalueinplaceholder
		else {
			if (!empty($this->field->useoptionvalueinplaceholder)) {
				return HTMLHelper::_('visformsselect.removeNullbyte', $this->rawData);
			}
		}
		// default return is file name
		return implode(', ', HTMLHelper::_('visformsselect.mapDbValueToSqlOptionLabel', $this->rawData, $this->field->sql));
	}
}