<?php
/**
 * visinspector view for Visforms
 *
 * @author       Ingmar Vack
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 4.2
 */

namespace Visolutions\Component\Visforms\Administrator\View\Visinspector;

defined('_JEXEC') or die('Direct Access to this location is not allowed.');

use Joomla\CMS\Factory;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\Helpers\Bootstrap;
use Joomla\CMS\Toolbar\Toolbar;
use Joomla\CMS\Toolbar\ToolbarHelper;
use phpseclib3\Math\BigInteger\Engines\PHP;

/**
 * visinspector view
 *
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @since        Joomla 4.2
 */
class HtmlView extends BaseHtmlView {
	public $phpIni;
	public $mysqlIni;
	public $phpVersion;
	public $mysqlVersion;

	public function __construct(array $config) {
		parent::__construct($config);
		$this->phpIni = array();
		$this->phpVersion = '';
		$this->mysqlIni = array();
		$this->mysqlVersion = '';
	}

	function display($tpl = null) {
		\VisformsHelper::addSubmenu('visinspector');

		$phpValues = array();
		// get PHP version and OS
		$this->phpVersion = PHP_VERSION . ' (' . PHP_OS . ') ';
		$this->phpIni['version'] = $this->phpVersion;
		// prepare PHP variables to show
		$phpValues[] = 'allow_url_fopen';
		$phpValues[] = 'post_max_size';
		$phpValues[] = 'upload_max_filesize';
		$phpValues[] = 'xdebug.mode';
		$phpValues[] = 'xdebug.start_with_request';
		$phpValues[] = 'xdebug.client_port';
		$phpValues[] = 'xdebug.client_host';
		foreach ($phpValues as $value) {
			$this->phpIni[$value] = ini_get($value);
		}

		// MySQL part
		$db = Factory::getDbo();
		// get mySQL version
		$db->setQuery("SHOW VARIABLES WHERE Variable_Name LIKE 'version'");
		$results = $db->loadObjectList();
		foreach ($results as $object) {
			$this->mysqlVersion = $object->Value;
		}
		$this->mysqlIni['version'] = $this->mysqlVersion;
		// prepare MySQL variables to show
		$db->setQuery("SHOW VARIABLES WHERE 
		Variable_Name LIKE 'innodb_strict_mode' OR 
		Variable_Name LIKE 'internal_tmp_disk_storage_engine' OR 
		Variable_Name LIKE 'character_set_%' OR 
		Variable_Name LIKE 'collation_%' OR 
		Variable_Name LIKE 'max_%'
		");
		$results = $db->loadObjectList();
		foreach ($results as $object) {
			$this->mysqlIni[$object->Variable_name] = $object->Value;
		}

		$this->addToolbar();
		parent::display($tpl);
	}

	protected function addToolbar() {
		// load CSS
		\VisformsHelper::addCommonViewStyleCss();
		Bootstrap::loadCss();
		// load JavaScript
		\VisformsHelper::addCommonVisformsJS();

		// se title
		ToolbarHelper::title(Text::_('COM_VISFORMS') . ' - ' . Text::_('COM_VISFORMS_SUBMENU_INSPECTOR'), 'visform');
		// add toolbar buttons
		$toolbar = Toolbar::getInstance('toolbar');
		// add button: check installation
		$toolbar->standardButton('check-installation')
			->text(Text::_('COM_VISFORMS_INSPECTOR_BTN_INSTALLATION'))
			->icon('icon_ajax-wait icon-spinner spinner-border-sm')
			->onclick('visInspector.checkInstallation();');
		// add button: options
		if (Factory::getApplication()->getIdentity()->authorise('core.admin', 'com_visforms')) {
			ToolbarHelper::preferences('com_visforms');
		}

	}
}