var visAdmin = {
    version : '1.0.0',
    visField : {
        editValue: null,
        fieldsWithOptionlist: ['visf_multicheckbox', 'visf_radio', 'visf_select'],
        initPage: function () {
            this.typeFieldInit();
        },
        // hide parameters from "defaultvalue" for all field types
        hiddenProperties: function () {
            document.getElementById('visf_text').style.display = "none";
            document.getElementById('visf_email').style.display = "none";
            document.getElementById('visf_date').style.display = "none";
            document.getElementById('visf_url').style.display = "none";
            document.getElementById('visf_number').style.display = "none";
            document.getElementById('visf_password').style.display = "none";
            document.getElementById('visf_hidden').style.display = "none";
            document.getElementById('visf_textarea').style.display = "none";
            document.getElementById('visf_checkbox').style.display = "none";
            document.getElementById('visf_multicheckbox').style.display = "none";
            document.getElementById('visf_radio').style.display = "none";
            document.getElementById('visf_select').style.display = "none";
            document.getElementById('visf_file').style.display = "none";
            document.getElementById('visf_image').style.display = "none";
            document.getElementById('visf_reset').style.display = "none";
            document.getElementById('visf_submit').style.display = "none";
            document.getElementById('visf_fieldsep').style.display = "none";
            document.getElementById('visf_pagebreak').style.display = "none";
            document.getElementById('visf_calculation').style.display = "none";
            document.getElementById('visf_location').style.display = "none";
            document.getElementById('visf_signature').style.display = "none";
            document.getElementById('visf_multicheckboxsql').style.display = "none";
            document.getElementById('visf_radiosql').style.display = "none";
            document.getElementById('visf_selectsql').style.display = "none";
            this.hideFieldsWithOptionList();
        },
        hideFieldsWithOptionList: function () {
            let n = this.fieldsWithOptionlist.length;
            for (let i = 0; i < n; i++) {
                document.getElementById(this.fieldsWithOptionlist[i] + '_options').style.display = "none";
            }
        },
        showFieldWithOptionList: function (field) {
            let n = this.fieldsWithOptionlist.length;
            for (let i = 0; i < n; i++) {
                if (this.fieldsWithOptionlist[i] === field) {
                    document.getElementById(this.fieldsWithOptionlist[i] + '_options').style.display = "";
                }
            }
        },
        // initialise field, display parameters for selected field type
        typeFieldInit: function () {
            this.hiddenProperties();
            let ffield = 'visf_' + this.getSelectedFieldType();

            // no type set yet
            // or no hidden properties and so nothing to display
            if ((ffield != 'visf_0') && (ffield != 'visf_submit') && (ffield != 'visf_reset') && (ffield != 'visf_pagebreak')) {
                document.getElementById(ffield).style.display = "";
                this.showFieldWithOptionList(ffield);
            }
            this.setRequiredAsterix();
            this.editOnlyFieldChange();
            this.setGridSizesOptionsVisibility();
            this.preSelectSolitaryOptionOnChange();
            this.toggleReloadOnChange();
            this.renderAsDataListChange();
            this.setCustomTextPostionOptionVisiblity();
        },
        // perform actions which are necessary when the type of a field is changed
        typeFieldChange: function () {
            this.hiddenProperties();
            let ffield = 'visf_' + this.getSelectedFieldType();

            // no type set yet
            // or no hidden properties and so nothing to display
            if ((ffield != 'visf_0') && (ffield != 'visf_submit') && (ffield != 'visf_reset') && (ffield != 'visf_pagebreak')) {
                document.getElementById(ffield).style.display = "";
                this.showFieldWithOptionList(ffield);
            }
            // Insert an asterix for required options
            this.setRequiredAsterix()
            // Handle restsricts
            this.setGridSizesOptionsVisibility();
            this.setCustomTextPostionOptionVisiblity();
        },
        formatFieldDateChange: function (o, ffield, text) {
            if (text) {
                this.resetSelectValue(o, ffield);
                alert(text);
                return false;
            } else {
                let calendarsToChange = ['tdate_calender', 'tdate_calender_min', 'tdate_calender_max'];
                let n = calendarsToChange.length;
                for (let i = 0; i < n; i++) {
                    let el = document.getElementById('jform_defaultvalue_' + calendarsToChange[i]);
                    if (el) {
                        // set selected in dateformat select list to new value
                        this.formatFieldDateChangeSelected();

                        // setup calendar with correct dateformat
                        this.formatDateCalendarChange(calendarsToChange[i]);
                    }
                }
            }
        },
        formatDateChangeInputValue: function (id) {
            // get value of initial Date field
            let el = document.getElementById('jform_defaultvalue_' + id)
            let date = el.value;
            let month, year, day, formatted_date;

            // if there is a date value set, change date format acording to selected listbox value
            if (!date == "") {
                // find date delimiter
                let date_delimiter = date.match(/\/|-|\./);
                let date_parts = date.split(date_delimiter[0]);

                // get date parts. Each date_delimiter represents a defined date format and a fix position of date parts
                switch (date_delimiter[0]) {
                    case "/" :
                        month = date_parts[0];
                        day = date_parts[1];
                        year = date_parts[2];
                        break;
                    case "-" :
                        year = date_parts[0];
                        month = date_parts[1];
                        day = date_parts[2];
                        break;
                    case "." :
                        day = date_parts[0];
                        month = date_parts[1];
                        year = date_parts[2];
                        break;
                }

                // get new date output format
                let d_format = document.getElementById('jform_defaultvalue_tdateformat_row').value;

                // find date format delimiter
                let d_format_delimiter = d_format.match(/\/|-|\./);

                // construct the formated date string. Each date format delimiter represents a defined date format and a fix position on date parts
                switch (d_format_delimiter[0]) {
                    case '/' :
                        formatted_date = month + d_format_delimiter + day + d_format_delimiter + year;
                        break;
                    case '-' :
                        formatted_date = year + d_format_delimiter + month + d_format_delimiter + day;
                        break;
                    case '.' :
                        formatted_date = day + d_format_delimiter + month + d_format_delimiter + year;
                        break;
                }
                el.setAttribute('data-alt-value', formatted_date);
                el.value = formatted_date;
            }
        },
        formatFieldDateChangeSelected: function () {
            for (i = document.getElementById('jform_defaultvalue_tdateformat_row').options.length - 1; i >= 0; i--) {
                if (document.getElementById('jform_defaultvalue_tdateformat_row').options[i].getAttribute('selected')) {
                    document.getElementById('jform_defaultvalue_tdateformat_row').options[i].removeAttribute('selected');
                }
                if (document.getElementById('jform_defaultvalue_tdateformat_row').options[i].selected) {
                    document.getElementById('jform_defaultvalue_tdateformat_row').options[i].setAttribute('selected', 'selected');
                }
            }
        },
        formatDateCalendarChange: function (id) {
            // get new date output format
            let d_format = document.getElementById('jform_defaultvalue_tdateformat_row').value;
            let btn = (document).getElementById('jform_defaultvalue_' + id + '_btn');

            // get dateformat for php and for javascript
            d_format = d_format.split(';');

            this.formatDateChangeInputValue(id);
            let calendar = btn.parentNode.parentNode.parentNode.parentNode.querySelectorAll('.field-calendar')[0];
            let instance = calendar._joomlaCalendar;
            if (instance) {
                instance.params.dateFormat = d_format[1];
            }
        },
        // we need to restict some actions for fields which are restrictors and give an error message
        fieldUsed: function (o, ffield, msg) {
            if ((o.id.indexOf('editonlyfield') > 0) || (o.id.indexOf('HTMLEditor') > 0)) {
                let idx = o.selectedIndex;
                let selectedValue = o[idx].value;
                if (selectedValue == "0") {
                    return true;
                }
            }
            this.resetSelectValue(o, ffield);
            window.alert(msg);
            return false;
        },
        // set asterix in labels for parameters which are required
        // we cannot use Joomla! form field attribute required because we get an error when a hidden parameter which is required is not set and we try to save the visforms field
        setRequiredAsterix: function () {
            let el;
            let sel = this.getSelectedFieldType();
            switch (sel) {
                case 'checkbox' :
                    el = [document.getElementById('jform_defaultvalue_f_checkbox_attribute_value-lbl')];
                    break;
                case 'image':
                    el = [document.getElementById('jform_defaultvalue_f_image_attribute_alt-lbl')];
                    el.push(document.getElementById('jform_defaultvalue_f_image_attribute_src-lbl'));
                    break;
                case 'multicheckbox' :
                    el = [document.getElementById('jform_defaultvalue_f_multicheckbox_list_hidden-lbl')];
                    break;
                case 'select' :
                    el = [document.getElementById('jform_defaultvalue_f_select_list_hidden-lbl')];
                    break;
                case 'radio' :
                    el = [document.getElementById('jform_defaultvalue_f_radio_list_hidden-lbl')];
                    break;
                case 'location' :
                    el = [document.getElementById('jform_defaultvalue_f_location_defaultMapCenter_lat-lbl')];
                    el.push(document.getElementById('jform_defaultvalue_f_location_defaultMapCenter_lng-lbl'));
                    break;
                case 'calculation' :
                    el = [document.getElementById('jform_defaultvalue_f_calculation_equation-lbl')];
                    break;
                default :
                    break;
            }

            if (el) {
                let n = el.length;
                for (let i = 0; i < n; i++) {
                    this.changeLabel(el[i]);
                }
            }
        },
        // insert asterix in label
        changeLabel: function (el, index, arr) {
            let label = el.innerHTML + '<span class="star"> *</span>';
            el.innerHTML = label;
        },
        setGridSizesOptionsVisibility: function () {
            let sel = this.getSelectedFieldType();
            let el = document.getElementById('bootstrapGridSizes')
            if (el) {
                switch (sel) {
                    case '0':
                    case 'submit' :
                    case 'reset' :
                    case 'image' :
                    case 'pagebreak' :
                    case 'hidden' :
                        el.style.display = "none";
                        break;
                    default:
                        el.style.display = "";
                        break;
                }
            }
        },
        editOnlyFieldChange: function () {
            // remove all options except the default option from the field list in parameter equalTo
            let fieldtype = this.getSelectedFieldType();
            let editonly = document.getElementById('jform_' + 'editonlyfield');
            if (editonly) {
                let equalToList = document.getElementById('jform_defaultvalue_f_' + fieldtype + '_validate_equalTo');
                let showWhenList = document.getElementById('jform_defaultvalue_f_' + fieldtype + '_showWhen');
                let uncheckedValue = document.getElementById('jform_defaultvalue_f_' + fieldtype + '_unchecked_value');
                let idx = editonly.selectedIndex;
                if (editonly.options[idx].value === "1") {
                    // hide equalto and conditional fields
                    if (equalToList) {
                        equalToList.closest('.control-group').style.display = "none";
                    }
                    if (showWhenList) {
                        showWhenList.closest('.control-group').style.display = "none";
                    }
                    if (uncheckedValue) {
                        uncheckedValue.closest('.control-group').style.display = "none";
                    }
                } else {
                    // show equalto and conditional fields
                    if (equalToList) {
                        equalToList.closest('.control-group').style.display = "";
                    }
                    if (showWhenList) {
                        showWhenList.closest('.control-group').style.display = "";
                    }
                    if (uncheckedValue) {
                        uncheckedValue.closest('.control-group').style.display = "";
                    }
                }
            }
        },
        resetSelectValue: function (o, value) {
            let selectbox = document.getElementById(o.id);
            let optlength = selectbox.options.length;
            for (let i = 0; i < optlength; i++) {
                if (selectbox.options[i].value == value) {
                    selectbox.options[i].selected = true;
                    jQuery('#' + o.id).trigger('liszt:updated');
                }
            }
        },
        getSelectedFieldType: function () {
            let ft = document.getElementById('jform_typefield');
            let idx = ft.selectedIndex;
            return ft[idx].value;
        },
        toggleReloadOnChange: function () {
            let field = document.getElementById('jform_defaultvalue_f_selectsql_toggle_reload');
            if (field) {
                let showWhenList = document.getElementById('jform_defaultvalue_f_selectsql_showWhen');
                let reloadList = document.getElementById('jform_defaultvalue_f_selectsql_reload');
                let hideEmpty = document.getElementById('jform_defaultvalue_f_selectsql_hideOnEmptyOptionList');
                let preSelectSolitaryOption = document.getElementById('jform_defaultvalue_f_selectsql_preSelectSolitaryOption');
                let hideOnPreSelectedSolitaryOption = document.getElementById('jform_defaultvalue_f_selectsql_hideOnPreSelectedSolitaryOption');
                let editonly = document.getElementById('jform_' + 'editonlyfield');
                let dataList = document.getElementById('jform_defaultvalue_f_selectsql_render_as_datalist');
                let isEditOnly = false;
                let isDataList = false;
                if (editonly) {
                    if (editonly.options[editonly.selectedIndex].value === "1") {
                        isEditOnly = true;
                    }
                }
                if (dataList) {
                    if (dataList.options[dataList.selectedIndex].value === "1") {
                        isDataList = true;
                    }
                }
                let idx = field.selectedIndex;
                if (field.options[idx].value === "1") {
                    if (showWhenList) {
                        showWhenList.closest('.control-group').style.display = "none";
                    }
                    if (reloadList) {
                        reloadList.closest('.control-group').style.display = "";
                    }
                    if (hideEmpty) {
                        hideEmpty.closest('.control-group').style.display = "";
                    }
                    if (preSelectSolitaryOption) {
                        if (isDataList) {
                            preSelectSolitaryOption.closest('.control-group').style.display = "none";
                        } else {
                            preSelectSolitaryOption.closest('.control-group').style.display = "";
                            // show/hide dependant field according to this field's value
                            this.preSelectSolitaryOptionOnChange();
                        }
                    }
                } else {
                    if (showWhenList) {
                        if (isEditOnly) {
                            showWhenList.closest('.control-group').style.display = "none";
                        } else {
                            showWhenList.closest('.control-group').style.display = "";
                        }
                    }
                    if (reloadList) {
                        reloadList.closest('.control-group').style.display = "none";
                    }
                    if (hideEmpty) {
                        hideEmpty.closest('.control-group').style.display = "none";
                    }
                    if (preSelectSolitaryOption) {
                        preSelectSolitaryOption.closest('.control-group').style.display = "none";
                    }
                    if (hideOnPreSelectedSolitaryOption) {
                        hideOnPreSelectedSolitaryOption.closest('.control-group').style.display = "none";
                    }
                }
            }
        },
        preSelectSolitaryOptionOnChange: function () {
            let field = document.getElementById('jform_defaultvalue_f_selectsql_preSelectSolitaryOption');
            if (field) {
                let hideOnPreSelectedSolitaryOption = document.getElementById('jform_defaultvalue_f_selectsql_hideOnPreSelectedSolitaryOption');
                let idx = field.selectedIndex;
                if (field.options[idx].value === "1") {
                    if (hideOnPreSelectedSolitaryOption) {
                        hideOnPreSelectedSolitaryOption.closest('.control-group').style.display = "";
                    }
                } else {
                    if (hideOnPreSelectedSolitaryOption) {
                        hideOnPreSelectedSolitaryOption.closest('.control-group').style.display = "none";
                    }
                }
            }
        },
        renderAsDataListChange: function () {
            let field = document.getElementById('jform_defaultvalue_f_selectsql_render_as_datalist');
            if (field) {
                let customselectvaluetext = document.getElementById('jform_defaultvalue_f_selectsql_customselectvaluetext');
                let required = document.getElementById('jform_defaultvalue_f_selectsql_attribute_required');
                let custominfo = document.getElementById('jform_defaultvalue_f_selectsql_custominfo');
                let customerror = document.getElementById('jform_defaultvalue_f_selectsql_customerror');
                let multiple = document.getElementById('jform_defaultvalue_f_selectsql_attribute_multiple');
                let size = document.getElementById('jform_defaultvalue_f_selectsql_attribute_size');
                let preSelectSolitaryOption = document.getElementById('jform_defaultvalue_f_selectsql_preSelectSolitaryOption');
                let hideOnPreSelectedSolitaryOption = document.getElementById('jform_defaultvalue_f_selectsql_hideOnPreSelectedSolitaryOption');
                let idx = field.selectedIndex;
                if (field.options[idx].value === "1") {
                    if (customselectvaluetext) {
                        customselectvaluetext.closest('.control-group').style.display = "none";
                    }
                    if (required) {
                        required.closest('.control-group').style.display = "none";
                    }
                    if (custominfo) {
                        custominfo.closest('.control-group').style.display = "none";
                    }
                    if (customerror) {
                        customerror.closest('.control-group').style.display = "none";
                    }
                    if (multiple) {
                        multiple.closest('.control-group').style.display = "none";
                    }
                    if (size) {
                        size.closest('.control-group').style.display = "none";
                    }
                    // as we have a dataList and not select, these field options do not make any sence
                    // hide them
                    if (preSelectSolitaryOption) {
                        preSelectSolitaryOption.closest('.control-group').style.display = "none";
                    }
                    if (hideOnPreSelectedSolitaryOption) {
                        hideOnPreSelectedSolitaryOption.closest('.control-group').style.display = "none";
                    }
                } else {
                    if (customselectvaluetext) {
                        customselectvaluetext.closest('.control-group').style.display = "";
                    }
                    if (required) {
                        required.closest('.control-group').style.display = "";
                    }
                    if (custominfo) {
                        custominfo.closest('.control-group').style.display = "";
                    }
                    if (customerror) {
                        customerror.closest('.control-group').style.display = "";
                    }
                    if (multiple) {
                        multiple.closest('.control-group').style.display = "";
                    }
                    if (size) {
                        size.closest('.control-group').style.display = "";
                    }
                    // proper display values for preSelectSolitaryOption and hideOnPreSelectedSolitaryOption only depend on selected value of _reload Option
                    // and they are set properly by toggleReloadChange()
                    this.toggleReloadOnChange();
                }
            }
        },
        // clean field configuration form before submit; remove everything except the options of the selected field type
        removeUnused: function (selected) {
            var fieldType = ['text', 'email', 'date', 'url', 'number', 'password', 'hidden', 'textarea', 'checkbox', 'multicheckbox', 'radio', 'select', 'file', 'image', 'reset', 'submit', 'fieldsep', 'pagebreak', 'calculation', 'location', 'signature', 'multicheckboxsql', 'radiosql', 'selectsql'];
            var fieldTypesWithOptionlist = ['multicheckbox', 'radio', 'select'];
            for (var i in fieldType) {
                if (selected != fieldType[i]) {
                    try {
                        var elname = 'visf_' + fieldType[i];
                        var el = document.getElementById(elname);
                        el.parentNode.removeChild(el);
                    } catch (e) {
                    }
                }
                for (var j in fieldTypesWithOptionlist) {
                    if (selected != fieldTypesWithOptionlist[j]) {
                        try {
                            var elname = 'visf_' + fieldTypesWithOptionlist[j] + '_options';
                            var el = document.getElementById(elname);
                            el.parentNode.removeChild(el);
                        } catch (e) {
                        }
                    }
                }
            }
        },
        setCustomTextPostionOptionVisiblity: function () {
            let sel = this.getSelectedFieldType();
            let el = document.getElementById('jform_customtextposition');
            if (el) {
                let count = el.options.length;
                // option exists toggle it depending from field type
                if (count >= 4 ) {
                    switch (sel) {
                        case '0':
                        case 'submit' :
                        case 'reset' :
                        case 'image' :
                        case 'pagebreak' :
                        case 'hidden' :
                        case 'fieldsep':
                            el[3].style.display = "none";
                            // reset to default
                            el[0].selected = true;
                            break;
                        default:
                            el[3].style.display = "";
                            break;
                    }
                }
            }
        },
        testSqlStatement: function (event, button, emptyMessage, t) {
            event.preventDefault();
            var element = jQuery(button).parents('.sql-edit-controls');
            // textarea with sql-statement must have id attribute ending on _sql
            var sqlElement = jQuery(element).find('[id$=_sql]');
            var sql = sqlElement.val();
            // add class single_result to textarea with sql-statement in order to test using php loadResult
            var singleResult = sqlElement.hasClass('single_result') ? 'SingleResult' : '';
            var messageDiv = jQuery(button).siblings('.sql-message-field');
            if(sql) {
                // escape quotes
                sql = sql.replace(/"/g, '\\\"');
                // remove 'whitespace' character and trim blanks
                sql = sql.replace(/\s/g, ' ');
                sql.trim();
                // escape special characters
                sql = encodeURIComponent(sql);
                var waitDonut = jQuery(button).children('span');
                var data = 'data=' + JSON.stringify({ statement: sql, [t] : 1 });
                // show the waiting icon during the request
                visHelperAsync.startWaitDonut(waitDonut);
                jQuery.ajax({
                    type: 'POST',
                    // use differnt tasks, depending on whether we want to test for a single Result or an array of results
                    url: 'index.php?option=com_visforms&task=visfield.testSqlStatement'+singleResult,
                    data: data,
                    success: function(data, textStatus, jqXHR) {
                        visHelperAsync.stopWaitDonut();
                        jQuery(messageDiv).text(data.message);
                    },
                    error: function(jqXHR, textStatus, errorThrown) {
                        visHelperAsync.stopWaitDonut();
                        // give error feedback
                        jQuery(messageDiv).text('error');
                    },
                    dataType: 'json',
                    async: true
                });
            }
            else {
                jQuery(messageDiv).text(emptyMessage);
            }
        },
    },
}

var visHelperAsync = {
    startWaitDonut: function (waitDonut) {
        jQuery(waitDonut).removeClass('icon-spinner').addClass('spinner-border');
    },
    stopWaitDonut: function (waitDonut = '.icon_ajax-wait') {
        jQuery(waitDonut).removeClass('spinner-border').addClass('icon-spinner');
    }
};

(function ($){
    $.extend($.fn, {
        createVisformsAjaxSubmit: function (options) {
            // this is list of textareas with class .visajax-submit
            jQuery(this).each( function (i, el) {
                // this is a single textarea
                var visformsAjaxSubmit = $.data(this, "visformsAjaxSubmit");
                if (visformsAjaxSubmit) {
                    return visformsAjaxSubmit;
                }
                    visformsAjaxSubmit = new $.visformsAjaxSubmit(options, this);
                    $.data(this, "visformsAjaxSubmit", visformsAjaxSubmit);
                }
            );
        },
    });
    $.visformsAjaxSubmit = function (options, element) {
        var defaults = {
            texts: {
                emptyMessage: "Textarea is empty",
                errorMessage: 'Error saving changes',
                submitButtonLabel: 'Apply',
                cancelButtonLabel: 'Cancel'
            },
            params: {
                t : '',
                parentClass : 'control-group',
                textareaClass : 'visajax-submit',
                saveBtnClass : 'visajax-submit-button',
                cancelBtnClass : 'visajax-cancel-button',
                donutClass : 'div_ajax-call-wait',
                donutIconClass : 'icon_ajax-call-wait',
                messageClass: 'message-field',
                safeEmpty: true,
                // fid: 0,
                url : '',
                controlsTemplate: ''
            }
        };
        var settings = $.extend(true, {}, defaults, options);
        var emptyMessage = settings.texts.emptyMessage;
        var errorMessage = settings.texts.errorMessage;
        var submitButtonLabel = settings.texts.submitButtonLabel;
        var cancelButtonLabel = settings.texts.cancelButtonLabel;
        var t = settings.params.t;
        let parentClass = settings.params.parentClass;
        var textareaClass = settings.params.textareaClass;
        var saveBtnClass = settings.params.saveBtnClass;
        var cancelBtnClass = settings.params.cancelBtnClass;
        var donutClass = settings.params.donutClass;
        var donutIconClass = settings.params.donutIconClass;
        var messageClass = settings.params.messageClass;
        var safeEmpty = settings.params.safeEmpty;
        var url = settings.params.url;
        var controlsTemplate = settings.params.controlsTemplate;
        var textAreaId = $(element).attr('id');
        // get the field name from name attribut (last segment) of jform[][][]
        var fieldName = $(element).attr('name').match(/\w+/g).pop();
        var tableName = $(element).attr('data-ajax-table');
        $('#' + textAreaId).after(controlsTemplate);
        $('#' + textAreaId).on('click', function (event) {
            event.preventDefault();
            ajaxSubmit.enableAndShowButtons(event);
            // save textarea content on first click into the textarea in order to enable a cancel/reset to this value
            ajaxSubmit.cacheCurrentValue(event);
        });
        // Add event hanlder to action buttons of this field
        $('#' + textAreaId).parents('.' + parentClass).find('.' + saveBtnClass).on('click', function(event) {
            event.preventDefault();
            ajaxSubmit.saveAjaxTextarea(event);
        });
        $('#' + textAreaId).parents('.' + parentClass).find('.' + cancelBtnClass).on('click', function(event) {
            event.preventDefault();
            ajaxSubmit.restoreCurrentValueFromCache(event);
        });
        var ajaxSubmit = {
            saveAjaxTextarea : function (event) {
                event.preventDefault();
                let btn = event.target;
                let text = $(btn).parents('.' + parentClass).find('.' + textareaClass).val();
                let messageDiv = $(btn).siblings('.' + messageClass);
                if (text || safeEmpty) {
                    //var waitDonut = $(btn).siblings('.' + donutClass).find('.' + donutIconClass);
                    var waitDonut = $(btn).children('span');
                    var data = {
                        //fid: fid,
                        fieldName: fieldName,
                        text: text,
                        [t] : 1,
                        tableName: tableName
                    }
                    // show the waiting icon during the request
                    visHelperAsync.startWaitDonut(waitDonut);
                    $.ajax({
                        type: 'POST',
                        url: url, //'index.php?option=com_visforms&task=visform.saveAjaxTextarea',
                        data: data,
                        dataType: "json",
                        encode: true,
                        async: true,
                        success: function(data, textStatus, jqXHR) {
                            let responseStatusClasses = (data.success) ? 'alert alert-success': 'alert alert-danger';
                            visHelperAsync.stopWaitDonut();
                            ajaxSubmit.disableAndHideButtons(event);
                            // changes are saved, there is a new current value in the textarea
                            ajaxSubmit.cleanCurrentValueCache(event);
                            $(messageDiv).text(data.message).addClass(responseStatusClasses);
                        },
                        error: function(jqXHR, textStatus, errorThrown) {
                            visHelperAsync.stopWaitDonut();
                            // give error feedback
                            $(messageDiv).text(errorMessage).addClass('alert alert-danger');
                        },
                    });
                }
                else {
                    $(messageDiv).text(emptyMessage).addClass('alert alert-success');
                }
            },
            enableAndShowButtons : function (event) {
                var btn = event.target;
                $(btn).parents('.' + parentClass).find('.' + saveBtnClass).prop('disabled', false).show();
                $(btn).parents('.' + parentClass).find('.' + cancelBtnClass).prop('disabled', false).show();
                // empty message dive remove all classes except the messageClass
                $(btn).siblings('.' + messageClass).removeAttr('class').addClass(messageClass).text('');
            },
            disableAndHideButtons: function (event) {
                $(event.target).parents('.' + parentClass).find('.' + saveBtnClass).prop('disabled', true).hide();
                $(event.target).parents('.' + parentClass).find('.' + cancelBtnClass).prop('disabled', true).hide();
            },
            cacheCurrentValue : function (event) {
                var el = $(event.target).parents('.' + parentClass).find('.' + textareaClass);
                var currentValue = $.data( el[0], "currentValue" );
                if ((!currentValue) || typeof currentValue === "undefined") {
                    $.data( el[0], "currentValue", $(el).val());
                }
            },
            cleanCurrentValueCache : function (event) {
                var el = $(event.target).parents('.' + parentClass).find('.' + textareaClass);
                var currentValue = $.data( el[0], "currentValue" );
                if ((currentValue)) {
                    $.removeData( el[0], "currentValue");
                }
            },
            restoreCurrentValueFromCache : function (event) {
                var el = $(event.target).parents('.' + parentClass).find('.' + textareaClass);
                var currentValue = $.data( el[0], "currentValue" );
                if ((currentValue)) {
                    $(el).val(currentValue);
                    ajaxSubmit.cleanCurrentValueCache(event);
                }
                this.disableAndHideButtons(event);
            },
        }
    }
}(jQuery));