<?php
/**
 * Visforms controller for VisCpanel
 *
 * @author       Aicha Vack
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */

namespace Visolutions\Component\Visforms\Administrator\Controller;

defined('_JEXEC') or die('Direct Access to this location is not allowed.');

use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Controller\BaseController;
use Joomla\CMS\MVC\Factory\MVCFactoryInterface;
use Joomla\CMS\Session\Session;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Filesystem\File;
use Visolutions\Component\Visforms\Administrator\Model\VisdataModel;

class VisinspectorController extends ItemControllerBase
{
    function __construct($config = array(), MVCFactoryInterface $factory = null, $app = null, $input = null){
        parent::__construct($config, $factory, $app, $input);
    }

	public function checkInstallation() {
		// get the data
		if (!$this->checkAjaxSessionToken()) {
			// return wrong session token
			$message = Text::_("COM_VISFORMS_AJAX_INVALID_TOKEN");
			$success = false;
			$buffer = ob_get_contents();
			ob_clean();
			$response = array("success" => $success, 'message' => $message);
			$document = $this->app->getDocument();
			$document->setMimeEncoding('application/json');
			echo json_encode($response);
			$this->app->close();
		}

		$installedVFS = \VisformsAEF::checkAEF(\VisformsAEF::$subscription);
		$message = '';
		$success = true;

		$missingVF = array();
		$this->processFileList($missingVF,'vf-deployment-list.txt');
		$missingVFS = array();
		if ($installedVFS) {
			// only if VFS installed
			$this->processFileList($missingVFS,'vfs-deployment-list.txt');
		}

		// return success
		$buffer = ob_get_contents();
		ob_clean();
		$response = array("success" => $success, 'message' => $message,
		                  'vf' => (bool) $missingVF, 'vfs' => (bool) $missingVFS,
		                  'vflist' => $missingVF, 'vfslist' => $missingVFS,
		                  'installedVFS' => $installedVFS);
		$document = $this->app->getDocument();
		$document->setMimeEncoding('application/json');
		echo json_encode($response);
		$this->app->close();
	}

	// implementation

	private function processFileList(array &$missing, string $name): bool {
		$path = JPATH_ADMINISTRATOR . "/components/com_visforms/$name";
		if( !file_exists($path)) {
			return false;
		}

		$lines = file($path, FILE_IGNORE_NEW_LINES);
		foreach ($lines as $line) {
			$file = JPATH_ROOT . $line;
			if( !file_exists($file)) {
				$missing[] = $line;
			}
		}

		return true;
	}
}