<?php
/**
 * Visforms field submit class
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */

// no direct access
defined('_JEXEC') or die('Restricted access');
use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Event\AbstractEvent;

class VisformsFieldSubmit extends VisformsField
{
    protected function setField() {
        $this->cleanFieldProperties();
        $this->extractDefaultValueParams();
	    $this->extractGridSizesParams();
        PluginHelper::importPlugin('visforms');
        $dispatcher = Factory::getApplication()->getDispatcher();
        $event = AbstractEvent::create('onVisfieldBeforeCreate', array('context' => 'com_visforms.field', 'subject' => $this->field, 'form' => $this->form));
        $dispatcher->dispatch('onVisfieldBeforeCreate', $event);
        $this->setIndividualProperties();
        $this->setFieldDefaultValue();
        $this->setCustomJs();
    }
    

    protected function setFieldDefaultValue() {
        //Nothing to do for Submit buttons
    }
    
    protected function setIndividualProperties() {
        $this->field->isButton = true;
    }
    
    protected function setDbValue() {
        return;
    }

    protected function setRedirectParam() {
        return;
    }

    protected function cleanFieldProperties() {
        //$this->field->customtext = '';
    }
}