<?php
/**
 * Form component for Joomla
 *
 * @author       Aicha Vack
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6 
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\Version;

$JVersion = new Version;
$test = $JVersion::MAJOR_VERSION .'.'. $JVersion::MINOR_VERSION . '.'. $JVersion::PATCH_VERSION;
if (version_compare($test, '6.0.0', 'lt')) {
	// load Visforms classes
	// Register helper class
	/* @deprecated 5.5.
	 * File will be removed in Visforms 6.0 without replacement
	 */
	if (!defined('VISFORMS_INCLUDED')) {
		define('VISFORMS_INCLUDED', 'v3.10.4');
		// certainly used in layout and tmpl files
		JLoader::register('VisformsHelper', __DIR__ . '/helpers/visforms.php');
		// certainly used in layout and tmpl files
		JLoader::register('VisformsmediaHelper', __DIR__ . '/helpers/visformsmedia.php');
		// not used in layout and tmpl files
		JLoader::register('VisformsConditionsHelper', __DIR__ . '/helpers/visformsconditions.php');
		// certainly used in layout and tmpl files
		JLoader::register('VisformsAEF', __DIR__ . '/helpers/aef/aef.php');
		// not used in layout and tmpl files
		JLoader::register('visFormCsvHelper', __DIR__ . '/helpers/csv/visFormCsvHelper.php');
		// not used in layout and tmpl files
		JLoader::register('visFormsImportExportHelper', __DIR__ . '/helpers/visFormsImportExportHelper.php');
		// not used in layout and tmpl files
		JLoader::register('visFormsImportHelper', __DIR__ . '/helpers/visFormsImportHelper.php');
		// not used in layout and tmpl files
		JLoader::register('visFormsExportHelper', __DIR__ . '/helpers/visFormsExportHelper.php');
		// not used in layout and tmpl files
		JLoader::register('visFormsSortOrderHelper', __DIR__ . '/helpers/visFormsSortOrderHelper.php');
		// not used in layout and tmpl files
		JLoader::register('visFormsBfImportHelper', __DIR__ . '/helpers/visFormsBfImportHelper.php');
		// load component library main classes
		// certainly used in layout and tmpl files
		JLoader::discover('Visforms', JPATH_SITE . '/components/com_visforms/lib/');
		// not used in layout and tmpl files
		JLoader::discover('Visforms', JPATH_ADMINISTRATOR . '/components/com_visforms/lib/');
		if (Factory::getApplication()->isClient('site')) {
			// not used in layout and tmpl files
			JLoader::register('VisformsEditorHelper', JPATH_SITE . '/components/com_visforms/helpers/editor.php');
		}
	}
}