<?php

/**
 * Visform field Selectfromdb
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 */
namespace Visolutions\Component\Visforms\Administrator\Field;

// no direct access
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Form\Field\ListField;
use Joomla\Database\DatabaseInterface;

class FormlistField extends ListField
{

	public $type = 'Formlist';

	protected function getInput() {
		// Get the field options.
        $options = array_merge($this->getOptions(), $this->getFormList());
		$data = $this->getLayoutData();
		$data['options'] = (array) $options;
		return $this->getRenderer($this->layout)->render($data);
	}

	private function getFormList() {
        $db = Factory::getContainer()->get(DatabaseInterface::class);
        $query = $db->createQuery();
        $query->select($db->quoteName('a.id', 'value') . ', ' . $db->quoteName('a.title', 'text'))
            ->from($db->quoteName('#__visforms', 'a'));
        // Get the options
        try {
            $db->setQuery($query);
            $options = $db->loadObjectList();
        }
        catch (\RuntimeException $e) {
            $options = array();
        }
        return $options;
	}
}
