<?php
/**
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2018 vi-solutions
 */
namespace Visolutions\Component\Visforms\Administrator\Visfield\PlaceholderEntry;

// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Language\Text;
use Visolutions\Component\Visforms\Administrator\Helper\VisformsHelper;
use Visolutions\Component\Visforms\Administrator\Visfield\VisfieldPlaceholderEntry;

class CurrentDateEntry extends VisfieldPlaceholderEntry {

    protected static $customParams = array(
        'DATETIME' => 'COM_VISFORMS_PLACEHOLDER_PARAM_CURRENT_DATE_DATE_TIME',
    );

	public function __construct($param, $rawData, $field) {
		$rawData = VisformsHelper::getFormattedServerDateTime('now', Text::_('DATE_FORMAT_LC4'));
		parent::__construct($param, $rawData, $field);
	}
	public function getReplaceValue() {
        $customParams = self::$customParams;
        $dateFormat = Text::_('DATE_FORMAT_LC4');
        if (!empty($this->param) && array_key_exists($this->param, $customParams)) {
            switch ($this->param) {
                case 'DATETIME' :
                    $dateFormat = Text::_('DATE_FORMAT_LC6');
            }
        }
		return VisformsHelper::getFormattedServerDateTime('now', $dateFormat);
	}
}