<?php
/**
 * viscpanel default view for Visforms
 *
 * @author       Aicha Vack
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6 
 */

//no direct access
 defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Component\ComponentHelper;
use Visolutions\Component\Visforms\Administrator\Helper\AefHelper;

HTMLHelper::_('bootstrap.framework');
$issub = AefHelper::checkAEF();
$component = ComponentHelper::getComponent('com_visforms');
$dlid = $component->params->get('downloadid', '');
$demoFormInstalled = $component->params->get('demoFormInstalled', '');
$extensiontypetag = ($issub) ? 'COM_VISFORMS_SUBSCRIPTION' : 'COM_VISFORMS_PAYED_EXTENSION';
$dlidInfoFullHtmlLink = '<a href="'.$this->dlidInfoLink.'" target="_blank" rel="noopener">'.Text::_('COM_VISFORMS_FIELD_DOWNLOAD_ID_LINK_TEXT').'</a>';
?>

<div class="row"><?php
    if (!empty( $this->sidebar)) { ?>
    <div id="j-sidebar-container" class="col-md-3 col-xl-2">
    <?php echo $this->sidebar; ?>
    </div><?php } ?>
    <div class="<?php if (!empty($this->sidebar)) {echo 'col-md-9 col-xl-10'; } else { echo 'col-12'; } ?>">
        <div id="j-main-container" class="j-main-container">
            <div id="vfcpanel">
    <?php  if (isset($this->update_message)) {echo $this->update_message;} ?>
    <div class="row">
        <div class="col-lg-6 mt-3">
            <h1><?php echo Text::_('COM_VISFORMS_SUBMENU_CPANEL_LABEL'); ?></h1>
        </div>
    </div>
            <div class="row">
                <div class="col-lg-6 mt-3">
            <h3><?php echo Text::_('COM_VISFORMS_CPANEL_OPERATIIONS_HEADER'); ?></h3>
            <div class="clearfix">
                <div class="cpanel">
                    <a href="index.php?option=com_visforms&amp;view=visforms"><i class="icon-stack"></i><span><?php echo Text::_('COM_VISFORMS_SUBMENU_FORMS'); ?></span></a>
                </div>
                <?php if ($this->canDo->get('core.create')) : ?>
                <div class="cpanel">
                    <a href="index.php?option=com_visforms&amp;task=visform.add" ><i class="icon-file-plus"></i><span><?php echo Text::_('COM_VISFORMS_FORM_NEW'); ?></span></a>
                </div>
                <?php endif; ?>
                <?php if (Factory::getApplication()->getIdentity()->authorise('core.admin', 'com_visforms')) : ?>
                <div class="cpanel">
                    <a href="<?php echo $this->preferencesLink; ?>" ><i class="icon-options"></i><span><?php echo Text::_('JTOOLBAR_OPTIONS'); ?></span></a>
                </div>
                <?php endif; ?>
                <?php if ($this->canDo->get('core.edit.css')) : ?>
                <div class="cpanel">
                            <a href="index.php?option=com_visforms&amp;task=viscpanel.edit_css" ><i class="icon-pencil"></i><span><?php echo Text::_('COM_VISFORMS_EDIT_CSS'); ?></span></a>
                </div>
                <?php endif; ?>
            </div>

        </div>
                <div class="col-lg-6 mt-3">
            <h3><?php echo Text::_('COM_VISFORMS_CPANEL_INFO_SUPPORT_HEADER'); ?></h3>
            <div class="clearfix">
                <div class="cpanel">
                    <a href="<?php echo $this->documentationLink; ?>" target="_blank" rel="noopener"><i class="icon-info-circle"></i><span><?php echo Text::_('COM_VISFORMS_CPANEL_DOCUMENTATION_BUTTON_LABEL');?></span></a>
                </div>
                <div class="cpanel">
                    <a href="<?php echo $this->forumLink; ?>" target="_blank" rel="noopener"><i class="icon-question-circle"></i><span><?php echo Text::_('COM_VISFORMS_CPANEL_FORUM_BUTTON_LABEL');?></span></a>
                </div>
            </div>

        </div>
    </div>
            <div class="row">
                <div class="col-lg-6 mt-3">
            <?php if ((empty($issub))) : ?>
            <h3><?php echo Text::_('COM_VISFORMS_CPANEL_ADDITIONAL_FEATURE_HEADER'); ?></h3>
            <div id="subscribe" class="alert alert-block alert-info">
                <p class="text-center"><?php echo Text::_('COM_VISFORMS_CPANEL_ADDITIONAL_FEATURE_TEXT'); ?></p>
                <p class="text-center visible-desktop"><?php echo Text::_('COM_VISFORMS_CPANEL_ADDITIONAL_FEATURE_LIST'); ?></p>
                        <p class="text-center mt-3"><a href="<?php echo $this->versionCompareLink; ?>" target="_blank" rel="noopener" class="btn btn-light btn-sm"><?php echo Text::_('COM_VISFORMS_CPANEL_ADDITIONAL_FEATURE_COMPARE_VERSIONS'); ?></a>
                        <a href="<?php echo $this->buySubsLink; ?>" target="_blank" rel="noopener" class="btn btn-light btn-sm"><?php echo Text::_('COM_VISFORMS_CPANEL_ADDITIONAL_FEATURE_BUY_SUBSCRIPTION'); ?></a></p>
            </div>
            <?php endif; ?>
            <?php if ((!empty($issub))) : ?>
                <h3><?php echo Text::sprintf('COM_VISFORMS_CPANEL_MANAGE_SUBSCRIPTION_HEADER', Text::_($extensiontypetag)); ?></h3>
                <div class="clearfix">
                    <div class="cpanel">
                        <a href="#downloadid" data-bs-toggle="modal"><i class="icon-unlock "></i><span><?php echo Text::_('COM_VISFORMS_CPANEL_UPDATE_BUTTON_LABEL'); ?></span></a>
                    </div>
                    <div class="cpanel">
                        <a href=<?php echo $this->dlidInfoLink; ?>" target="_blank" rel="noopener"><i class="icon-eye-open "></i><span><?php echo Text::_('COM_VISFORMS_CPANEL_MANAGE_BUTTON_LABEL'); ?></span></a>
                    </div><?php
                    // todo enable if
                    if (empty($demoFormInstalled) && Factory::getApplication()->getIdentity()->authorise('core.create', 'com_visforms')) { ?>
                        <div class="cpanel">
                        <a href="<?php echo $this->installPdfDemoFormLink; ?>"><i class="icon-drawer"></i><span
                                    class="mt-0"><?php echo Text::_('COM_VISFORMS_CPANEL_INSTALL_PDF_DEMO_LABEL'); ?></span></a>
                        </div><?php
                    }
                    ?>
                </div>
                <?php if(empty($this->dlId)) { ?>
                    <div class="alert alert-block alert-warning">
                        <p><?php echo Text::sprintf('COM_VISFORMS_CPANEL_ENTER_DOWNLOAD_ID', $dlidInfoFullHtmlLink); ?></p>
                    </div>
                <?php } ?>
            <?php endif; ?>

        </div>
        <div class="col-lg-6 mt-3">
            <h3><?php echo Text::_('COM_VISFORMS_CPANEL_CONTRIBUTE_HEADER'); ?></h3>
            <div class="clearfix">
                <div class="cpanel">
                    <a href="<?php echo $this->jedLink; ?>" target="_blank" rel="noopener"><i class="icon-star"></i><span><?php echo Text::_('COM_VISFORMS_CPANEL_REVIEW_BUTTON_LABEL');?></span></a>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6 mt-3">
        <h3><?php echo Text::_('COM_VISFORMS_HELP_GETTING_STARTED_HEADER'); ?></h3>
        <div class="accordion" id="first-steps">
                <div class="card">
                    <div class="card-header">
                        <a data-bs-toggle="collapse" data-bs-parent="#first-steps" href="#createform">
                        <?php echo Text::_('COM_VISFORMS_CREATE_FORM'); ?>
                    </a>
                </div>
                    <div id="createform" class="collapse">
                        <div class="card-block">
                        <ul>
                            <li><?php echo Text::_('COM_VISFORMS_CREATE_FORM_STEP1'); ?></li>
                            <li><?php echo Text::_('COM_VISFORMS_CREATE_FORM_STEP2'); ?></li>
                            <li><?php echo Text::_('COM_VISFORMS_CREATE_FORM_STEP3'); ?></li>
                        </ul>
                    </div>
                </div>
            </div>
                <div class="card">
                    <div class="card-header">
                        <a data-bs-toggle="collapse" data-bs-parent="#first-steps" href="#addfields">
                        <?php echo Text::_('COM_VISFORMS_ADD_FIELDS'); ?>
                    </a>
                </div>
                    <div id="addfields" class=" collapse">
                        <div class="card-block">
                        <ul>
                            <li><?php echo Text::_('COM_VISFORMS_ADD_FIELDS_STEP1'); ?></li>
                            <li><?php echo Text::_('COM_VISFORMS_ADD_FIELDS_STEP2'); ?></li>
                            <li><?php echo Text::_('COM_VISFORMS_ADD_FIELDS_STEP3'); ?></li>
                            <li><?php echo Text::_('COM_VISFORMS_ADD_FIELDS_STEP4'); ?></li>
                        </ul>
                    </div>
                </div>
            </div>
                <div class="card">
                    <div class="card-header">
                        <a data-bs-toggle="collapse" data-bs-parent="#first-steps" href="#addsubmit">
                        <?php echo Text::_('COM_VISFORMS_ADD_SUBMIT_BUTTON'); ?>
                    </a>
                </div>
                    <div id="addsubmit" class="collapse">
                        <div class="card-block">
                        <ul>
                            <li><?php echo Text::_('COM_VISFORMS_ADD_SUBMIT_BUTTON_STEP1'); ?></li>
                        </ul>
                    </div>
                </div>
            </div>
                <div class="card">
                    <div class="card-header">
                        <a data-bs-toggle="collapse" data-bs-parent="#first-steps" href="#createmenu">
                        <?php echo Text::_('COM_VISFORMS_FIRST_STEPS_ADD_MENU_ITEM'); ?>
                    </a>
                </div>
                    <div id="createmenu" class=" collapse">
                        <div class="card-block">
                        <ul>
                            <li><?php echo Text::_('COM_VISFORMS_FIRST_STEPS_ADD_MENU_ITEM_STEP1'); ?></li>
                            <li><?php echo Text::_('COM_VISFORMS_FIRST_STEPS_ADD_MENU_ITEM_STEP2'); ?></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
        </div>
        <?php  if (!empty($this->showBfFormsImport) && Factory::getApplication()->getIdentity()->authorise('core.create', 'com_visforms')) { ?>
        <div class="col-md-6 mt-3">
            <h3><?php echo Text::_('COM_VISFORMS_CPANEL_IMPORT_BREEZING_FORMS'); ?></h3>
            <div id="bfimport" class="alert alert-block alert-info">
            <p class="text-center"><?php echo Text::_('COM_VISFORMS_CPANEL_BFFORMS_DESCRIPTION'); ?></p>
            <p class="text-center mt-3"><a href="<?php echo $this->bfImportDocuLink; ?>" target="_blank" rel="noopener" class="btn btn-light btn-sm"><?php echo Text::_('COM_VISFORMS_CPANEL_BFFORMS_DOCUMENTATION'); ?></a></p>
            <p class="text-center mt-3"><a href="<?php echo $this->importBfFormsLink; ?>"  class="btn btn-light btn-sm"><?php echo Text::_('COM_VISFORMS_CPANEL_START_IMPORT_BREEZING_FORMS'); ?></a> <a href="<?php echo $this->hideBFImportInfoLink; ?>" class="btn btn-light btn-sm"><?php echo Text::_('COM_VISFORMS_CPANEL_DECLINE_IMPORT_BREEZING_FORMS'); ?></a></p>
            </div>
        </div><?php
        } ?>
    </div>
            <div class="row">
                <div class="col-md-12 mt-3">
            <h3><?php echo Text::_('COM_VISFORMS_CPANEL_TRANSLATIONS'); ?></h3>
            <p>
                <a href="<?php echo $this->translationsLink; ?>" target="_blank" rel="noopener" title="da-dk"><img class="img-bordered" src="<?php echo Uri::root(); ?>/media/com_visforms/img/cs_cz.gif" alt="cs-cz"/></a>
                <a href="<?php echo $this->translationsLink; ?>" target="_blank" rel="noopener" title="da-dk"><img class="img-bordered" src="<?php echo Uri::root(); ?>/media/com_visforms/img/da_dk.gif"  alt="da-dk"/></a>
                <a href="<?php echo $this->translationsLink; ?>" target="_blank" rel="noopener" title="de-at"><img class="img-bordered" src="<?php echo Uri::root(); ?>/media/com_visforms/img/de_at.gif" alt="de-at"/></a>
                <a href="<?php echo $this->translationsLink; ?>" target="_blank" rel="noopener" title="de-ch"><img class="img-bordered" src="<?php echo Uri::root(); ?>/media/com_visforms/img/de_ch.gif" alt="de-ch"/></a>
                <a href="<?php echo $this->translationsLink; ?>" target="_blank" rel="noopener" title="de-de"><img class="img-bordered" src="<?php echo Uri::root(); ?>/media/com_visforms/img/de_de.gif" alt="de-de"/></a>
                <a href="<?php echo $this->translationsLink; ?>" target="_blank" rel="noopener" title="de-li"><img class="img-bordered" src="<?php echo Uri::root(); ?>/media/com_visforms/img/de_li.gif" alt="de-li"/></a>
                <a href="<?php echo $this->translationsLink; ?>" target="_blank" rel="noopener" title="de-lu"><img class="img-bordered" src="<?php echo Uri::root(); ?>/media/com_visforms/img/de_lu.gif" alt="de-lu"/></a>
                <a href="<?php echo $this->translationsLink; ?>" target="_blank" rel="noopener" title="el-gr"><img class="img-bordered" src="<?php echo Uri::root(); ?>/media/com_visforms/img/el_gr.gif" alt="el-gr"/></a>
                <a href="<?php echo $this->translationsLink; ?>" target="_blank" rel="noopener" title="es-es"><img class="img-bordered" src="<?php echo Uri::root(); ?>/media/com_visforms/img/es_es.gif" alt="es-es"/></a>
                <a href="<?php echo $this->translationsLink; ?>" target="_blank" rel="noopener" title="fr-fr"><img class="img-bordered" src="<?php echo Uri::root(); ?>/media/com_visforms/img/fr_fr.gif" alt="fr-fr"/></a>
                <a href="<?php echo $this->translationsLink; ?>" target="_blank" rel="noopener" title="it-it"><img class="img-bordered" src="<?php echo Uri::root(); ?>/media/com_visforms/img/it_it.gif" alt="it-it"/></a>
                <a href="<?php echo $this->translationsLink; ?>" target="_blank" rel="noopener" title="he-il"><img class="img-bordered" src="<?php echo Uri::root(); ?>/media/com_visforms/img/he_il.gif" alt="he-il"/></a>
                <a href="<?php echo $this->translationsLink; ?>" target="_blank" rel="noopener" title="hu-hu"><img class="img-bordered" src="<?php echo Uri::root(); ?>/media/com_visforms/img/hu_hu.gif" alt="hu-hu"/></a>
                <a href="<?php echo $this->translationsLink; ?>" target="_blank" rel="noopener" title="ja-jp"><img class="img-bordered" src="<?php echo Uri::root(); ?>/media/com_visforms/img/ja_jp.gif" alt="jp-jp"/></a>
                <a href="<?php echo $this->translationsLink; ?>" target="_blank" rel="noopener" title="lt-lt"><img class="img-bordered" src="<?php echo Uri::root(); ?>/media/com_visforms/img/lt_lt.gif" alt="lt-lt"/></a>
                <a href="<?php echo $this->translationsLink; ?>" target="_blank" rel="noopener" title="nl-nl"><img class="img-bordered" src="<?php echo Uri::root(); ?>/media/com_visforms/img/nl_nl.gif" alt="nl-nl"/></a>
                <a href="<?php echo $this->translationsLink; ?>" target="_blank" rel="noopener" title="pl-pl"><img class="img-bordered" src="<?php echo Uri::root(); ?>/media/com_visforms/img/pl_pl.gif" alt="pl-pl"/></a>
                <a href="<?php echo $this->translationsLink; ?>" target="_blank" rel="noopener" title="pt-br"><img class="img-bordered" src="<?php echo Uri::root(); ?>/media/com_visforms/img/pt_br.gif" alt="pt-br"/></a>
                <a href="<?php echo $this->translationsLink; ?>" target="_blank" rel="noopener" title="ru-ru"><img class="img-bordered" src="<?php echo Uri::root(); ?>/media/com_visforms/img/ru_ru.gif" alt="ru-ru"/></a>
                <a href="<?php echo $this->translationsLink; ?>" target="_blank" rel="noopener" title="sk-sk"><img class="img-bordered" src="<?php echo Uri::root(); ?>/media/com_visforms/img/sk_sk.gif" alt="sk-sk"/></a>
                <a href="<?php echo $this->translationsLink; ?>" target="_blank" rel="noopener" title="sv_se"><img class="img-bordered" src="<?php echo Uri::root(); ?>/media/com_visforms/img/sv_se.gif" alt="sv-se"/></a>
                <a href="<?php echo $this->translationsLink; ?>" target="_blank" rel="noopener" title="tr-tr"><img class="img-bordered" src="<?php echo Uri::root(); ?>/media/com_visforms/img/tr_tr.gif" alt="tr-tr"/></a>
                <a href="<?php echo $this->translationsLink; ?>" target="_blank" rel="noopener" title="sr-yu"><img class="img-bordered" src="<?php echo Uri::root(); ?>/media/com_visforms/img/sr_yu.gif" alt="sr-yu"/></a>
            </p>
        </div>
    </div>
    <?php echo HTMLHelper::_('visforms.creditsBackend'); ?>
    <div id="downloadid" class="joomla-modal modal fade" tabindex="-1" role="dialog" aria-labelledby="downloadid" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <form class="form-horizontal pb-0 mb-0" action="<?php echo Route::_($this->dlidFormLink); ?>" method="post">
                <div class="modal-header">
                    <h3 class="modal-title"><?php echo Text::sprintf('COM_VISFORMS_CPANEL_MODAL_UPDATE_HEADER', Text::_($extensiontypetag));?></h3>
                    <button type="button" class="btn-close novalidate" data-bs-dismiss="modal" aria-label="<?php echo Text::_('COM_VISFORMS_CLOSE'); ?>"></button>
                </div>
                <div class="modal-body">
                    <p class="p-3">
                            <label for="dlidinput" class="form-label"><?php echo Text::_('COM_VISFORMS_FIELD_DOWNLOAD_ID_LABEL');?></label>
                            <input class="form-control" id="dlidinput" name="downloadid" type="text" value="<?php echo $this->dlId; ?>" /><small class="text-muted"><?php echo Text::_('COM_VISFORMS_FIELD_DOWNLOAD_ID_DESC'); ?></small>

                    </p>
                    <div class="accordion" id="dlid">
                        <div class="card">
                            <div class="card-header">
                                <a data-bs-toggle="collapse" data-bs-parent="#dlid" href="#dlid-info">
                                    <?php echo Text::_('COM_VISFORMS_FIELD_DOWNLOAD_ID_HEADER'); ?>
                                </a>
                            </div>
                            <div id="dlid-info" class="collapse">
                                <div class="card-block p-2">
                                    <p><?php echo Text::sprintf('COM_VISFORMS_DOWNLOAD_ID_DESC', Text::_($extensiontypetag), Text::_('COM_VISFORMS_FIELD_DOWNLOAD_ID_LINK_TEXT'), Text::_($extensiontypetag));?></p>
                                    <p><?php echo $dlidInfoFullHtmlLink ?></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer text-left">
                    <input type="submit" class="btn btn-success" value="Submit" />
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo Text::_('COM_VISFORMS_CLOSE'); ?></button>
                </div>
                    <?php echo HTMLHelper::_('form.token'); ?>
                </form>
            </div>
        </div>
    </div>
</div>
        </div>
    </div>
</div>

