<?php
/**
 * Visform form view for Visforms
 *
 * @author       Aicha Vack
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6 
 */


defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Session\Session;
use Joomla\CMS\Layout\FileLayout;
use Joomla\Database\DatabaseInterface;
use Visolutions\Component\Visforms\Administrator\Helper\AefHelper;

$wa = $this->getDocument()->getWebAssetManager();
$wa->useScript('form.validate');
$wa->useScript('keepalive');
$wa->useScript('jquery');
$wa->useScript('jquery-noconflict');

// Check if TinyMCE editor is enable. If not we have to hide the editor buttons
$db = Factory::getContainer()->get(DatabaseInterface::class);
$query = $db->createQuery()
    ->select($db->qn('element'))
    ->from($db->qn('#__extensions'))
    ->where($db->qn('element') .' = ' . $db->quote('tinymce'))
    ->where($db->qn('folder') .' = ' . $db->quote('editors'))
    ->where($db->qn('enabled') . ' = 1');
try {
	$db->setQuery($query, 0, 1);
	$editor = $db->loadResult();
}
catch (RuntimeException $e) {
    $editor = false;
}
$hasSub = AefHelper::checkAEF();
// boolean result "false" is echoed as empty string
$hasSubForJs = $hasSub ? 1 : 0;
$subFieldsetCounter = 0;

// showon not working on editor fields
// So we have to remove it manually
// do not render the summary page editor without subscription
if (empty($hasSub)) {
    $this->form->removeField('summarydescription','layoutsettings');
}

// if no editor is found stop tinyMCE is disabled
if (!$editor) {
    // hide editor button div
    $wa->addInlineStyle('#editor-xtd-buttons {display: none;}');
}
$js = <<<JS
Joomla.submitbutton = function(task) {
        if (task == 'visform.cancel' || document.formvalidator.isValid(document.getElementById('item-form'))) {
            jQuery('#permissions-sliders select').attr('disabled', 'disabled');
            // remove fields which are already saved using ajax (class = visajax-submit)
            jQuery('.visajax-submit').attr('disabled', 'disabled');
            if (task !='visform.cancel') {
                // check that dom element exists and that data storage contains an instance of the visformsOptionCreator for this dom element
                if (jQuery('#jform_visformsmailattachments_params_f_attachment_list_hidden').length && typeof jQuery.data(jQuery('#jform_visformsmailattachments_params_f_attachment_list_hidden')[0], 'visformsOptionCreator') !== "undefined") {
                    jQuery('#jform_visformsmailattachments_params_f_attachment_list_hidden').storeVisformsOptionCreatorData();
                }
                // check that dom element exists and that data storage contains an instance of the visformsOptionCreator for this dom element
                if (jQuery('#jform_visformseditmailattachments_params_f_editattachment_list_hidden').length && typeof jQuery.data(jQuery('#jform_visformseditmailattachments_params_f_editattachment_list_hidden')[0], 'visformsOptionCreator' ) !== "undefined") {
                    jQuery('#jform_visformseditmailattachments_params_f_editattachment_list_hidden').storeVisformsOptionCreatorData();
                }
            }
            Joomla.submitform(task, document.getElementById('item-form'));
        }
    }
    var showCaptchaLabelOptions = function () {
        var layout = document.getElementById('jform_layoutsettings_formlayout');
        var layoutVal = layout.options[layout.selectedIndex].value;
        var subLayout = document.getElementById('jform_layoutsettings_displaysublayout');
        var subLayoutVal = subLayout.options[subLayout.selectedIndex].value;
        if ((layoutVal == 'bt5')  && subLayoutVal == 'individual'  && $hasSubForJs) {
            document.getElementById('jform_captchaoptions_captchaLabelBootstrapWidth').parentNode.parentNode.classList.remove('hidden');
            document.getElementById('jform_captchaoptions_captchaLabelBootstrapWidthSm').parentNode.parentNode.classList.remove('hidden');
            document.getElementById('jform_captchaoptions_captchaLabelBootstrapWidthMd').parentNode.parentNode.classList.remove('hidden');
            document.getElementById('jform_captchaoptions_captchaLabelBootstrapWidthLg').parentNode.parentNode.classList.remove('hidden');
            document.getElementById('jform_captchaoptions_captchaLabelBootstrapWidthXl').parentNode.parentNode.classList.remove('hidden');
            document.getElementById('jform_captchaoptions_captchaLabelBootstrapWidthXxl').parentNode.parentNode.classList.remove('hidden');
            document.getElementById('jform_captchaoptions_btLabelWidthDesc-lbl').parentNode.parentNode.classList.remove('hidden');
        } else {
            document.getElementById('jform_captchaoptions_captchaLabelBootstrapWidth').parentNode.parentNode.classList.add('hidden');
            document.getElementById('jform_captchaoptions_captchaLabelBootstrapWidthSm').parentNode.parentNode.classList.add('hidden');
            document.getElementById('jform_captchaoptions_captchaLabelBootstrapWidthMd').parentNode.parentNode.classList.add('hidden');
            document.getElementById('jform_captchaoptions_captchaLabelBootstrapWidthLg').parentNode.parentNode.classList.add('hidden');
            document.getElementById('jform_captchaoptions_captchaLabelBootstrapWidthXl').parentNode.parentNode.classList.add('hidden');
            document.getElementById('jform_captchaoptions_captchaLabelBootstrapWidthXxl').parentNode.parentNode.classList.add('hidden');
            document.getElementById('jform_captchaoptions_btLabelWidthDesc-lbl').parentNode.parentNode.classList.add('hidden');
        }
        if (layoutVal == 'uikit3' && subLayoutVal == 'individual') {
            document.getElementById('jform_captchaoptions_captchaLabelUikit3Width').parentNode.parentNode.classList.remove('hidden');
            document.getElementById('jform_captchaoptions_captchaLabelUikit3WidthSm').parentNode.parentNode.classList.remove('hidden');
            document.getElementById('jform_captchaoptions_captchaLabelUikit3WidthMd').parentNode.parentNode.classList.remove('hidden');
            document.getElementById('jform_captchaoptions_captchaLabelUikit3WidthLg').parentNode.parentNode.classList.remove('hidden');
            document.getElementById('jform_captchaoptions_captchaLabelUikit3WidthXl').parentNode.parentNode.classList.remove('hidden');
            document.getElementById('jform_captchaoptions_uikit3LabelWidthDesc-lbl').parentNode.parentNode.classList.remove('hidden');
        } else {
            document.getElementById('jform_captchaoptions_captchaLabelUikit3Width').parentNode.parentNode.classList.add('hidden');
            document.getElementById('jform_captchaoptions_captchaLabelUikit3WidthSm').parentNode.parentNode.classList.add('hidden');
            document.getElementById('jform_captchaoptions_captchaLabelUikit3WidthMd').parentNode.parentNode.classList.add('hidden');
            document.getElementById('jform_captchaoptions_captchaLabelUikit3WidthLg').parentNode.parentNode.classList.add('hidden');
            document.getElementById('jform_captchaoptions_captchaLabelUikit3WidthXl').parentNode.parentNode.classList.add('hidden');
            document.getElementById('jform_captchaoptions_uikit3LabelWidthDesc-lbl').parentNode.parentNode.classList.add('hidden');
        }
    }
JS;
$wa->addInlineScript($js);
?>

<form id="item-form" class="form-validate" action="<?php echo Route::_("$this->baseUrl&view=$this->editViewName&layout=edit&id=$this->id"); ?>" method="post" name="adminForm">
    <div id="j-main-container">
        <div class="m-t-2 m-b-3"><?php
		    echo $this->form->renderField('title');
		    echo $this->form->renderField('name'); ?>
    </div>
    <div class="form-horizontal"><?php
    $formFieldSets = $this->form->getFieldsets();

    // we are done with form title
    unset($formFieldSets['form_title']);

    // access rules placed at the very end
    if ((isset($formFieldSets[$name = 'access-rules']))) {
        unset($formFieldSets[$name]);
    }

    // render edit email tab only with subscription
    if (!$hasSub && isset($formFieldSets['visform-edit-email-details'])) {
        unset($formFieldSets['visform-edit-email-details']);
    }

    // start tab sets
    echo HTMLHelper::_('uitab.startTabSet', 'myTab', array('active' => 'visform-basic-details', 'recall' => true, 'breakpoint' => 768));

    // custom layout for first tab
    if (isset($formFieldSets[$name = 'visform-basic-details'])) {
        $fieldSet = $formFieldSets[$name];
        echo HTMLHelper::_('uitab.addTab', 'myTab', $name, Text::_($fieldSet->label)); ?>
        <div class="row">
            <div class="col-12"><?php
                echo '<h3 class="pb-4">' .  Text::_('COM_VISFORMS_GENERAL_SETTINGS').'</h3>';?>
                <div class="row">
                    <div class="col-lg-12 col-xl-6"><?php
                        echo $this->form->renderField('hassub');
                        echo $this->form->renderField('id');
                        echo $this->form->renderField('published');
                        echo $this->form->renderField('publish_up');
                        echo $this->form->renderField('publish_down');
                        echo $this->form->renderField('access');
                        echo $this->form->renderField('language');
                        echo $this->form->renderField('created');
                        echo $this->form->renderField('created_by');
                        echo $this->form->renderField('singlesubmission');
                        echo $this->form->renderField('redirecttoeditview');
                        echo $this->form->renderField('rtev_link_text');
                        ?>
                    </div>
                    <div class="col-lg-12 col-xl-6"><?php
                            // Description field editor
                            foreach ($this->form->getFieldset($name) as $field) {
                                if ($field->type == 'Editor') {
                                    echo $this->form->getLabel($field->fieldname);
                                    echo $this->form->getInput($field->fieldname);
                                }
                            }
                            ?>
                    </div>
                </div>
        </div>
        </div><?php
        unset($formFieldSets[$name]);
        echo HTMLHelper::_('uitab.endTab');
    }

    // layout for all other tabs except the permissions tab
    foreach ($formFieldSets as $name => $fieldSet) {
        // do not render fieldset which should be displayed in child tabs: fieldset has attribute parent
        if (!empty($fieldSet->parent)) {
            continue;
        }
        if (!empty($fieldSet->hassubtabs)) {
            // there are child fieldsets, render them as child tabs
            echo HTMLHelper::_('uitab.addTab', 'myTab', $name, Text::_($fieldSet->label)); ?>
            <div class="row">
                <div class="col-lg-12"><?php
                    foreach ($this->form->getFieldset($name) as $field) {
                        $dataAttributes = $field->getDataAttributes();
                        if (!empty($dataAttributes) && is_array($dataAttributes) && !empty($dataAttributes['data-render-in-child-tab'])) {
                            // skip field in main tab
                        }
                        else {
                            echo $field->renderField();
                        }
                    }
                    $subTabFieldsets = array();
                    foreach ($formFieldSets as $childName => $childFieldSet) {
                        if (!empty($childFieldSet->parent) && $childFieldSet->parent === $name) {
                            // store child fieldsets in variable
                            $subTabFieldsets[$childName] = $childFieldSet;
                            // unset set child fieldset from $formFieldSets;
                            unset($formFieldSets[$childName]);
                        }
                    }
                    // render child fieldsets in sub tabs
                    if (!empty($subTabFieldsets)) { ?>
                    <div>
                        <?php echo HTMLHelper::_('uitab.startTabSet', 'mySubTab' . $subFieldsetCounter, array( 'recall' => true, 'breakpoint' => 768));
                        foreach ($subTabFieldsets as $childName => $childFieldSet) {

                            echo HTMLHelper::_('uitab.addTab', 'mySubTab'. $subFieldsetCounter, $childName, Text::_($childFieldSet->label));
                            echo '<div class="row">';
                            foreach ($this->form->getFieldset($childName) as $field) {
                                if ($field->type == 'Editor') {
                                    $class = $field->parentclass;
                                    if (empty($class)) {
                                        $class = 'col-12';
                                    }
                                    echo '<div class="'.$class.'">';
                                    echo $this->form->getLabel($field->fieldname,  $field->group);
                                    echo $this->form->getInput($field->fieldname,  $field->group);
                                    echo '</div>';
                                }
                                else {
                                    echo $field->renderField();
                                }
                            }
                            echo '</div>';
                            echo HTMLHelper::_('uitab.endTab');
                        }
                        echo HTMLHelper::_('uitab.endTabSet');
                        $subFieldsetCounter++?>
                        </div><?php
                    }?>
                </div>
            </div>
            <?php echo HTMLHelper::_('uitab.endTab');
            // unset fieldset (main tab)
            unset($formFieldSets[$name]);
            continue;
        }
        echo HTMLHelper::_('uitab.addTab', 'myTab', $name, Text::_($fieldSet->label)); ?>
        <div class="row"><?php
        // custom layout for plugin mailattachments tab display attachment selection on top with full width; display pdf and csv attachment options below in two colums
        if ($name === 'visforms-extension-mailattachments') { ?>
            <div class="col-lg-12" style="padding-right: 20px;"> <?php
                foreach ($this->form->getFieldset($name) as $field) {
                    if (!($field->group == 'visformsmailattachments_params.exportsettings')) {
                        if (($field->fieldname == 'f_attachment_list_hidden') || ($field->fieldname == 'visformsmailattachemtsspacer')) {
                            echo $field->renderField();
                        }
                    }
                } ?>
            </div>
            <div class="col-lg-12 col-xl-6"><?php
            foreach ($this->form->getFieldset($name) as $field) {
                if (!($field->group == 'visformsmailattachments_params.exportsettings')) {
                    if ((!($field->fieldname == 'f_attachment_list_hidden')) && (!($field->fieldname == 'visformsmailattachemtsspacer'))) {
                        echo $field->renderField();
                    }
                }
            } ?>
            </div>
            <div class="col-lg-12 col-xl-6"><?php
            foreach ($this->form->getFieldset($name) as $field) {
                if ($field->group == 'visformsmailattachments_params.exportsettings') {
                    echo $field->renderField();
                }
            } ?>
            </div><?php
        }
        else if ($name === 'visforms-extension-editmailattachments') { ?>
            <div class="col-lg-12" style="padding-right: 20px;"> <?php
                foreach ($this->form->getFieldset($name) as $field) {
                    if (!($field->group == 'visformseditmailattachments_params.exportsettings')) {
                        if (($field->fieldname == 'f_editattachment_list_hidden') || ($field->fieldname == 'visformseditmailattachemtsspacer')) {
                            echo $field->renderField();
                        }
                    }
                } ?>
            </div>
            <div class="col-lg-12 col-xl-6"><?php
                foreach ($this->form->getFieldset($name) as $field) {
                    if (!($field->group == 'visformseditmailattachments_params.exportsettings')) {
                        if ((!($field->fieldname == 'f_editattachment_list_hidden')) && (!($field->fieldname == 'visformseditmailattachemtsspacer'))) {
                            echo $field->renderField();
                        }
                    }
                } ?>
            </div>
            <div class="col-lg-12 col-xl-6"><?php
            foreach ($this->form->getFieldset($name) as $field) {
                if ($field->group == 'visformseditmailattachments_params.exportsettings') {
                    echo $field->renderField();
                }
            } ?>
            </div><?php
        }
        else {
            // all the other tabs ?>
            <div class="col-lg-12">
                <div class="row"><?php
                foreach ($this->form->getFieldset($name) as $field) {
                    if ($field->type == 'Editor') {
                        $class = $field->parentclass;
                        if (empty($class)) {
                            $class = 'col-12';
                        }
                        echo '<div class="'.$class.'">';
                        echo $this->form->getLabel($field->fieldname,  $field->group);
                        echo $this->form->getInput($field->fieldname,  $field->group);
                        echo '</div>';
                    }
                    else {
                        echo $field->renderField();
                    }
                } ?>
                </div>
            </div><?php
        } ?>
        </div><?php
        echo HTMLHelper::_('uitab.endTab');
    } ?>
   <?php
    // layout for permissions tab
    if ($this->canDo->get('core.admin')) {
        echo HTMLHelper::_('uitab.addTab', 'myTab', 'permissions', Text::_('COM_VISFORMS_FIELDSET_FORM_RULES', true));
        echo $this->form->getInput('rules');
        echo HTMLHelper::_('uitab.endTab');
    }
    echo HTMLHelper::_('uitab.endTabSet'); ?>
	</div><?php
    $layout = new FileLayout('div.form_hidden_inputs');
    echo $layout->render(); ?>
    </div>
</form>
<?php
$token = Session::getFormToken();
$url = 'index.php?option=com_visforms&task=' . $this->editViewName . '.saveAjaxTextarea&id='. $this->id;
$options =  "{".
    "texts : ".
    "{emptyMessage: '" . Text::_('COM_VISFORMS_EMPTY_TEXTAREA_MESSAGE', true). "',".
    "errorMessage : '" . Text::_('COM_VISFORMS_AJAX_SUBMIT_ERROR_MESSAGE', true) . "',".
    "submitButtonLabel : '" . Text::_('JAPPLY', true) . "',".
    "cancelButtonLabel : '" . Text::_('JCANCEL', true) . "',".
    "},".
    " params: ".
    "{t : '" . $token . "',".
    "url : '" . $url . "',".
    "controlsTemplate: '". (new FileLayout('div.ajax_submit'))->render() ."',".
    "},".
    "}";
$js = <<<JS
document.addEventListener("DOMContentLoaded", showCaptchaLabelOptions);
jQuery(document).ready(function() {
    // create visformsAjaxSubmit Object for textareas with class visajax-submit and attach it to textarea dom element
    jQuery(".visajax-submit").createVisformsAjaxSubmit($options);
})
JS;

$wa->addInlineScript($js);
