<?php
/**
 * viscpanel default view for Visforms
 *
 * @author       Aicha Vack
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6 
 */

//no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\Session\Session;
use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Layout\FileLayout;
use Joomla\Filesystem\Folder;
use Visolutions\Component\Visforms\Administrator\Helper\AefHelper;

// bootstrap and jquery JS
$wa = $this->getDocument()->getWebAssetManager();
$wa->useScript('jquery');
$wa->useScript('jquery-noconflict');
HTMLHelper::_('bootstrap.framework');

$token                  = Session::getFormToken();
$isSub                  = AefHelper::checkAEF();
$component              = ComponentHelper::getComponent('com_visforms');
$demoFormInstalled      = $component->params->get('demoFormInstalled', '');
$extensionTypeTag       = ($isSub) ? 'COM_VISFORMS_SUBSCRIPTION' : 'COM_VISFORMS_PAYED_EXTENSION';
$logFilesPath           = Factory::getApplication()->get('log_path',  JPATH_ADMINISTRATOR . '/logs');
$files                  = (file_exists($logFilesPath)) ? Folder::files($logFilesPath, '.', false, false, [], []) : array();
// translations
$msgMissingFilesNo      = Text::_('COM_VISFORMS_INSPECTOR_MSG_MISSING_FILES_NO');
$msgMissingFilesYes     = Text::_('COM_VISFORMS_INSPECTOR_MSG_MISSING_FILES_YES');
$msgMissingFilesNoVF    = Text::_('COM_VISFORMS_INSPECTOR_MSG_MISSING_FILES_VF_NO');
$msgMissingFilesNoVFS   = Text::_('COM_VISFORMS_INSPECTOR_MSG_MISSING_FILES_VFS_NO');
$msgMissingFilesYesVF   = Text::_('COM_VISFORMS_INSPECTOR_MSG_MISSING_FILES_VF_YES');
$msgMissingFilesYesVFS  = Text::_('COM_VISFORMS_INSPECTOR_MSG_MISSING_FILES_VFS_YES');

// remove non visforms log files
$files = array_filter($files, function($file) {
    return str_starts_with($file, 'visforms');
});
// sort log files desc by name
rsort($files);

$js = <<<JS
jQuery(document).ready(function() {
    // initialize
    //jQuery('.button-check-installation').addClass('icon_ajax-call-wait');
});
var visInspector = {
    checkInstallation: function () {
        // console.log('checkInstallation called');
        // activate tab
        jQuery('button[aria-controls=page-installation]').trigger('click');
        // clean-up previous results and hide div
        jQuery('div.missing-files').addClass('missing-files-hidden');
        jQuery('.missing-files-msg-vf').addClass('missing-files-hidden');
        jQuery('.missing-files-msg-vfs').addClass('missing-files-hidden');
        jQuery('.missing-files-msg').empty();
        jQuery('.missing-files-list-vf').empty();
        jQuery('.missing-files-list-vfs').empty();
        // show the waiting icon during the request
        // let donat = '.icon_ajax-call-wait_check-installation';
        let donat = '.button-check-installation span';
        visHelperAsync.startWaitDonut(donat);
        // data to send
        let fid = 123;
        let count = 900;
        var data = 'data=' + JSON.stringify({ fid: fid, count: count, "{$token}" : 1});
        // send form data
        jQuery.ajax({
            type: 'POST',
            url: 'index.php?option=com_visforms&task=visinspector.checkInstallation',
            data: data,
            success: function(data, textStatus, jqXHR) {
                // hide the waiting icon
                visHelperAsync.stopWaitDonut(donat);
                window.setTimeout(function () {
                    // error
                    if(!data.success) {
                        visHelper.showError(data.message, '');
                        return;
                    }
                    // summary
                    if(data.vf || data.vfs) {
                        count = data.vflist.length + data.vfslist.length;
                        text = "{$msgMissingFilesYes}";
                        text = text.replace('%s', count);
                    }
                    else {
                        text = "{$msgMissingFilesNo}";
                    }
                    jQuery('.missing-files-msg').text(text);
                    jQuery('div.missing-files').removeClass('missing-files-hidden');
                    // VF
                    if(data.vf) { 
                        data.vflist.forEach( function (file) { jQuery('.missing-files-list-vf').append('<li>' + file + '</li>'); } );
                        text = "{$msgMissingFilesYesVF}";
                    }
                    else {
                        jQuery('.missing-files-list-vf').remove();
                        text = "{$msgMissingFilesNoVF}";
                    }
                    jQuery('.missing-files-msg-vf').text(text.replace('%s', data.vflist.length));
                    jQuery('.missing-files-msg-vf').removeClass('missing-files-hidden');
                    // VFS if installed
                    if(data.installedVFS) {
                        if(data.vfs) {
                            data.vfslist.forEach( function (file) { jQuery('.missing-files-list-vfs').append('<li>' + file + '</li>'); } );
                            text = "{$msgMissingFilesYesVFS}";
                        }
                        else {
                            jQuery('.missing-files-list-vfs').remove();
                            text = "{$msgMissingFilesNoVFS}";
                        }
                        jQuery('.missing-files-msg-vfs').text(text.replace('%s', data.vfslist.length));
                        jQuery('.missing-files-msg-vfs').removeClass('missing-files-hidden');
                    }
                }, 1);
            },
            error: function(jqXHR, textStatus, errorThrown) {
                // hide the waiting icon
                visHelperAsync.stopWaitDonut(donat);
                // give error feedback
                visHelper.showError(jqXHR.responseText, errorThrown);
            },
            dataType: 'json',
            async: true
        });
    }
};
var visHelper = {
    showError: function (responseText, errorThrown) {
        var dlg = jQuery('#ajax-modal-error-dialog');
        if(responseText.startsWith('<!DOC')) {
            jQuery(dlg).find('.modal-body').html(errorThrown);
            jQuery(dlg).find('.modal-sub-title').html('');
        }
        else {
            jQuery(dlg).find('.modal-body').html(responseText);
            jQuery(dlg).find('.modal-sub-title').html(errorThrown);
        }
        jQuery('#ajax-modal-error-dialog button').on('click', function() { jQuery('#ajax-modal-error-dialog').modal('hide'); });
        jQuery(dlg).modal('show');
    }
}
JS;
$wa->addInlineScript($js);

$css = <<<CSS
td .form-control {
    width: 100%;
}
.missing-files-hidden {
    display: none;
}
.icon_ajax-call-wait {
    background-position: unset;
}
.subhead joomla-toolbar-button .btn > span {
    width: 1rem;
    height: 1rem;
}
.vf-inspector-table-php {
    
}
.vf-inspector-table-php td {
    padding: 5px;
}
.vf-inspector-table-sql {
    
}
.vf-inspector-table-sql td {
    padding: 5px;
}
.vf-inspector-hr {
    margin-bottom: 20px;
}
.vf-inspector-logging {
    width: 100%;
    white-space: pre-line;
}
CSS;
$wa->addInlineStyle($css);
?>
<div class="row"><?php
if (!empty( $this->sidebar)) { ?>
<div id="j-sidebar-container" class="col-md-3 col-xl-2">
<?php echo $this->sidebar; ?>
</div><?php } ?>
<div class="<?php if (!empty($this->sidebar)) {echo 'col-md-9 col-xl-10'; } else { echo 'col-12'; } ?>">
<div id="j-main-container" class="j-main-container">
<div id="vfdebugger">
<!--  unused  -->
<div class="row">
    <div class="col-lg-6 mt-3"></div>
</div>
<!--  tabs  -->
<div class="row">
    <div class="col-lg-10 mt-3">
	    <?php echo HTMLHelper::_('uitab.startTabSet', 'configTabs', ['active' => 'page-site', 'recall' => true, 'breakpoint' => 768]); ?>
        <!-- tab installation -->
        <?php echo HTMLHelper::_('uitab.addTab', 'configTabs', 'page-installation', Text::_('COM_VISFORMS_INSPECTOR_TAB_INSTALLATION')); ?>
        <h3 class="vf-inspector-hr"><?php echo Text::_('COM_VISFORMS_INSPECTOR_INSTALLATION_TABLE_HEADER'); ?></h3>
        <div class="row missing-files missing-files-hidden">
                <h4 class="missing-files-msg"></h4>
                <h4 class="missing-files-msg-vf missing-files-hidden"></h4>
                <ul class="missing-files-list-vf"></ul>
                <h4 class="missing-files-msg-vfs missing-files-hidden"></h4>
                <ul class="missing-files-list-vfs"></ul>
            </div>
        <?php echo HTMLHelper::_('uitab.endTab'); ?>
        <!-- tab PHP -->
        <?php echo HTMLHelper::_('uitab.addTab', 'configTabs', 'page-php', Text::_('COM_VISFORMS_INSPECTOR_TAB_PHP') . " $this->phpVersion"); ?>
        <h3 class="vf-inspector-hr"><?php echo Text::_('COM_VISFORMS_INSPECTOR_PHP_TABLE_HEADER'); ?></h3>
        <table class="vf-inspector-table-php">
            <thead>
            <tr>
                <th><?php echo Text::_('COM_VISFORMS_INSPECTOR_PHP_TABLE_ROW_NAME'); ?></th>
                <th><?php echo Text::_('COM_VISFORMS_INSPECTOR_PHP_TABLE_ROW_VALUE'); ?></th>
            </tr>
            </thead>
        <?php foreach ($this->phpIni as $name => $value) : ?>
            <tr>
                <td class=""><?php echo $name; ?></td>
                <td class=""><?php echo $value; ?></td>
            </tr>
        <?php endforeach; ?>
        </table>
        <?php echo HTMLHelper::_('uitab.endTab'); ?>
        <!-- tab MySQL -->
        <?php echo HTMLHelper::_('uitab.addTab', 'configTabs', 'page-mysql', Text::_('COM_VISFORMS_INSPECTOR_TAB_SQL') . " $this->mysqlVersion"); ?>
        <h3 class="vf-inspector-hr"><?php echo Text::_('COM_VISFORMS_INSPECTOR_SQL_TABLE_HEADER'); ?></h3>
        <table class="vf-inspector-table-sql">
            <thead>
            <tr>
                <th><?php echo Text::_('COM_VISFORMS_INSPECTOR_SQL_TABLE_ROW_NAME'); ?></th>
                <th><?php echo Text::_('COM_VISFORMS_INSPECTOR_SQL_TABLE_ROW_VALUE'); ?></th>
            </tr>
            </thead>
        <?php foreach ($this->mysqlIni as $name => $value) : ?>
            <tr>
                <td class=""><?php echo $name; ?></td>
                <td class=""><?php echo $value; ?></td>
            </tr>
        <?php endforeach; ?>
        </table>
        <?php echo HTMLHelper::_('uitab.endTab'); ?>
        <!-- tab visforms log -->
        <?php echo HTMLHelper::_('uitab.addTab', 'configTabs', 'page-logging', Text::_('COM_VISFORMS_INSPECTOR_TAB_LOGGING')); ?>
        <?php if(!empty($files)) {
            echo HTMLHelper::_('uitab.startTabSet', 'sub-page-logging', array( 'recall' => true, 'breakpoint' => 768));
            foreach ($files as $key => $file) {
                $logFilePath = $logFilesPath . '/' . $file;
                $tabName = ucfirst(str_replace('visforms_', '', str_replace('.php', '', $file)));
                echo HTMLHelper::_('uitab.addTab', 'sub-page-logging', $file, $tabName);
                ?>
                <h3 class="vf-inspector-hr"><?php echo Text::sprintf('COM_VISFORMS_INSPECTOR_INDIVIDUAL_LOGGING_TABLE_HEADER', $tabName); ?></h3>
                <p class="vf-inspector-logging"><?php echo Text::sprintf('COM_VISFORMS_INSPECTOR_LOGGING_TABLE_LOGFILE', $logFilePath ); ?></p>
                <p class="vf-inspector-logging"><?php echo file_exists($logFilePath) ? file_get_contents($logFilePath) : Text::_('COM_VISFORMS_INSPECTOR_LOGGING_TABLE_NO_LOGFILE'); ?></p>
            <?php
                echo HTMLHelper::_('uitab.endTab');}
            echo HTMLHelper::_('uitab.endTabSet');
        }
        else { ?>
            <p class="vf-inspector-logging"><?php echo Text::_('COM_VISFORMS_INSPECTOR_NO_LOG_FILES'); ?></p>
        <?php }?>
        <?php echo HTMLHelper::_('uitab.endTab'); ?>
	    <?php echo HTMLHelper::_('uitab.endTabSet'); ?>
    </div>
</div>
<!--  footer: visforms version and credits  -->
<?php echo HTMLHelper::_('visforms.creditsBackend');
echo (new FileLayout('div.ajax_modal_error_dialog'))->render(); ?>
</div>
</div>
</div>

