(function($) {
    $.extend($.fn, {
        // public plugin functions
        displayChanger : function (options) {
            // Attach onchange event handler to displayChanger Element
            $(".displayChanger").on('change', function (e) {
                $(".conditional").trigger("checkConditionalState");
            });
        },
        // perform the code which is necessary to toggle the display state of one form element
        toggleDisplay : function (options) {
            const defaults = {
                // just an example of adding translated texts, stepAlert is not used
                texts: {
                    stepAlert: "Es wurde ein bedingtes Feld in einem anderen Schritt aktiviert. Eventuell funktioniert das Formular nicht mehr."
                }
            };
            const settings = jQuery.extend(true, {}, defaults, options);
            const data = options.restricts;
            const userinputs = $.data($(this).closest("form").get(0), 'userinputs');
            if ((!userinputs) || typeof userinputs === "undefined") {
                return;
            }
            // el is a div class="conditional"
            const el = $(this);
            // data is a list of all conditional fields
            // index is id of field
            // value is a comma separated string of all field IDs and values the command the conditional field to be visible
            $.each(data, function (index, value) {
                // a conditional field may have different other fields that make it visible
                // we will not hide it, when at least one condition is true
                let hide = true;
                // find the right set of conditions for the div conditional that is actually processed
                let elId;
                if (el.hasClass(index)) {
                    if (elId = el.attr('class').match(index)) {
                        // split the condition string
                        const showWhens = value.split(', ');
                        $.each(showWhens, function (i, v) {
                            // split the condition into a field id and a value that, if selected , will command the field to be visible
                            const showWhen = v.split('__');
                            if (showWhen.length >= 2) {
                                const fieldId = showWhen[0];
                                const conditionalValue = showWhen[1];
                                // Restrictor elements that determine whether field is shown or hidden
                                // we first look if we have a single control with a matching ID
                                let restrictors = $('#' + fieldId);
                                // if not, we deal with a radio or a multi checkbox. Id's are there followed by _n
                                if (restrictors.length < 1) {
                                    restrictors = $("[id^='" + fieldId + "_']");
                                }
                                // rel is restrictor element
                                // check if we have a value in a restrictor element that will command field to be shown
                                $.each(restrictors, function (ri, rel) {
                                    // only use values of elements that are enabled
                                    if ($(rel).is(':enabled')) {
                                        const tagname = rel.tagName.toLowerCase();
                                        switch (tagname) {
                                            case "input" :
                                                // selected values have checked=checked set
                                                if ($(rel).is(':checked')) {
                                                    if ($(rel).val() == conditionalValue) {
                                                        hide = false;
                                                        return hide;
                                                    }
                                                }
                                                break;
                                            case "select" :
                                                const vals = $(rel).find(':selected');
                                                $.each(vals, function (valindex, selectedValue) {
                                                    if ($(selectedValue).val() == conditionalValue) {
                                                        hide = false;
                                                    }
                                                    return hide;
                                                });
                                                break;
                                            default :
                                                break;
                                        }
                                    }
                                    return hide;
                                });

                                return hide;
                            }
                        })
                    }

                    // controls of element to be shown or hidden
                    // we first look for a control with matching id
                    // _code is field for email verification code
                    let controls = $("#" + index + ", #" + index + "_code");
                    // if not, we deal with a radio or a multi checkbox. Id's are there followed by _n. Or a location Id' are followed by _lat and _lng
                    if (controls.length < 1) {
                        // data-disabled: Unique values validation: Use to mark options, which are already used up
                        controls = el.find("[id^='" + index + "_']:not([data-disabled])");
                    }
                    let ctagname = '';
                    if (controls.get(0)) {
                        ctagname = controls.get(0).tagName.toLowerCase();
                    }
                    if (hide === false) {
                        if ($(controls).is(':disabled') || ((ctagname == 'hr') && $(controls).hasClass('ignore'))) {
                            // enable controls, remove class ignore and disabled, show div conditional
                            showControls(controls, settings);
                            // check if control is displayChanger
                            if (controls.hasClass('displayChanger')) {
                                // check if depending fields must be displayed too
                                toggleChild(data, index);
                            }
                            // use custom event; #index does not exist, if field is radio or multicheckbox, which is ok, because the cannot be used in calculations
                            $('#' + index).trigger('recalculate');
                            return false;
                        }
                    } else {
                        // data-disabled: Unique values validation: Use to mark options, which are already used up
                        if (($(controls).is(':enabled') || (($(controls).is(':disabled')) && ($(controls).attr('data-disabled') != undefined))) || ((ctagname == 'hr') && $(controls).hasClass('ignore') == false)) {
                            // disable controls, set class ignore, hide div conditional
                            hideControls(controls);
                            // check if control is displayChanger
                            if (controls.hasClass('displayChanger')) {
                                // check if depending fields must be hidden too
                                toggleChild(data, index);
                            }
                            // use custom event; #index does not exist, if field is radio or multicheckbox, which is ok, because the cannot be used in calculations
                            $('#' + index).trigger('recalculate');
                            return false;
                        }
                    }
                }
            });
            
            // additional protected class variables can be declared here.
            
            // protected helper functions for toggleDisplay
            
            /**
             * Methode to enable controls, remove class ignore and disabled, show div conditional
             * @param {jQuery selection} controls
             * @returns {Boolean}
             */
            function showControls (controls, settings) {
                if (controls.length < 1) {
                    // no controls found, do nothing
                    return false;
                }
                $.each(controls, function (cindex, control) {
                    let elid;
                    // only enable multicheckbox option that have no data-disabled attribute
                    // data-disabled: Unique values validation: Use to mark options, which are already used up
                    // for some like disabled adding or removing the content attribute disabled="disabled" always toggles the js property
                    // so using removeAttr('disabled'); is completely okay!
                    if ($(control).attr('data-disabled') == undefined) {
                        $(control).removeAttr('disabled');
                        $(control).removeClass('ignore');
                        elid = $(control).get(0).id;
                    }
                    // no radio or checkbox group
                    if (cindex === 0) {
                        $.each(userinputs, function (i, obj) {
                            // set to user input values
                            switch (obj.type) {
                                case "select":
                                case "selectsql":
                                    if (obj.label === elid) {
                                        if ($.isPlainObject(obj.value)) {
                                            const seloptions = $(control).find('option');
                                            $.each(seloptions, function (i, el) {
                                                $.each(obj.value, function (i, val) {
                                                    if ($(el).attr('value') === val) {
                                                        $(el).prop('selected', true);
                                                        // you have to return false to break from an each loop
                                                        return false;
                                                    }
                                                    $(el).prop('selected', false);
                                                    return;
                                                });
                                            });
                                        }
                                    }
                                    break;
                                case "multicheckbox":
                                case "multicheckboxsql":
                                    // control is a single input. It's id (elid) has a additional counter _1....)
                                    // we cannot use the control to set a checked property of each inputs but have to go one level up and then find each input element and set the property
                                    if ($(control).parents("div.conditional").hasClass(obj.label)) {
                                        if ($.isPlainObject(obj.value)) {
                                            const boxes = $(control).parents("div.conditional").find('input');
                                            $.each(boxes, function (i, el) {
                                                $.each(obj.value, function (ix, val) {
                                                    if ($(el).attr('value') === val) {
                                                        $(el).prop('checked', true);
                                                        // you have to return false to break from an each loop
                                                        return false;
                                                    }
                                                    $(el).prop('checked', false);
                                                    return;
                                                });
                                            });
                                        }
                                    }
                                    break;
                                case "radio":
                                case "radiosql":
                                    // control is a single input. It's id (elid) has a additional counter _1....)
                                    // we cannot use the control to set a checked property of each inputs but have to go one level up and then find each input element and set the property
                                    if ($(control).parents("div.conditional").hasClass(obj.label)) {
                                        const radios = $(control).parents("div.conditional").find('input');
                                        $.each(radios, function (i, el) {
                                            if ($(el).attr('value') === obj.value) {
                                                $(el).prop('checked', true);
                                            }
                                            else {
                                                $(el).prop('checked', false);
                                            }
                                        });
                                    }
                                    break;
                                case "checkbox":
                                    if (obj.label === elid) {
                                        $("#" + obj.label).prop("checked", obj.value);
                                        return;
                                    }
                                    break;
                                case "signature" :
                                    // value in text-input was already reset to defaultValue in hideControls
                                    // the canvas content is only replaced when the field is displayed again (showControls)
                                    if (obj.label === elid){
                                        let canvasContainer = document.getElementById(obj.label + "_sig");
                                        const {api} = canvasContainer.dataset;
                                        // jSignature
                                        if (!api) {
                                            $("#" + obj.label).val(obj.value);
                                            if (obj.value === "") {
                                                $("#" + obj.label + "_sig").jSignature("reset");
                                            }
                                            else {
                                                $("#" + obj.label + "_sig").jSignature("setData", "data:" + obj.value);
                                            }
                                        }
                                        // signaturePad
                                        else if (api === "1") {
                                            // create custom event and trigger it on the canvas element
                                            let canvas = document.querySelector("#" + obj.label + "_sig canvas")
                                            const event =  new CustomEvent('replaceCanvasImage', {bubbles: true, detail : obj.value});
                                            canvas.dispatchEvent(event);
                                        }
                                    }
                                    break;
                                default:
                                    if (obj.label === elid) {
                                        // used to prevent email cloaking in form used in content (plg or module)
                                        $("#" + obj.label).val(obj.value.replace(/&#64/g, '@'));
                                        return ;
                                    }
                                    break;
                            }
                        });
                        if ($(control).is('[readonly]') == false) {
                            $(control).parents("div.conditional").find("button").removeClass('vishidden');
                        }
                        $(control).parents("div.conditional").removeClass('vishidden');
                        // fix bug in google maps: Map in hidden field not displayed properly.
                        $(control).parents("div.conditional").trigger('reloadVfMap');
                    }
                });
            }
            
            /**
             * Methode to disable controls, set class ignore, hide div conditional
             * @param {jquery selection} controls
             * @returns {Boolean}
             */
            function hideControls (controls) {
                if (controls.length < 1) {
                    // no controls found, do nothing
                    return false;
                }
                $.each(controls, function (cindex, control) {
                    $(control).attr('disabled', 'disabled');
                    $(control).addClass('ignore');
                    const isCal = $(control).hasClass('isCal');
                    const isLocation = $(control).hasClass('locationinput');
                    const isSearchSelect = $(control).hasClass('select2-hidden-accessible');
                    // do not empty location field value and cal field value
                    if (!(isCal === true) && !(isLocation === true)) {
                        $(control).val(function () {
                            return this.defaultValue;
                        });
                    }
                    $(control).prop('checked', function() {
                        return this.defaultChecked;
                    });
                    const elid = $(control).get(0).id;
                    $('#' + elid + ' option').prop('selected', function() {
                        return this.defaultSelected;
                    });
                    if (isSearchSelect) {
                        const seloptions = $(control).find('option');
                        $.each(seloptions, function (i, el) {
                            if ($(el).prop('selected') === true) {
                                $('#select2-' + elid + '-container').html($(el).html());
                                return false;
                            }
                        });
                    }
                    // no radio or checkbox group
                    if (cindex === 0) {
                        // if it is a file upload field we reset the delete file checkbox to unchecked
                        $(control).parents("div.conditional").addClass('vishidden');
                        $(control).parents("div.conditional").find(".deleteFile").prop("checked", false);
                    }
                });
            }
            
            /**
             * Basically we use the data object to find all conditional fields, who's display state depends on the state of the control with the id, given as param.
             * We then find the parent html element with class=conditional for each conditional field and trigger the checkConditionalState event on it
             * The toggleDisplay function is then performed once again for the conditional field
             * @param {string} restricts list of all conditionla fields and the field__values that trigger there display
             * @param {string} id id/class name of parent control
             * @returns {undefined}
             */
            function toggleChild (restricts, id) {
                $.each(restricts, function (index, list) {
                    // split the restriction string
                    const showWhens = list.split(', ');
                    $.each(showWhens, function (i, v) {
                        // split the restriction into a field id and a value that, if selected , will command the field to be visible
                        const showWhen = v.split('__');
                        if (showWhen.length >= 2) {
                            // we have a depending child
                            if (showWhen[0] == id) {
                                // find parent element with class=conditional
                                const conditional = $('.' + index);
                                // check the child
                                conditional.trigger('checkConditionalState');
                            }
                        }
                    });
                });
            }
        }
    });
}(jQuery));

// mend missing placeholder support in some browsers
(function ($) {
    $.support.placeholder = ('placeholder' in document.createElement('input'));
})(jQuery);

const visForm = {
    version : '5.4.0',
    // used for both
    // reload option list (listbox)
    // reload field value (input)
    reloadOptionList : function (event) {
        event.preventDefault();
        const formElement = jQuery(this).closest('form');
        const fid = jQuery(formElement).attr('id');
        const data = event.data;
        const formData = jQuery(formElement).serializeArray();
        const reloadId = data.reloadId;
        const baseurl = data.baseurl;
        const cid = data.cid;
        const phpTask = data.task;
        formData.push({name: 'reloadId', value: data.reloadId});
        jQuery.ajax({
            type: 'POST',
            url: baseurl + '/index.php?option=com_visforms&task=visforms.'+phpTask+'&id=' + fid + '&cid=' + cid,
            data: formData,
            success: function(data, textStatus, jqXHR) {
                let elId = '#' + fid + ' #field' + reloadId;
                if (phpTask === 'reloadOptionList') {
                    jQuery(elId).empty().append(data);
                    // set any possible default values given by user inputs (edit value or url parameter) in reloaded options
                    visForm.setDefaultValues(fid, reloadId);
                    // perform preSelection of a solitary option if set in field configuration
                    visForm.preSelectSolitaryOption(reloadId);
                    jQuery(elId).trigger('change');
                    visForm.hideSqlOptionList(fid);
                    visForm.hideSqlDataList(fid);
                }
                else if (phpTask === 'reloadValue') {
                    // Set value in reloaded field
                    jQuery(elId).val(data.replace(/&#64/g, '@'));
                    // Fieldtype date needs special treatment
                    // all Calender fields are accessible through JoomlaCalendar.getCalObject(element)._joomlaCalendar;
                    // where element is the HTML Input field
                    // the _joomlaCalendar is attached to the parent ('.field-calender') element and can be called directly
                    // if there is no _joomlaCalendar for a field, this getCalObject() returns false
                    // change the data-alt-value
                    // call checkInputs() on the _joomlaCalendar to properly set the value in a date field
                    if (jQuery(elId)[0].hasAttribute('data-alt-value')) {
                        jQuery(elId).attr('data-alt-value', data.replace(/&#64/g, '@'));
                        let calObj = JoomlaCalendar.getCalObject(jQuery(elId)[0]);
                        if (calObj) {
                            let calendar = calObj._joomlaCalendar;
                            calendar.checkInputs();
                        }
                    }
                    jQuery(elId).trigger("recalculate");
                    jQuery(elId).trigger('change');
                }
            },
            error: function(jqXHR, textStatus, errorThrown) {
                // give error feedback
                visForm.showAjaxError(jqXHR.responseText, errorThrown);
            },
            dataType: 'html',
            async: true
        });
    },
    setDefaultValues : function (formId, fieldId) {
        const userinputs = jQuery.data(jQuery("#" + formId).get(0), 'userinputs');
        if ((!userinputs) || typeof userinputs === "undefined") {
            return;
        }
        jQuery.each(userinputs, function (i, obj) {
            if (obj.label !== "field" + fieldId) {
                return;
            }
            if (obj.value === "undefined") {
                return;
            }
            if (obj.isDisabled === true && obj.isForbidden !== true) {
                // these fields stay with there configuration default
                return;
            }
            if (jQuery.isPlainObject(obj.value)) {
                const seloptions = jQuery("#" + obj.label).find('option');
                jQuery.each(seloptions, function (i, el) {
                    jQuery.each(obj.value, function (i, val) {
                        if (jQuery(el).attr('value') === val) {
                            jQuery(el).prop('selected', true);
                            // you have to return false to break from an each loop
                            return false;
                        }
                        jQuery(el).prop('selected', false);
                        return;
                    });
                });
            }
            return false;
        });
    },
    preSelectSolitaryOption : function (fieldId) {
        const field = jQuery('#field' + fieldId);
        if (field.hasClass('preSelectedSolitaryOption')) {
            let options = field.find('option');
            let optionsCount = options.length;
            if (optionsCount === 1 && jQuery(options[0]).prop('disabled') === false) {
                jQuery(options[0]).prop('selected', true);
            }
            else if (optionsCount === 2) {
                if (options[0].value === '' && jQuery(options[1]).prop('disabled') === false) {
                    jQuery(options[0]).prop('selected', false);
                    jQuery(options[1]).prop('selected', true);
                }
            }
        }
    },
    hideSqlOptionList : function (formId) {
        let hideEmpty = 1, hidePrselect = 2, hideBoth = 3, state = 0;
        jQuery('#' + formId + ' select.hideOnEmptyOptionList, #' + formId + ' select.hideOnPreSelectedSolitaryOption').each(function() {
            // Do not hide field with php Errors
            if (jQuery(this).hasClass('error')) {
                return true;
            }
            let fieldId = jQuery(this).attr('id');
            let controlGroup = jQuery(this).parents('.' + fieldId);
            let optionsCount = jQuery(this).find('option').length;
            if (jQuery(this).hasClass('hideOnEmptyOptionList') && jQuery(this).hasClass('hideOnPreSelectedSolitaryOption')) {
                state = hideBoth;
            }
            else if (jQuery(this).hasClass('hideOnEmptyOptionList')) {
                state = hideEmpty;
            }
            else if (jQuery(this).hasClass('hideOnPreSelectedSolitaryOption')) {
                state = hidePrselect;
            }
            if (optionsCount === 0) {
                // hide if not option is given and hideEmpty is set
                if (state === hideEmpty) {
                    jQuery(controlGroup).addClass('vishidden');
                }
                else {
                    jQuery(controlGroup).removeClass('vishidden');
                }
            }
            else if (optionsCount === 1) {
                // if only one option is given and it's value is '' this is the 'select a value' default option
                if (this.options[0].value === '') {
                    if (state === hideEmpty || state === hideBoth) {
                        jQuery(controlGroup).addClass('vishidden');
                    }
                    else {
                        jQuery(controlGroup).removeClass('vishidden');
                    }
                }
                // if only one option is given and it's value is not '' it is a real option (happens, if for example if size attribute is set)
                else {
                    if (this.selectedIndex === 0 && (state === hideBoth || state === hidePrselect)) {
                        jQuery(controlGroup).addClass('vishidden');
                    }
                    else {
                        jQuery(controlGroup).removeClass('vishidden');
                    }
                }
            }
            // select an option plus one real option
            else if (optionsCount === 2) {
                if (this.selectedIndex === 1 && (state === hideBoth || state === hidePrselect)) {
                    jQuery(controlGroup).addClass('vishidden');
                }
                else {
                    jQuery(controlGroup).removeClass('vishidden');
                }
            }
            else {
                jQuery(controlGroup).removeClass('vishidden');
            }
        });
    },
    hideSqlDataList : function (formId) {
        const hideEmpty = 1;
        let state = 0;
        jQuery('#' + formId + ' table.hideOnEmptyOptionList, #' + formId).each(function() {
            const fieldId = jQuery(this).attr('id');
            const controlGroup = jQuery(this).parents('.' + fieldId);
            const rowCount = jQuery(this).find('tr').length;
            if (jQuery(this).hasClass('hideOnEmptyOptionList')) {
                state = hideEmpty;
            }
            if (rowCount === 0) {
                // hide if not option is given and hideEmpty is set
                if (state === hideEmpty) {
                    jQuery(controlGroup).addClass('vishidden');
                }
                else {
                    jQuery(controlGroup).removeClass('vishidden');
                }
            }
            else {
                jQuery(controlGroup).removeClass('vishidden');
            }
        });
    },
    showAjaxError : function (responseText, errorThrown) {
        if (responseText === undefined || responseText === null) {
            return;
        }
        if (responseText.startsWith('<!DOC')) {
            alert(errorThrown);
        }
        else {
            alert(responseText);
        }
    },
    showProcessFormMsg : function (parentFormId) {
        // show form processing message
        // div _processform does only exist, if showformprocessmessage is enabled!
        let div = jQuery("#"+parentFormId+"_processform");
        if (div.length) {
            jQuery("#vispoweredby").addClass('vishidden');
            jQuery("#"+parentFormId).addClass('vishidden');
            div.removeClass('vishidden');
            this.focusjQueryElementTop(div);
        }
    },
    // expects div to be a jQuery object of an HTML element
    focusjQueryElementTop : function (div) {
        let elOffset = div.offset().top;
        let elHeight = div.height();
        let windowHeight = jQuery(window).height();
        let offset;
        // focus div with form processing message in the middle of the view port
        if (elHeight < windowHeight) {
            offset = elOffset - ((windowHeight / 2) - (elHeight / 2));
        }
        else {
            offset = elOffset;
        }
        let speed = 700;
        jQuery('html, body').animate({scrollTop: offset}, speed);
    },
    onNextButtonClick: function (button) {
        const visform = jQuery(button).closest('form');
        const isValid = jQuery(visform).valid();
        const isPending = jQuery(visform).validate().pendingRequest !== 0;
        if (isPending) {
            if (typeof validPendingTimeout !== "undefined") {
                clearTimeout(validPendingTimeout);
            }
            validPendingTimeout = setTimeout(function () {
                visForm.onNextButtonClick(button);
            }, 200);
        }
        if (jQuery(visform).valid() && !isPending) {
            let fieldset = jQuery(button).closest('[class^="fieldset-"]').next();
            jQuery(button).closest('[class^="fieldset-"]').next().removeClass("vishidden").addClass("active");
            jQuery(button).closest('[class^="fieldset-"]').next().trigger("reloadVfMap");
            jQuery(button).closest('[class^="fieldset-"]').addClass("vishidden").removeClass("active");
            // trigger after active was removed from current fieldset
            jQuery(button).closest('[class^="fieldset-"]').next().trigger('setFocusOnClassChange',["next"]);
            const activeBadge = jQuery(visform).find('.visprogress .badge.badge-important');
            jQuery(activeBadge).removeClass("badge-important").addClass("badge-success");
            jQuery(activeBadge).closest('.stepCont').next().find('.badge').addClass("badge-important");
            // we have to remove class ignore from controls on next page, because the submit button could be on that page
            // and we cannot remove class ignore when click event is on submit button (due to validator)
            jQuery(button).closest('[class^="fieldset-"]').next().find('input, textarea, select').not(":disabled").removeClass("ignore");
        }
    },
    onSummaryButtonClick: function (button) {
        const formid = jQuery(button).closest("form").get(0).id;
        const isValid = jQuery("#" + formid).valid();
        const isPending = jQuery("#" + formid).validate().pendingRequest !== 0;
        if (isPending) {
            if (typeof validPendingTimeout !== "undefined") {
                clearTimeout(validPendingTimeout);
            }
            validPendingTimeout = setTimeout(function () {
                visForm.onSummaryButtonClick(button);
            }, 200);
        }
        if (jQuery("#" + formid).valid() && !isPending) {
            visForm.createSummaryHtml(formid);
            jQuery(button).closest('[class^="fieldset-"]').next().removeClass("vishidden").addClass("active");
            jQuery(button).closest('[class^="fieldset-"]').addClass("vishidden").removeClass("active");
            // trigger after active was removed from current fieldset
            jQuery(button).closest('[class^="fieldset-"]').next().trigger('setFocusOnClassChange',["next"]);
            const activeBadge = jQuery('#' + formid + ' .visprogress .badge.badge-important');
            jQuery(activeBadge).removeClass("badge-important").addClass("badge-success");
            jQuery(activeBadge).closest('.stepCont').next().find('.badge').addClass("badge-important");
            // force validation of captcha input on summary page
            jQuery(button).closest('[class^="fieldset-"]').next().find('input').not(":disabled").removeClass("ignore");
            // force validation of hCaptcha input on summary page
            jQuery(button).closest('[class^="fieldset-"]').next().find('textarea').not(":disabled").removeClass("ignore");
        }
        // recaptcha must be reloaded in order to be checked for required properly
        if (typeof grecaptcha !== "undefined") {
            grecaptcha.reset();
        }
    },
    createSummaryHtml : function(formid) {
        let htmlsummary;
        const visform = jQuery.data(jQuery("#" + formid).get(0), 'visform');
        const fields = visform.fields;
        const summary = [];
        jQuery.each(fields, function (i, o) {
            let tmp;
            let selected;
            let value;
            if (jQuery.inArray(o.type, ['image', 'submit', 'reset', 'fieldsep', 'hidden', 'pagebreak']) > -1) {
                return true;
            }
            const label = visform.oSummaryFirstElementLayout + '' + o.label + ': ' + visform.cSummaryFirstElementLayout;
            switch (o.type) {
                case "select":
                case "selectsql":
                    if (!jQuery("#" + formid + " #field" + o.id).prop("disabled")) {
                        value = [];
                        selected = jQuery("#" + formid + " .field" + o.id + " :selected");
                        if (selected.length > 0) {
                            selected.each(function () {
                                if (jQuery(this).val() != "") {
                                    value.push(jQuery(this).text());
                                }
                            });
                        }
                        tmp = value.join(", ");
                        if ((!visform.hideemptyfieldsinsummary) || (tmp != "")) {
                            summary.push(label + visform.oSummarySecondElementLayout + tmp + visform.cSummarySecondElementLayout);
                        }
                    }
                    return;
                case 'multicheckbox' :
                case 'radio' :
                case 'multicheckboxsql' :
                case 'radiosql' :
                    // Unique Values property sets used inputs to disabled and adds attribute data-disabled=disabled.
                    // Therefore prop disabled cannot be used as only means to detect, whether a multicheckbox or radio is conditianal or simply disabled as because it is used
                    // Search for a disabled input which does not have a data-disabled attribute
                    const senabled = jQuery("#" + formid + " .field" + o.id + " :input:disabled:not([data-disabled])");
                    if (!(senabled.length > 0)) {
                        value = [];
                        selected = (jQuery("#" + formid + " .field" + o.id + " :input:checked"));

                        if (selected.length > 0) {
                            selected.each(function (i) {
                                sid = jQuery(this).attr("id");
                                value.push(jQuery(this).closest(".field" + o.id).find("label[for=\'" + sid + "\']").text());
                            });
                        }
                        tmp = value.join(", ");
                        if ((!visform.hideemptyfieldsinsummary) || (tmp != "")) {
                            summary.push(label + visform.oSummarySecondElementLayout + tmp + visform.cSummarySecondElementLayout);
                        }
                    }
                    return;
                case 'checkbox' :
                    if (!jQuery("#" + formid + " #field" + o.id).prop("disabled")) {
                        value = "";
                        if ((jQuery("#" + formid + " #field" + o.id).prop("checked"))) {
                            value = jQuery("#" + formid + " #field" + o.id).val();

                        }
                        if ((!visform.hideemptyfieldsinsummary) || (value != "")) {
                            summary.push(label + visform.oSummarySecondElementLayout + value + visform.cSummarySecondElementLayout);
                        }
                    }
                    return;
                case 'calculation' :
                    if (!jQuery("#" + formid + " #field" + o.id).prop("disabled")) {
                        value = jQuery("#" + formid + " #field" + o.id).val();
                        if ((!visform.hideemptyfieldsinsummary) || (value != "")) {
                            if ((!visform.summaryemptycaliszero) || (!(0 == value.replace(",", ".")))) {
                                summary.push(label + visform.oSummarySecondElementLayout + value + visform.cSummarySecondElementLayout);
                            }
                        }
                    }
                    return;
                case 'location' :
                    const lat = jQuery("#" + formid + " #field" + o.id + "_lat");
                    const lng = jQuery("#" + formid + " #field" + o.id + "_lng");
                    if (!lat.prop("disabled") && !lng.prop("disabled")) {
                        const value_lat = lat.val();
                        const value_lng = lng.val();
                        if ((!visform.hideemptyfieldsinsummary) || ((value_lat != "") && (value_lng != ""))) {
                            value = ((value_lat != "") && (value_lng != "")) ? value_lat + ", " + value_lng: "";
                            summary.push(label + visform.oSummarySecondElementLayout + value + visform.cSummarySecondElementLayout);
                        }
                    }
                    return;
                case 'signature' :
                    if (!jQuery("#" + formid + " #field" + o.id).prop("disabled") && !jQuery("#" + formid + " #field" + o.id).hasClass('noSummary')) {
                        const imgData = visForm.getVfSignatureImgFromCanvas({sigFieldId: "#" + formid + " #field" + o.id + "_sig", formid: formid});
                        if ((!visform.hideemptyfieldsinsummary) || (imgData != "")) {
                            if (imgData.substring(0, 4) !== "data") {
                                value = imgData;
                            }
                            else {
                                value = '<img src="' + imgData + '" />';
                            }
                            summary.push(label + visform.oSummarySecondElementLayout + value + visform.cSummarySecondElementLayout);
                        }
                    }
                    return;
                case 'file' :
                    if (!jQuery("#" + formid + " #field" + o.id).prop("disabled")) {
                        value = jQuery("#" + formid + " #field" + o.id).val();
                        // input element of upload field is not always displayed in form
                        if (typeof  value === "undefined") {
                            return;
                        }
                        if ((!visform.hideemptyfieldsinsummary) || (value != "")) {
                            value = value.replace(/^.+(?=[\\\/])\\/, "");
                            summary.push(label + visform.oSummarySecondElementLayout + value + visform.cSummarySecondElementLayout);
                        }
                    }
                    return;
                default :
                    if (!jQuery("#" + formid + " #field" + o.id).prop("disabled")) {
                        value = jQuery("#" + formid + " #field" + o.id).val();
                        if ((!visform.hideemptyfieldsinsummary) || (value != "")) {
                            summary.push(label + visform.oSummarySecondElementLayout + value + visform.cSummarySecondElementLayout);
                        }
                    }
                    return;
            }
        })
        if (visform.summaryRowLayout) {
            htmlsummary = summary.join("</"+ visform.summaryRowLayout+"><"+ visform.summaryRowLayout +">");
            htmlsummary = "<"+ visform.summaryRowLayout +">" + htmlsummary + "</"+ visform.summaryRowLayout+">";
        }
        else {
            htmlsummary = summary.join("");
        }
        if (htmlsummary !== "") {
            htmlsummary = '<' + visform.summaryLayout + ' id="'+formid+'_summary" class="'+ visform.summaryLayoutClass+' visforms_summary">' + htmlsummary + '</' +  visform.summaryLayout + '>';
            jQuery("#" + formid + "_summarypage").prepend(htmlsummary);
        }
    },
    verifyMail: function (event) {
        let item = event.target;
        if (item.nodeName === 'SPAN' && ['A', 'BUTTON'].includes(item.parentNode.nodeName)) {
            item = item.parentNode;
        }
        if (item.nodeName === 'A') {
            event.preventDefault();
        }
        if (item.hasAttribute('disabled') || !item.hasAttribute('data-fieldid') || !item.hasAttribute('data-fid') || !item.hasAttribute('data-token')|| !item.hasAttribute('data-baseurl')) {
            return;
        }
        const {
            fieldid
        } = item.dataset;
        const {
            fid
        } = item.dataset;
        const {
            token
        } = item.dataset;
        const {
            baseurl
        } = item.dataset;
        const adr = jQuery("#" + fieldid).val();
        const pData = {};
        pData[token] = 1;
        pData['verificationAddr'] = adr;
        pData['fid'] = fid;
        jQuery.ajax({
            type: 'POST',
            url: baseurl + '/index.php?option=com_visforms&task=visforms.sendVerficationMail',
            data : pData,
            dataType: 'text',
            success: function (data, textStatus, jqXHR) {
                alert(data);
            },
            error: function(jqXHR, textStatus, errorThrown) {
                visForm.showAjaxError(jqXHR.responseText, errorThrown);
            }
        });
    },
    validateDateOnUpdate : function (event) {
        let input = event.target;
        jQuery(input).valid();
        jQuery(".isCal").trigger("update");
        return true;
    },
    getVfSignatureImgFromCanvas : function (sigFieldOptions) {
        sigFieldOptions = sigFieldOptions || {};
        if (!sigFieldOptions.sigFieldId) {
            return false;
        }
        if (!sigFieldOptions.formid) {
            return false;
        }
        let canvasContainer = document.querySelector(sigFieldOptions.sigFieldId);
        const {api} = canvasContainer.dataset;
        const settings = jQuery.data(jQuery("#" + sigFieldOptions.formid).get(0), 'visformsettings');
        let errorMsg = settings.texts.txtCantCreateSigImage;
        let data, src;
        // jSignature
        if (!api) {
            // translated texts can be found in the visformsetting data of the form
            // always returns true in modern browsers. Returns true or false as expected in old browsers
            let supportsSvg = document.implementation.hasFeature("http://www.w3.org/TR/SVG11/feature#Shape", "1.0");
            let dataFormat = (supportsSvg) ? "image/svg+xml;base64" : "image";
            let imgFormat = (supportsSvg) ? "image/svg+xml;base64" : "image/png;base64";
            try {
                data = jQuery(sigFieldOptions.sigFieldId).jSignature("getData", dataFormat);
                src = "data:" + imgFormat + "," + data[1];
                return src;
            } catch (ex) {
                return errorMsg;
            }
        }
        // signaturePad
        else if (api === "1") {
            let canvas = document.querySelector(sigFieldOptions.sigFieldId + " canvas");
            const {
                fieldid
            } = canvas.dataset;
            return jQuery("#field" + fieldid).val();
        }
        return errorMsg;
    },
    initVfSignature : function (fieldOptions) {
        fieldOptions = fieldOptions || {} ;
        if (!fieldOptions.fieldId) {return false;}
        let resetText = fieldOptions.texts.resetText;
        let unlockText = fieldOptions.texts.unlockText;
        let lockText = fieldOptions.texts.lockText;
        this.fieldId = fieldOptions.fieldId; // ToDo sets field id in visForm object; not really necessary because it is only used inside the initVfSignature; could use let fieldId instead as a shorthand or simply fieldOptions.fieldId
        jQuery("#field" + this.fieldId + "_sig").jSignature({cssclass:"visCanvas",width:fieldOptions.width, height:fieldOptions.height});
        jQuery('<input type="button" value="'+resetText+'" class="vfSigReset">').on("click", {field: this.fieldId}, function(e){
            jQuery("#field" + e.data.field + "_sig").jSignature("reset");
            jQuery("#field" + e.data.field).val("");
        }).appendTo(jQuery("#field" + this.fieldId + "_sigtools"));
        jQuery("#field" + this.fieldId + "_sig canvas").attr('tabindex', '0');
        jQuery("#field" + this.fieldId + "_sig canvas").attr('aria-label', fieldOptions.label);
        jQuery("#field" + this.fieldId + "_sig canvas").attr('aria-labelledby', fieldOptions.fieldName + "_siglbl");
        // prevent unintentional writing on mobiles on scroll
        if (("ontouchstart" in window) || navigator.maxTouchPoints || (fieldOptions.lockCanvas && !(jQuery("#field" + this.fieldId + "_sig").hasClass("isForbidden")))) {
            jQuery('<input type="button" value="'+unlockText+'" class="vfUnlockC">').on("click", {field: this.fieldId}, function(e){
                visForm.enableJSignature({field: e.data.field});
            }).appendTo(jQuery("#field" + this.fieldId + "_sigtools"));
            jQuery('<input type="button" value="'+lockText+'" class="vfLockC">').on("click", {field: this.fieldId}, function(e){
                visForm.disableJSignature({field: e.data.field});
            }).appendTo(jQuery("#field" + this.fieldId + "_sigtools"));
            this.disableJSignature({field: this.fieldId});
        }
        jQuery("#field" + this.fieldId + "_sig").on("change", {field: this.fieldId}, function (e) {
            var data = jQuery("#field" + e.data.field + "_sig").jSignature("getData", "base30");
            if(jQuery.isArray(data) && (data.length === 2) && (data[1] !== "")){
                jQuery("#field" + e.data.field).val(data.join(","))
            }
            else {
                jQuery("#field" + e.data.field).val("");
            }
            jQuery("#field" + e.data.field).valid();
        });
        jQuery("#field" + this.fieldId + "_sig").closest("form").on("reset", {field: this.fieldId}, function(e) {
            // jSignature("reset") empties the canvas and existing data and triggers a change event, which results in setting the value in the text-input to ''
            jQuery("#field" + e.data.field + "_sig").jSignature("reset");
        });
        if (jQuery("#field" + this.fieldId + "_sig").hasClass("isForbidden")) {
            visForm.disableJSignature({field: this.fieldId});
        }
    },
    // lock canvas, used in edit view and on mobile
    disableJSignature : function(data){
        jQuery("#field" + data.field + "_sig").jSignature("disable");
        visForm.hideDisableSignatureControls(data);
    },
    // unlock canvas, used in edit view and on mobile
    enableJSignature : function(data){
        jQuery("#field" + data.field + "_sig").jSignature("enable");
        visForm.hideEnableSignatureControls(data);
    },
    initVfSignaturePad : function (fieldOptions) {
        fieldOptions = fieldOptions || {} ;
        if (!fieldOptions.fieldId) {return false;}
        const resetText = fieldOptions.texts.resetText;
        const unlockText = fieldOptions.texts.unlockText;
        const lockText = fieldOptions.texts.lockText;
        const fieldId = fieldOptions.fieldId;
        const canvasContainer = document.getElementById("field" + fieldId + "_sig");
        const canvas = document.querySelector("#field" + fieldId + "_sig canvas");
        const signaturePad = new SignaturePad(canvas);
        jQuery('<input type="button" value="' + resetText + '" class="vfSigReset">').on("click", {field: fieldId}, function (e) {
            signaturePad.clear();
            jQuery("#field" + e.data.field).val("");
        }).appendTo(jQuery("#field" + fieldId + "_sigtools"));
        // Add lock/unlock buttons if lockCanvas is set or we are on a device with ontouchstart and canvas container has not isForbidden
        // isForbidden set on control group div = user has no permission to edit the data
        // isForbidden set on canvas container div = field is set to 'readonly' in field configuration
        // we look for isForbidden on canvas container div here!
        if (("ontouchstart" in window) || navigator.maxTouchPoints || (fieldOptions.lockCanvas && !(jQuery("#field" + fieldId + "_sig").hasClass("isForbidden")))) {
            jQuery('<input type="button" value="' + unlockText + '" class="vfUnlockC">').on("click", {field: fieldId}, function (e) {
                signaturePad.on();
                visForm.hideEnableSignatureControls({field: e.data.field});
            }).appendTo(jQuery("#field" + fieldId + "_sigtools"));
            jQuery('<input type="button" value="' + lockText + '" class="vfLockC">').on("click", {field: fieldId}, function (e) {
                signaturePad.off();
                visForm.hideDisableSignatureControls({field: e.data.field});
            }).appendTo(jQuery("#field" + fieldId + "_sigtools"));
            signaturePad.off();
            visForm.hideDisableSignatureControls({field: fieldId});
        }
        // store stroke data in text-input
        signaturePad.addEventListener("endStroke", () => {
            const data = signaturePad.toDataURL();
            const {
                fieldid
            } = signaturePad.canvas.dataset;
            jQuery("#field" + fieldid).val(data);
        });
        // handle reset on form (form view only)
        jQuery("#field" + fieldId + "_sig").closest("form").on("reset",  function (e) {
            visForm.resetSignaturePadCanvasDataToEmpty(fieldId, signaturePad);
        });
        // after value is set in text-input, make sure, that the correct data are displayed on canvas
        // add event handler for visforms event visfieldInitialised
        jQuery("#field" + fieldId + "_sig").closest("form").on('visfieldInitialized', function() {
            // get value in text-input
            let data = jQuery("#field" + fieldId).val();
            visForm.setImageOnCanvas(signaturePad, data);
        });
        // handle data displayed on canvas for conditional signature field
        // custom event displatched in showControl()
        // add event handler
        canvasContainer.addEventListener('replaceCanvasImage', (event) => {
            event.stopPropagation();
            visForm.setImageOnCanvas(signaturePad, event.detail);
        });
        if (jQuery("#field" + fieldId + "_sig").hasClass("isForbidden")) {
            signaturePad.off();
        }
    },
    resetSignaturePadCanvasDataToEmpty : function(fieldId, canvas) {
        // set text-input to empty
        jQuery("#field" + fieldId).val('');
        // clear canvas
        canvas.clear();
    },
    setImageOnCanvas: function (signaturePad, data) {
        if (data) {
            signaturePad.clear();
            signaturePad.fromDataURL(data);
        }
        else {
            signaturePad.clear();
        }
    },
    // toggle visibility of signature controls
    hideDisableSignatureControls : function (data) {
        jQuery("#field" + data.field + "_sigtools .vfSigReset").addClass('vishidden');
        jQuery("#field" + data.field + "_sigtools .vfLockC").addClass('vishidden');
        jQuery("#field" + data.field + "_sigtools .vfUnlockC").removeClass('vishidden');
    },
    hideEnableSignatureControls: function(data) {
        jQuery("#field" + data.field + "_sigtools .vfSigReset").removeClass('vishidden');
        jQuery("#field" + data.field + "_sigtools .vfLockC").removeClass('vishidden');
        jQuery("#field" + data.field + "_sigtools .vfUnlockC").addClass('vishidden');
    }
};
(function($) {
    $.extend($.fn, {
        initVisform : function (options) {
            const defaults = {
                // adding translated texts
                texts: {
                    txtCantCreateSigImage: "Problems to display signature as image."
                }
            };
            const settings = jQuery.extend(true, {}, defaults, options);
            // store form information with the form object in javascript
            const visform = $.data(this[0], "visform");
            if ((!visform) || typeof visform === "undefined") {
                $.data( this[0], "visform", options.visform );
                $.data( this[0], "visformsettings", settings );
            }
            // store user input information with the form object in javascript
            const userinputs = $.data(this[0], "userinputs");
            if ((!userinputs) || typeof userinputs === "undefined") {
                if (!options.visform.useSession && options.userInputs) {
                    $.data( this[0], "userinputs", options.userInputs );
                }
                else {
                    this.setUserInputs(options.visform);
                }
            }

            jQuery("#" + options.visform.parentFormId + "_processform").addClass('vishidden');
            this.initFields(options.visform);
            jQuery(".conditional").on("checkConditionalState", {
                restricts: options.restrictData,
                userInputs: options.userInputs
            }, function (e) {
                jQuery(this).toggleDisplay(e.data);
            });
            // uikit
            jQuery(this).closest("form").on("shown", function () {
                jQuery(this).trigger('reloadVfMap');
                jQuery(this).children("fieldset.active").trigger('setFocusOnClassChange');
            });
            // Bootstrap 5
            jQuery(this).closest("form").on("shown.bs.collapse", function () {
                jQuery(this).trigger('reloadVfMap');
                jQuery(this).children("fieldset.active").trigger('setFocusOnClassChange');
            });
            jQuery("#" + options.visform.parentFormId).trigger('visformsInitialised');
            this.focusInvalidForm(options.visform);
        },
        initFields : function (visform) {
            const userinputs = $.data($("#" + visform.parentFormId).get(0), 'userinputs');
            if ((!userinputs) || typeof userinputs === "undefined") {
                return;
            }
            jQuery.each(userinputs, function (i, obj) {
                if (obj.value === "undefined") {
                    return;
                }
                if (obj.isDisabled === true && obj.isForbidden !== true) {
                    // these fields stay with there configuration default
                    return;
                }
                // HTML Controls are set with attributes value, selected and checked according to the settings in the field configuration
                // This ensures that the js properties defaultValue, defaultSelected and defaultChecked are true the default values
                // So that we can use these js properties to reset disabled fields
                // And so that 'reset'-Button will have the expected result (even if we are in a redisplay task after php validation of user inputs failed)
                // if we have a Redisplay Task (php validation of user inputs failed) we want to set the valid user inputs, which were already made, in the form
                // set to user input values
                // if a field is readonly the configuration default and the user input are the same (except, when the field value was set with an url param)
                switch (obj.type) {
                    case "select":
                    case "selectsql":
                        if (jQuery.isPlainObject(obj.value)) {
                            jQuery(this).setSelectedOptions(obj);
                        }
                        break;
                    case "multicheckbox":
                    case "multicheckboxsql":
                        if (jQuery.isPlainObject(obj.value)) {
                            const boxes = jQuery("#" + visform.parentFormId + " ." + obj.label).find('input');
                            jQuery.each(boxes, function (i, el) {
                                jQuery.each(obj.value, function (ix, val) {
                                    if (jQuery(el).attr('value') === val) {
                                        jQuery(el).prop('checked', true);
                                        // you have to return false to break from an each loop
                                        return false;
                                    }
                                    jQuery(el).prop('checked', false);
                                    return;
                                });
                            });
                        }
                        break;
                    case "radio":
                    case "radiosql":
                        const radios = jQuery("#" + visform.parentFormId + " ." + obj.label).find('input');
                        jQuery.each(radios, function (i, el) {
                            if (jQuery(el).attr('value') === obj.value) {
                                jQuery(el).prop('checked', true);
                            }
                            else {
                                jQuery(el).prop('checked', false);
                            }
                        });
                        break;
                    case "checkbox":
                        jQuery("#" + obj.label).prop("checked", obj.value);
                        jQuery("#" + obj.label).trigger("recalculate");
                        break;
                    case "signature" :
                        jQuery("#" + obj.label).val(obj.value);
                        if (obj.value) {
                            if (obj.value.startsWith('image/jsignature;base30')) {
                                jQuery("#" + obj.label + "_sig").jSignature("setData", "data:" + obj.value);
                            }
                            else {
                                // signaturePad can only be populated by using an event handler, which is implemented on initialisation
                            }
                        }
                        break;
                    case "date" :
                        // Calendar field needs special treatment
                        // all Calender fields are accessible through JoomlaCalendar.getCalObject(element)._joomlaCalendar;
                        // where element is the HTML Input field
                        // the _joomlaCalendar is attached to the parent ('.field-calender') element and can be called directly
                        // if there is no _joomlaCalendar for a field, this getCalObject() returns false
                        // change the data-alt-value
                        // call checkInputs() on the _joomlaCalendar to properly set the value in a date field
                        jQuery("#" + obj.label).attr('value', obj.value);
                        jQuery("#" + obj.label).attr('data-alt-value', obj.value);
                        // calObj = jQuery("#" + obj.label).closest('.field-calendar')[0]._joomlaCalendar;
                        let calObj = JoomlaCalendar.getCalObject(jQuery("#" + obj.label)[0]);
                        if (calObj) {
                            let calendar = calObj._joomlaCalendar;
                            calendar.checkInputs();
                        }
                        jQuery("#" + obj.label).trigger("recalculate");
                        break;
                    case "textarea" :
                        // set value in textarea
                        let text = obj.value.replace(/&#64/g, '@');
                        jQuery("#" + obj.label).val(text);
                        // console.log('textarea ' + obj.label + ': content set = ' + text);
                        break;
                    default:
                        // replace used to prevent email cloaking in form used in content (plg or module)
                        if (typeof obj.value.replace !== 'undefined') {
                            jQuery("#" + obj.label).val(obj.value.replace(/&#64/g, '@'));
                            jQuery("#" + obj.label).trigger("recalculate");
                        }
                        break;
                }
            });
            // ToDo consider if yo want to do this
            // enable the buttons only if there is no javascript error on the page
            jQuery("#" + visform.parentFormId + ' input[type="submit"]').prop('disabled', false);
            jQuery("#" + visform.parentFormId + ' input[type="image"]').prop('disabled', false);
            jQuery("#" + visform.parentFormId + ' input[type="reset"]').prop('disabled', false);
            // Select a solitary option in selectSQL Field, if option is enabled
            jQuery("#" + visform.parentFormId + ' .preSelectedSolitaryOption').each( function (i, el) {
                visForm.preSelectSolitaryOption(jQuery(el).attr('id'))
            });
            // necessary in edit view
            jQuery("#" + visform.parentFormId + ' input[type="radio"]').trigger('reloadsqloptions');
            jQuery("#" + visform.parentFormId + ' input[type="checkbox"]').trigger('reloadsqloptions');
            jQuery("#" + visform.parentFormId + ' select').trigger('reloadsqloptions');
            jQuery("#" + visform.parentFormId + ' input[type="text"]').trigger('reloadsqloptions');
            jQuery("#" + visform.parentFormId + ' input[type="email"]').trigger('reloadsqloptions');
            jQuery("#" + visform.parentFormId + ' input[type="date"]').trigger('reloadsqloptions');
            jQuery("#" + visform.parentFormId + ' input[type="url"]').trigger('reloadsqloptions');
            jQuery("#" + visform.parentFormId + ' input[type="number"]').trigger('reloadsqloptions');
            jQuery("#" + visform.parentFormId + ' input[type="hidden"]').trigger('reloadsqloptions');
            jQuery("#" + visform.parentFormId + ' input[type="tel"]').trigger('reloadsqloptions');
            jQuery("#" + visform.parentFormId + ' input[type="password"]').trigger('reloadsqloptions');
            visForm.hideSqlOptionList(visform.parentFormId);
            visForm.hideSqlDataList(visform.parentFormId);
            jQuery("#" + visform.parentFormId).trigger('visfieldInitialized');
            // initialize tinymce editor if present and function is defined: must be done after the text was set to the textarea
            if (typeof tinyMCE !== 'undefined' && typeof initTinyMCE === 'function') {
                initTinyMCE();
            }
            // pseudo readonly for non mutable html controls
            // native JS implementation using data-Attribute
            let pseudoReadonlyElments = document.querySelectorAll("#" + visform.parentFormId + ' [data-readonly="1"]');
            pseudoReadonlyElments.forEach(readonlyElement => {
                readonlyElement.style.pointerEvents = 'none';
                if (readonlyElement.type === "checkbox" || readonlyElement.type === "radio") {
                    readonlyElement.addEventListener('click', e => {
                        e.preventDefault();
                        return false;
                    });
                    return true;
                }
                if (readonlyElement.nodeName === "SELECT") {
                    readonlyElement.addEventListener('change', e => {
                        jQuery.each(userinputs, function (i, obj) {
                            if (obj.label === readonlyElement.id) {
                                if (obj.value === "undefined") {
                                    return;
                                }
                                if (obj.isDisabled === true && obj.isForbidden !== true) {
                                    // these fields stay with there configuration default
                                    return;
                                }
                                jQuery(this).setSelectedOptions(obj);
                            }
                        })
                        jQuery('#'+readonlyElement.id).trigger("change");
                    });
                    return true;
                }
            });
        },
        setSelectedOptions : function (obj) {
            if (jQuery.isPlainObject(obj.value)) {
                const seloptions = jQuery("#" + obj.label).find('option');
                const isSearchSelect = $("#" + obj.label).hasClass('select2-hidden-accessible');
                jQuery.each(seloptions, function (i, el) {
                    jQuery.each(obj.value, function (i, val) {
                        if (jQuery(el).attr('value') === val) {
                            jQuery(el).prop('selected', true);
                            if (isSearchSelect) {
                                $('#select2-' + obj.label + '-container').html($(el).html());
                                $("#" + obj.label).trigger('change');
                            }
                            // you have to return false to break from an each loop
                            return false;
                        }
                        jQuery(el).prop('selected', false);
                        return;
                    });
                });
                // preselect solitary option and hide option list according to field configuration
                if (obj.type === "selectsql") {
                    visForm.preSelectSolitaryOption(obj.label.replace('field',''));
                }
                if (obj.type === "select") {
                    jQuery("#" + obj.label).trigger("recalculate");
                }
            }
        },
        focusInvalidForm : function (visform) {
            if (jQuery('#' + visform.parentFormId).parent('.visforms.php-error')) {
                // php error
                // focus message error message block
                let errorContainer = jQuery('#' + visform.parentFormId).parent('.visforms.php-error').find('#form-error-container');
                if (errorContainer.length) {
                    visForm.focusjQueryElementTop(errorContainer);
                }
            }
        },
        setUserInputs: function (visform) {
            const formElement = jQuery('#' + visform.parentFormId)
            const formData = jQuery(formElement).serializeArray();
            let baseUrl = visform.baseUrl;
            jQuery.ajax({
                type: 'POST',
                url: baseUrl + '/index.php?option=com_visforms&task=visforms.getUserInputs&id=' + visform.fid,
                data: formData,
                success: function(data, textStatus, jqXHR) {
                    $.data($("#" + visform.parentFormId).get(0),  "userinputs", data)
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    // give error feedback
                    visForm.showAjaxError(jqXHR.responseText, errorThrown);
                },
                dataType: 'json',
                async: false
            });
        }
    });
}(jQuery));

jQuery(document).ready(function () {
    // "static" scripts which should only be included once

    // fix placeholder for IE7, IE8, IE9
    if (!jQuery.support.placeholder) {
        jQuery("[placeholder]").focus(function () {
            if (jQuery(this).val() == jQuery(this).attr("placeholder")) jQuery(this).val("");
        }).blur(function () {
            if (jQuery(this).val() == "") jQuery(this).val(jQuery(this).attr("placeholder"));
        }).blur();

        jQuery("[placeholder]").parents("form").submit(function () {
            jQuery(this).find('[placeholder]').each(function () {
                if (jQuery(this).val() == jQuery(this).attr("placeholder")) {
                    jQuery(this).val("");
                }
            });
        });
    }

    // keyup event triggers validation if element is marked as invalid
    jQuery("input[type='number']").on("input mouseup", function () {
        jQuery(this).trigger("keyup");
    });
    jQuery("input[type='file']").on("change", function () {
        jQuery(this).trigger("keyup").trigger("focus");
    })
    jQuery("input[type='file']").on("blur", function () {
        if (!(jQuery(this).get(0).files.length == 0)) {
            const id = jQuery(this).attr('id');
            jQuery('[data-clear-target="'+id+'"]').removeClass("vishidden").addClass("active");
        }
    });
    jQuery("a.clear-selection").addClass('vishidden');
    jQuery("a.clear-selection").on("click", function(e) {
        const uploadid = jQuery(this).attr('data-clear-target');
        let el = jQuery('#' + uploadid);
        el.replaceWith(el.val('').clone(true));
        // get the new jQuery object of el
        el = jQuery('#' + uploadid);
        el.trigger('keyup');
        jQuery(this).removeClass("active").addClass('vishidden');
        e.preventDefault();
        return false;
    });
    const successMessageClose = jQuery(".visforms-form joomla-alert[type=\"success\"] .joomla-alert--close");
    if (successMessageClose) {
        const form = successMessageClose.parents(".visforms-form").find("form");
        const description = successMessageClose.parents(".visforms-form").find(".category-desc");
        form.addClass('vishidden');
        description.addClass('vishidden');
        successMessageClose.on("click", function() {
            jQuery(this).parents(".visforms-form").find("form").removeClass('vishidden');
            jQuery(this).parents(".visforms-form").find(".category-desc").removeClass('vishidden');
            jQuery(this).parents(".visforms-form").find("form").trigger("reloadVfMap");
        });
    }

    // multi step forms
    jQuery('.visform .next_btn').on('click', function (){
        jQuery(this).closest('[class^="fieldset-"]').find('input, textarea, select').not(":disabled").removeClass("ignore");
        jQuery(this).closest('[class^="fieldset-"]').siblings('[class^="fieldset-"]').find('input, textarea, select').not(":disabled, .btn, .uk-button").addClass("ignore");
        visForm.onNextButtonClick(this);
    });

    jQuery('.visform .summary_btn').on('click', function (){
        jQuery(this).closest('[class^="fieldset-"]').find('input, textarea, select').not(":disabled").removeClass("ignore");
        jQuery(this).closest('[class^="fieldset-"]').siblings('[class^="fieldset-"]').find('input, textarea, select').not(":disabled, .btn, .uk-button").addClass("ignore");
        visForm.onSummaryButtonClick(this)
    });

    jQuery(".visform .back_btn").on('click', function () {
        const visform = jQuery(this).closest('form');
        jQuery(this).closest("[class^='fieldset-']").prev().removeClass("vishidden").addClass('active');
        jQuery(this).closest("[class^='fieldset-']").prev().trigger("reloadVfMap");
        jQuery(this).closest("[class^='fieldset-']").addClass("vishidden").removeClass('active');
        // trigger after active was removed from current fieldset
        jQuery(this).closest("[class^='fieldset-']").prev().trigger('setFocusOnClassChange',["back"]);
        const activeBadge = jQuery(visform).find('.visprogress .badge.badge-important');
        jQuery(activeBadge).removeClass("badge-important");
        jQuery(activeBadge).closest('.stepCont').prev().find('.badge').removeClass("badge-success").addClass("badge-important");
    });

    jQuery(".visform .fieldset-1 :reset").on('click', function (e) {
        e.preventDefault();
        jQuery(this).closest('form').get(0).reset();
        // set userinputs of this form to empty array; We can do this, because the edit views do not have a reset button.
        // So the stored user inputs which are in the userinputs array and which must not get lost, are not deleted by this call
        jQuery.data(jQuery((this).closest('form')).get(0), 'userinputs', []);
        jQuery(".conditional").trigger("checkConditionalState");
        // Trigger change event is needed to recalculate
        jQuery(this).closest('form').find('input').trigger("change");
        jQuery(this).closest('form').find('select').trigger("change");
    });

    // action for reset button on summary page
    jQuery(".visform fieldset:not(.fieldset-1) :reset").on('click', function (e) {
        e.preventDefault();
        jQuery(this).closest('form').get(0).reset();
        // set userinputs of this form to empty array; We can do this, because the edit views do not have a reset button.
        // So the stored user inputs which are in the userinputs array and which must not get lost, are not deleted by this call
        jQuery.data(jQuery((this).closest('form')).get(0), 'userinputs', []);
        jQuery(".conditional").trigger("checkConditionalState");
        // Trigger change event is needed to recalculate
        jQuery(this).closest('form').find('input').trigger("change");
        jQuery(this).closest('form').find('select').trigger("change");
        const formid = jQuery(this).closest("form").get(0).id;
        jQuery("#" + formid + "_summary").remove();
        jQuery(this).closest("[class^='fieldset-']").parent().find("[class^='fieldset-']").first().removeClass("vishidden").addClass('active');
        jQuery(this).closest("[class^='fieldset-']").parent().find("[class^='fieldset-']").first().trigger("reloadVfMap");
        jQuery(this).closest("[class^='fieldset-']").addClass("vishidden").removeClass('active');
        jQuery("#" + formid + " .visprogress .stepCont .badge").removeClass("badge-important badge-success");
        jQuery("#" + formid + " .visprogress .stepCont:first .badge").addClass("badge-important");
    });

    // correct button on summary page
    jQuery(".visform .correct_btn").on('click',function () {
        const formid = jQuery(this).closest("form").get(0).id;
        jQuery("#" + formid + "_summary").remove();
        jQuery(this).closest("[class^='fieldset-']").prev().removeClass("vishidden").addClass('active');
        jQuery(this).closest("[class^='fieldset-']").prev().trigger("reloadVfMap");
        jQuery(this).closest("[class^='fieldset-']").addClass("vishidden").removeClass('active');
        jQuery(this).closest("[class^='fieldset-']").prev().trigger('setFocusOnClassChange',["back"]);
        jQuery("#" + formid + " .visprogress .stepCont:last .badge").removeClass("badge-important");
        jQuery("#" + formid + " .visprogress .stepCont:nth-last-child(2) .badge").removeClass("badge-success").addClass("badge-important");
    });

    jQuery(".noEnterSubmit").keypress(function (event) {
        const key = event.keyCode;
        if (key === 13) {
            event.preventDefault();
            event.stopPropagation();
            return false;
        }
    });

    jQuery("fieldset.mpfocustop, fieldset.mpfocusbottom").on('setFocusOnClassChange', function (e, direction) {
        // direction not used yet, could be used to have different focus settings on backwards and forwards
        let fieldset = e.target;
        if (fieldset) {
            fieldset = jQuery(fieldset);
            let windowHeight = jQuery(window).height();
            // top of fieldset relative to document
            let elOffset = fieldset.offset().top;
            // height of fieldset
            let elHeight = fieldset.prop("scrollHeight");// fieldset.height();
            let focusTarget = (jQuery(fieldset).hasClass('mpfocusbottom')) ? 'bottom' : 'top';
            let offset;
            if (focusTarget === 'top') {
                offset = elOffset;
            }
            else {
                offset = elOffset  + elHeight - (windowHeight / 4);
            }
            let speed = 700;
            jQuery('html, body').animate({scrollTop: offset}, speed);
        }
    });
    setupVfFormViewTasks({
        target: document
    });

    jQuery(document).displayChanger();

});

const setupVfFormViewTasks = ({target}) => {
    target.querySelectorAll('.verifyMailBtn').forEach(
        element => element.addEventListener('click', visForm.verifyMail)
    );
    target.querySelectorAll('.viscalendar-input').forEach(
        element => element.addEventListener('click', visForm.validateDateOnUpdate)
    );
};