<?php
/**
 * Visforms HTMLLayout class 
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6 
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

/* @deprecated 5.5 will be removed in Visforms 6.0
 *              Use \Visolutions\Component\Visforms\Site\Lib\Html\Layout\HtmlLayoutAwareTrait and
 *              the class \Visolutions\Component\Visforms\Site\Lib\Html\Layout\HtmlLayout instead
 */
abstract class VisformsHtmllayout
{
	public static function getInstance($type, $fieldHtml, $subType = 'horizontal') {
		if (empty($type)) {
			$type = 'visforms';
		}
        switch ($type) {
            case 'bt5' :
                $className = 'Bt5Layout';
                break;
            case 'editbt5' :
                $className = 'Bt5EditLayout';
                break;
            case 'uikit3' :
                $className = 'Uikit3Layout';
                break;
            case 'edituikit3' :
                $className = 'Uikit3EditLayout';
                break;
            case 'edit' :
                $className = 'NoneEditLayout';
                break;
            default :
                $className = 'NoneLayout';
        }
        $className = '\Visolutions\Component\Visforms\Site\Lib\Html\Layout\\'.$className;
        if (!class_exists($className)) {
            return false;
        }
		// delegate to the appropriate class
		return new $className($type, $fieldHtml, $subType);
	}
}