<?php
/**
 * Visforms Layout class
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */
// no direct access
defined('_JEXEC') or die('Restricted access');

/* @deprecated 5.5 will be removed in Visforms 6.0
 *              Use the class \Visolutions\Component\Visforms\Site\Lib\Layout\LayoutAwareTrait instead
 */

abstract class VisformsLayout
{
	public static function getInstance($type = 'visforms', $options = null) {
		switch ($type) {
            case 'edit':
                $classname = 'NoneEditLayout';
                break;
            case 'bt5':
                $classname = 'Bt5Layout';
                break;
            case 'editbt5':
                $classname = 'Bt5EditLayout';
                break;
            case 'uikit3':
                $classname = 'Uikit3Layout';
                break;
            case 'edituikit':
                $classname = 'Uikit3EditLayout';
                break;
            default:
                $classname = 'NoneLayout';
        }
		$form = new \stdClass();
        if (!(is_null($options))) {
            if (isset($options['showRequiredAsterix'])) {
                $form->showRequiredAsterix = $options['showRequiredAsterix'];
            }
            if (isset($options['parentFormId'])) {
                $form->parentFormId = $options['parentFormId'];
            }
            if (isset($options['defaultresponsive'])) {
                $form->defaultresponsive = $options['defaultresponsive'];
            }
        }
        $classname = '\Visolutions\Component\Visforms\Site\Lib\Layout\\' . $classname;
        if (!class_exists($classname)) {
            return false;
        }
		// delegate to the appropriate subclass
		return new $classname($form);
	}
}