<?php
/**
 * Visforms validation class
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6 
 */

// no direct access
defined('_JEXEC') or die('Restricted access');
/* @deprecated 5.3 will be removed in Visforms 6.0
 *              Use the class \Visolutions\Component\Visforms\Site\Lib\Validation\Validation instead
 */

abstract class VisformsValidate
{
      public static function validate($type, $args) {
           switch ($type) {
               case 'custom':
               case 'date':
               case 'digit':
               case 'email':
               case 'latitude':
               case 'longitude':
               case 'number':
               case 'url':
                   $classname = ucfirst($type) . 'Validation';
                   break;
               case 'equalto':
                   $classname = 'EqualToValidation';
                   break;
               case 'max':
               case 'min':
                   $classname = ucfirst($type) .'NumberValidation';
                   break;
               case 'maxdate':
                   $classname = 'MaxDateValidation';
                   break;
               case 'mindate':
                   $classname = 'MinDateValidation';
                   break;
               case 'minage':
                   $classname = 'MinAgeValidation';
                   break;
               case 'notempty':
                   $classname = 'NotEmptyValidation';
                   break;
               case 'tel':
                   $classname = 'PhoneValidation';
                   break;
               case 'verificationcode':
                   $classname = 'VerificationCodeValidation';
                   break;
               default:
                   $classname = '';
                   break;
           }
           $classname = '\Visolutions\Component\Visforms\Site\Lib\Validation\\' . $classname;
           if (!class_exists($classname)) {
               throw new RuntimeException('Unable to load validation class ' . $classname);
           }
           // Validate with the appropriate subclass
           $validation = new $classname($args);
           $valid = $validation->validate();
           return $valid;
       }
}