<?php
/**
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2019 vi-solutions
 */
namespace  Visolutions\Component\Visforms\Site\Lib\Business;
// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;

class SelectsqlFieldBusiness extends SelectFieldBusiness {

	protected $reloadTriggerFields = array();
	protected $alreadyChecked = array();

	protected function setField() {
		$this->setCustomJs();
		$this->setIsDisabled();
		if (isset($this->field->dataSource) && $this->field->dataSource == 'post') {
			$this->validatePostValue();
		}
		$this->addShowWhenForForm();
	}

	protected function setCustomJs() {
	    parent::setCustomJs();
		if (empty($this->field->toggle_reload)) {
			return true;
		}
		// no option reload, if we do not process SQL in Edit View but use stored values to create option list.
        if (!empty($this->field->noEditSqlProcess)) {
            return true;
        }
        // add record id as cid to event.data, neded if we are in an edit view
        $cid = 0;
        if ($this->form->displayState === $this->isEditTask || $this->form->displayState === $this->isRedisplayEditTask) {
            $cid = Factory::getApplication()->getInput()->getCmd('cid', 0);
        }
        $cidJs = ", cid: " . $cid;
        // Reload once, after form is loaded in order to set the options in the edit view
        $this->setOnloadReloadJs($cidJs, 'reloadOptionList');
		$this->reloadTriggerFields = isset($this->field->reload) ? $this->field->reload : array();
		if (empty($this->reloadTriggerFields)) {
			return true;
		}
		$this->removeDuplicateReloadTriggerFields();

		// foreach trigger field add a onchange handler which reloads the options of this field
		foreach ($this->reloadTriggerFields as $trigger) {
			foreach ($this->fields as $triggerField) {
			    $this->setReloadJs($triggerField, $trigger, $cidJs, 'reloadOptionList');
			}
		}
	}
}