<?php
/**
 * Visforms HTML class for text fields
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */
namespace  Visolutions\Component\Visforms\Site\Lib\Html\Field;

// no direct access
defined('_JEXEC') or die('Restricted access');

class CalculationField extends TextField
{
	public function __construct($field, $decorable, $attribute_type) {
		// set a custom class
		if (isset ($field->attribute_class)) {
			$field->attribute_class .= " visCSSinput isCal";
		}
		else {
			$field->attribute_class = "visCSSinput isCal";
		}
		parent::__construct($field, $decorable, $attribute_type);
	}

    // bootstrap 5
    public function setControlBt5HtmlClasses($field) {
        $field->attribute_class = " form-control isCal";
        return $field;
    }

	// uikit 3
	public function setUikit3ControlHtmlClasses($field) {
		$field->attribute_class = " isCal uk-input";
		return $field;
	}
	public function removeUnsupportedShowLabel($field) {
		unset($field->show_label);
		return $field;
	}

    public function setFieldCustomValidateArray($field) {
        if (!isset($field->validateArray)) {
            $field->validateArray = array();
        }
        if (!empty($field->mincalvalue)) {
            $field->validateArray['mincalvalue'] = $field->mincalvalue;
        }
        if (!empty($field->maxcalvalue)) {
            $field->validateArray['maxcalvalue'] = $field->maxcalvalue;
        }
        return $field;
    }
}