<?php
/**
 * Visforms validate max class
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */
namespace Visolutions\Component\Visforms\Site\Lib\Validation;

// no direct access
defined('_JEXEC') or die('Restricted access');

class MaxNumberValidation extends Validation
{
	protected $count;
	protected $maxCount;

	public function __construct($args) {
        parent::__construct($args);
		// we expect an item with key 'count' and an item with key 'maxcount' in $args
		$this->count = $this->args['count'] ?? 0;
		$this->maxCount = $this->args['maxcount'] ?? 0;
	}

    public function validate(): bool {
		if ($this->count > $this->maxCount) {
			return false;
		} 
		else {
			return true;
		}
	}
}