<?php
/**
 * Visforms validate max class
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */
namespace Visolutions\Component\Visforms\Site\Lib\Validation;

// no direct access
defined('_JEXEC') or die('Restricted access');
use Joomla\CMS\Factory;

class MinAgeValidation extends Validation
{
	protected $date;
	protected $minAge;
	protected $format;
	protected $today;
	protected $age;

	public function __construct($args) {
        parent::__construct($args);
		$this->date = $this->getTimesstamp($this->args['date'], $this->args['format']);
		$this->minAge = $this->args['minage'];
		$date = Factory::getDate('now' , 'UTC');
		// Test against date with Leap Day
		// $date = Factory::getDate('2023-02-28' , 'UTC');
		$date->setTime(0,0);
		$this->today = $date->getTimestamp();
		$this->calculateAge();
	}

    public function validate(): bool {
		if ($this->age < $this->minAge) {
			return false;
		} 
		else {
			return true;
		}
	}
	protected function getTimesstamp($date, $format) {
		$unifiedFromattedDate = \DateTime::createFromFormat($format, $date);
		$unifiedFromattedDate->setTimezone(new \DateTimeZone("UTC"));
		$unifiedFromattedDate->setTime(0,0);
		return $unifiedFromattedDate->getTimestamp();
	}

	protected function calculateAge() {
	    $years = date('Y', $this->today)-date('Y',$this->date);
	    $this->age = (date('md', date('U', $this->date)) > date('md', date('U', $this->today))) ? $years-1 : $years;
    }
}