<?php
/**
 * Visforms validate email class
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */
namespace Visolutions\Component\Visforms\Site\Lib\Validation;

// no direct access

defined('_JEXEC') or die('Restricted access');
use Visolutions\Component\Visforms\Site\Model\Helper\Mail\Verification;

/**
 * Visforms validate email
 *
 * @package        Joomla.Site
 * @subpackage     com_visforms
 * @since          1.6
 */
class VerificationCodeValidation extends Validation
{

	protected $value;
	protected $verificationAddr;

	public function __construct($args) {
        parent::__construct($args);
		$this->value = $this->args['value'] ?? "";
		$this->verificationAddr = $this->args['verificationAddr'] ?? "";
	}

    public function validate(): bool {
		$helper = new Verification($this->verificationAddr);
		$storedCodes = $helper->getStoredCodes();
		foreach ($storedCodes as $storedCode) {
			if ($this->value === $storedCode->code) {
				return true;
			}
		}
		return false;
	}
}