<?php
/**
 * Visforms view for Visforms
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */

namespace Visolutions\Component\Visforms\Site\View\Visforms;

// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Uri\Uri;
use Visolutions\Component\Visforms\Administrator\Helper\AefHelper;
use Visolutions\Component\Visforms\Site\Event\Visforms\VisformsFormPrepareEvent;
use Visolutions\Component\Visforms\Site\Event\Visforms\VisformsAddWebAssetsEvent;
use Joomla\CMS\Layout\LayoutHelper;
use Visolutions\Component\Visforms\Administrator\Helper\VisformsHelper;
use Visolutions\Component\Visforms\Site\Lib\Layout\LayoutAwareTrait;

/**
 * Visforms View class
 *
 * @package        Joomla.Site
 * @subpackage     com_visforms
 * @since          1.6
 */
class HtmlView extends BaseHtmlView
{
    use LayoutAwareTrait;
	protected $menu_params;
	protected $visforms;
	protected $formLink;
	protected $state;
	protected $return;
	protected $steps;
	protected $setFocus;
	protected $editLinks;
	protected $successMessage;
	protected $alreadySubmittedMessage;
	protected bool $hasPhpError = false;

	function display($tpl = null) {
		$layout = $this->getLayout();
		$app = Factory::getApplication();
		$wa = $app->getDocument()->getWebAssetManager();
		switch ($layout) {
			case 'message' :
				$this->visforms = $this->get('Form');
				$successMessage = $app->getUserState('com_visforms.messages.' . $this->visforms->context, '');
				PluginHelper::importPlugin('content');
				$this->successMessage = (!empty($successMessage)) ? HTMLHelper::_('content.prepare', $successMessage) : $successMessage;
				$app->setUserState('com_visforms.messages.' . $this->visforms->context, null);
				$app->setUserState('com_visforms.' . $this->visforms->context, null);
				PluginHelper::importPlugin('visforms');
				// Add frontend web assets to form and message view
				$visformsAddWebAssetsEvent = new VisformsAddWebAssetsEvent('onVisformsAddWebAssets', [
					'context' => 'com_visforms.form.message',
					'fid' => $this->visforms->id
				]);
				$this->getDispatcher()->dispatch('onVisformsAddWebAssets', $visformsAddWebAssetsEvent);
				break;
			default:
				$this->menu_params = $this->get('menuparams', 'visforms');
				$this->visforms = $this->get('Form');
				$this->return = HTMLHelper::_('visforms.base64_url_encode', Uri::getInstance()->toString());
				if (empty($this->visforms)) {
					$app->enqueueMessage(Text::_('COM_VISFORMS_FORM_MISSING') , 'error');
					return;
				}

				// check if user access level allows view
				$user = Factory::getApplication()->getIdentity();
				$groups = $user->getAuthorisedViewLevels();
				$access = (isset($this->visforms->access) && in_array($this->visforms->access, $groups)) ? true : false;
				if ($access == false) {
					$app->setUserState('com_visforms.' . $this->visforms->context . '.fields', null);
					$app->setUserState('com_visforms.' . $this->visforms->context, null);
					$app->enqueueMessage(Text::_('JERROR_ALERTNOAUTHOR') , 'error');
					return;
				}
				$currentDate = Factory::getDate()->format('Y-m-d H:i:s');
				$isNotPublishedYet = $this->visforms->publish_up > $currentDate;
				$isExpired = !is_null($this->visforms->publish_down) && $this->visforms->publish_down < $currentDate;
				$this->canDo = VisformsHelper::getActions($this->visforms->id);
				$this->hasPhpError = (isset($this->visforms->errors) && is_array($this->visforms->errors) && count($this->visforms->errors) > 0);
				// option singlesubmission is set and a logged in user
				if (!empty($this->visforms->singlesubmission) && $user->id !== 0 && AefHelper::checkAEF()) {
					// check if we already have a submission for this user and this form
					$datas = $this->get('Records');
					$hasAlreadySubmitted = 0;
					if (!empty($datas)) {
						$hasAlreadySubmitted = 1;
					}
					if ($hasAlreadySubmitted === 1) {
						if ((!empty($this->visforms->redirecttoeditview)) && (!empty($this->visforms->dataEditMenuExists)) && ($this->visforms->redirecttoeditview == 1 || $this->visforms->redirecttoeditview == 2)) {
							$this->editLinks = array();
							// check if user can edit their own data
							// get a list of the id's of all data already submitted by this user
							if ($this->canDo->get('core.edit.own.data')) {
								if (!empty($datas)) {
									foreach ($datas as $data) {
										if ((is_object($data)) && (!empty($data)) && !empty($data->id) && isset($data->published)) {
											if (!empty($data->published) || $this->canDo->get('core.edit.data.state') || $this->canDo->get('core.edit.own.data.state')) {
													if (!empty($this->visforms->rtev_link_text) && (!empty(trim($this->visforms->rtev_link_text)))) {
														$linkText = LayoutHelper::render('visforms.datas.replace', array('form' => $this->visforms, 'data' => $data, 'text' => $this->visforms->rtev_link_text), null, array('component' => 'com_visforms'));
													}
													else {
														$linkText = Text::_('COM_VISFORMS_EDIT_LINK_TEXT') . $data->id;
													}
												$this->editLinks[] = array((int)$data->id, $linkText);
											}
										}
									}
								}
							}
							// display an edit link or redirect to edit view
							if (!empty($this->editLinks) && isset($this->editLinks[0][0])) {
								if ($this->visforms->redirecttoeditview == 1) {
									$this->_layout = 'editlink';
									$app->setUserState('com_visforms.' . $this->visforms->context, null);
									PluginHelper::importPlugin('visforms');
									// Add frontend web assets to edit link view
									$visformsAddWebAssetsEvent = new VisformsAddWebAssetsEvent('onVisformsAddWebAssets', [
										'context' => 'com_visforms.form.edit_link',
										'fid' => $this->visforms->id
									]);
									$this->getDispatcher()->dispatch('onVisformsAddWebAssets', $visformsAddWebAssetsEvent);
									$this->prepareDocument();
									parent::display($tpl);
									return true;
								}
								if ($this->visforms->redirecttoeditview == 2) {
									// empty page, if form is not published
									if ($this->visforms->published != '1') {
										return;
									}
									// pick first id from $this->editlinks
									// redirect to edit view of this record set
									$app->setUserState('com_visforms.' . $this->visforms->context, null);
									$recordId = $this->editLinks[0][0];
									$redirectUri = '&return=' . HTMLHelper::_('visforms.base64_url_encode', 'index.php?Itemid=' . $this->visforms->dataEditMenuExists);
									$link = Uri::base() . 'index.php?option=com_visforms&view=edit&layout=edit&task=edit.editdata&id=' . (int)$this->visforms->id . '&cid=' . (int)$recordId . $redirectUri . '&Itemid=' . $this->visforms->dataEditMenuExists;
									$app->redirect($link, 200);
								}
							}
							// default to display message 'form can only be submitted once'
							else {
								$this->_layout = 'alreadysubmittedmessage';
								$this->alreadySubmittedMessage = "Sie haben das Formular bereits einmal übermittelt";
								$app->setUserState('com_visforms.' . $this->visforms->context, null);
								PluginHelper::importPlugin('visforms');
								// Add frontend web assets to edit link view
								$visformsAddWebAssetsEvent = new VisformsAddWebAssetsEvent('onVisformsAddWebAssets', [
									'context' => 'com_visforms.form.already_submitted_message',
									'fid' => $this->visforms->id
								]);
								$this->getDispatcher()->dispatch('onVisformsAddWebAssets', $visformsAddWebAssetsEvent);
								$this->prepareDocument();
								parent::display($tpl);
								return true;
							}
						}
						// display message 'form can only be submitted once'
						else {
							$this->_layout = 'alreadysubmittedmessage';
							$this->alreadySubmittedMessage = Text::_('COM_VISFORMS_FORM_WAS_ALREADY_SUBMITTED');
							$app->setUserState('com_visforms.' . $this->visforms->context, null);
							PluginHelper::importPlugin('visforms');
							// Add frontend web assets to edit link view
							$visformsAddWebAssetsEvent = new VisformsAddWebAssetsEvent('onVisformsAddWebAssets', [
								'context' => 'com_visforms.form.already_submitted_message',
								'fid' => $this->visforms->id
							]);
							$this->getDispatcher()->dispatch('onVisformsAddWebAssets', $visformsAddWebAssetsEvent);
							$this->prepareDocument();
							parent::display($tpl);
							return true;
						}
					}
				}
				$fields = $this->get('Fields');
				$successMessage = $app->getUserState('com_visforms.messages.' . $this->visforms->context, '');
				PluginHelper::importPlugin('content');
				$this->successMessage = (!empty($successMessage)) ? HTMLHelper::_('content.prepare', $successMessage) : $successMessage;
				$app->setUserState('com_visforms.messages.' . $this->visforms->context, null);
				$app->setUserState('com_visforms.' . $this->visforms->context, null);
				$this->visforms->fields = $fields;
				$this->steps = (!empty($this->visforms->steps)) ? (int) $this->visforms->steps : (int) 1;
				$this->visforms->parentFormId = 'visform' . $this->visforms->id;
				// Trigger onFormPrepare event
				PluginHelper::importPlugin('visforms');
				$formPrepareEvent = new VisformsFormPrepareEvent('onVisformsFormPrepare', [
					'subject' => $this->visforms,
					'context' => 'com_visforms.form',
					'menuparams' => $this->menu_params
				]);

				$this->getDispatcher()->dispatch('onVisformsFormPrepare', $formPrepareEvent);
				$this->formLink = "index.php?option=com_visforms&task=visforms.send&id=" . $this->visforms->id;
				$this->setFocus = ((!isset($this->visforms->setfocus)) || ((isset($this->visforms->setfocus)) && ($this->visforms->setfocus == 1))) ? true : false;
                // add layout specific css
				$this->setFormLayout($this->visforms);
                $oLayout = $this->getFormLayout();
				if (is_object($oLayout)) {
					$oLayout->addCss();
				}
				// empty page, if form is not published
				if ($this->visforms->published != '1') {
					return;
				}
				// empty page, if form is published down
				if ($isNotPublishedYet || $isExpired) {
					return;
				}
				// Add frontend web assets and all js to form view
				foreach ($this->visforms->fields as $field) {
					if (!empty($field->customJs) && is_array($field->customJs)) {
						$script = implode(' ', $field->customJs);
						$wa->addInlineScript($script);
					}
				}
				// Add frontend web assets to form and message view
				$visformsAddWebAssetsEvent = new VisformsAddWebAssetsEvent('onVisformsAddWebAssets', [
					'context' => 'com_visforms.form.form',
					'fid' => $this->visforms->id
				]);
				$this->getDispatcher()->dispatch('onVisformsAddWebAssets', $visformsAddWebAssetsEvent);
				break;
		}
		$this->prepareDocument();
		parent::display($tpl);
	}

	private function prepareDocument() {
		$app = Factory::getApplication();
		$title = '';
		if (isset($this->menu_params) && $this->menu_params->get('page_title')) {
			$title = $this->menu_params->get('page_title');
		}
		if ($app->get('sitename_pagetitles', 0) == 1) {
			$title = Text::sprintf('JPAGETITLE', $app->get('sitename'), $title);
		}
		elseif ($app->get('sitename_pagetitles', 0) == 2) {
			$title = Text::sprintf('JPAGETITLE', $title, $app->get('sitename'));
		}
		if ($title != '') {
			$this->getDocument()->setTitle($title);
		}
		// Set metadata Description and Keywords
		if (isset($this->menu_params) && $this->menu_params->get('menu-meta_description')) {
			$this->getDocument()->setDescription($this->menu_params->get('menu-meta_description'));
		}
		if (isset($this->menu_params) && $this->menu_params->get('menu-meta_keywords')) {
			$this->getDocument()->setMetadata('keywords', $this->menu_params->get('menu-meta_keywords'));
		}
	}
}