<?php
/**
 * Visformsdata view for Visforms
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6 
 */

namespace Visolutions\Component\Visforms\Site\View\Visformsdata;
 
// no direct access
defined('_JEXEC') or die( 'Restricted access' );

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\Registry\Registry;
use Visolutions\Component\Visforms\Site\Event\Visforms\VisformsAddWebAssetsEvent;
use Visolutions\Component\Visforms\Administrator\Helper\AefHelper;
use Visolutions\Component\Visforms\Administrator\Helper\VisformsHelper;

class HtmlView extends BaseHtmlView
{
	protected $visform;
	protected $items;
	protected $state;
	protected $menu_params;
	protected $fields;
	protected $itemid;
	protected $canDo;
	protected $counterOffest;
	protected $uniqueContext;
	protected $tmplQuery = '';
	protected $singleRecordPdfTmplDisplay = array();
    protected $singleRecordPdfTmplDisplay_list = array();
    protected $singleRecordPdfTmplDisplay_detail = array();
    protected $pdfTemplates;


	public function display($tpl = null) {
		$this->state = $this->get('State');
		//it is important to get the 'menu' params from the state because the params could be set by the plugin as well
		$this->menu_params = $this->state->get('params', new Registry);
		$this->visform = $this->get('Form');
		$app = Factory::getApplication();
		$isEditLayout = ($this->_layout == "detailedit" || $this->_layout == "dataeditlist") ? true : false;
        if ($tmpl = $app->getInput()->get('tmpl')) {
            $this->tmplQuery = '&tmpl='.$tmpl;
        }
        $webAssetContext = 'com_visforms.form.datas';
		if (empty($this->visform)) {
			$app->enqueueMessage(Text::_('COM_VISFORMS_DATAVIEW_FORM_MISSING'), 'error');
			return;
        }
        //visforms data views can be accessed without menu link. Allow visforms data views only if the form option is enabled
        //visforms data edit views can only be accessed if a menu item existes. The menu options control, which record sets can be viewed by a user
		if (empty($this->visform->allowfedv) && empty($isEditLayout)) {
            $app->enqueueMessage(Text::_('JERROR_ALERTNOAUTHOR'), 'error');
			return;
		}
         //check if user access level allows view
        $user = Factory::getApplication()->getIdentity();
		$groups = $user->getAuthorisedViewLevels();
        $access = (isset($this->visform->frontendaccess) && in_array($this->visform->frontendaccess, $groups)) ? true : false;
		if ($access == false) {
			$app->enqueueMessage(Text::_('JERROR_ALERTNOAUTHOR'), 'error');
			return;
		}
        $this->canDo = VisformsHelper::getActions($this->visform->id);
        // get params from menu
        $title = '';
		if (isset($this->menu_params) && $this->menu_params->get('page_title')) {
            $title = $this->menu_params->get('page_title') ;
        }
		if ($app->get('sitename_pagetitles', 0) == 1) {
            $title = Text::sprintf('JPAGETITLE', $app->get('sitename'), $title);
		} 
		elseif ($app->get('sitename_pagetitles', 0) == 2) {
            $title = Text::sprintf('JPAGETITLE', $title, $app->get('sitename'));
        }
        $this->getDocument()->setTitle($title);
		
		if ($this->menu_params['menu-meta_description']) {
			$this->getDocument()->setDescription($this->menu_params['menu-meta_description']);
		}

		if ($this->menu_params['menu-meta_keywords']) {
			$this->getDocument()->setMetadata('keywords', $this->menu_params['menu-meta_keywords']);
		}	
		// Menu item id of data view menu item
        $this->itemid = $this->state->get('itemid', '0');		
		// form id
		$this->id = Factory::getApplication()->getInput()->getInt('id', -1);

		// name of layout files for detail view must start with string detail
		if (str_starts_with($this->_layout, 'detail')) {
			// Get data from the model
			$this->item = $this->get('Detail');
            $webAssetContext = 'com_visforms.form.data';
		} 
		
		// Get data from the model
		$this->items = $this->get('Items');
        $this->pdfTemplates = $this->get('PdfTemplates');
        $this->filterForm    = $this->get('FilterForm');
		$this->activeFilters = $this->get('ActiveFilters');
		$this->pagination = $this->get('Pagination');	
		$this->fields = $this->get('Datafields');
		// if we have multiple data views on one page (using content plugin), we need unique identifiers for each view
        // in order make the javascript based features like pagination, filter etc. work for each data view individually
        // the class member $context, provide by the Joomla core, might be overridden in plugin events
        // therefore we have abandonded using it here and store our context value in this->uniqueContext for later use
        $this->uniqueContext = $this->get('Context');
        $this->counterOffest = $this->get('Start');
        $this->total = $this->get('Total');
        // foreach single record pdf template: provide an array with a list of all items for which the user can download this pdf (so it may be empty)
        if ((!empty($this->visform->singleRecordPdfTemplate)) && (!empty(AefHelper::checkAEF()))) {
            foreach ($this->visform->singleRecordPdfTemplate as $id) {
                $itemsWithPdf = array();
                $itemsWithPdf_list = array();
                $itemsWithPdf_detail = array();
                if (!empty($this->items)) {
                    $itemsWithPdf = array();
                    foreach ($this->items as $row) {
                        // can create pdf
                        if (($user->authorise('core.create.pdf', 'com_visforms.visform.' . (int) $this->visform->id . '.vispdf.' . (int) $id)) ||
                            (($user->authorise('core.create.own.pdf', 'com_visforms.visform.' . (int) $this->visform->id . '.vispdf.' . (int) $id)) && ($row->created_by === $user->id))) {
                            if (!empty($this->visform->displaypdfexportbutton_list)) {
                                $itemsWithPdf_list[] = $row->id;
                            }
                            // add parameter for detail view
                            // this can either be a detail view from a visforms data view menu item
                            // or d detail view for the content plugin data view
                            // which use different flags
                            if (!empty($this->visform->displaypdfexportbutton_detail)) {
                                // detail view from menu item
                                // only check the form option
                                if (empty($this->visform->isDetailFromPlg)) {
                                    $itemsWithPdf_detail[] = $row->id;
                                }
                                else {
                                    // detail view from content plugin
                                    // additionally check plugin parameter
                                    if (!empty($this->visform->displaypdfexportbutton_plg)) {
                                        $itemsWithPdf_detail[] = $row->id;
                                    }
                                }
                            }
                            $itemsWithPdf[] = $row->id;
                        };
                    }
                }
                // code currently only uses singleRecordPdfTmplDisplay_list and singleRecordPdfTmplDisplay_detail
                $this->singleRecordPdfTmplDisplay[$id] = $itemsWithPdf;
                $this->singleRecordPdfTmplDisplay_list[$id] = $itemsWithPdf_list;
                $this->singleRecordPdfTmplDisplay_detail[$id] = $itemsWithPdf_detail;
            }
        }
		HTMLHelper::_('visforms.includeScriptsOnlyOnce', array('visforms.min' => false, 'visdata.min' => true), array('validation' => false));
        // add form specific frontend web assets to data views
        PluginHelper::importPlugin('visforms');
        $visformsAddWebAssetsEvent = new VisformsAddWebAssetsEvent('onVisformsAddWebAssets', [
            'context' => $webAssetContext,
            'fid' => $this->visform->id
        ]);
        $this->getDispatcher()->dispatch('onVisformsAddWebAssets', $visformsAddWebAssetsEvent);
		parent::display($tpl);
		
	}
}