<?php
/**
 * Visformsdata detail view for Visforms
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */

//no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Uri\Uri;

$app = Factory::getApplication();
if (empty($this->item)) {
	$app->enqueueMessage(Text::_('COM_VISFORMS_FORM_DATA_RECORD_SET_MISSING'), 'error');
	return;
}
if (empty($this->item->published)) {
	$app->enqueueMessage(Text::_('JERROR_ALERTNOAUTHOR'), 'error');
	return;
}
$menuitems = $app->getMenu()->getItems('link', 'index.php?option=com_visforms&view=visformsdata&layout=data&id=' . $this->id);
$this->labelHtmlTag = 'td';
$this->valueHtmlTag = 'td';
$this->labelClass = 'vfdvlabel';
$this->valueClass = 'vfdvvalue';
$this->extension = 'component';
$this->viewType = 'row';
if (!empty($this->item->requiresJs)) {
	echo LayoutHelper::render('visforms.custom.noscript', array('text' => 'COM_VISFORMS_NOSCRIPT_ALERT_DATA'), JPATH_ROOT . '/components/com_visforms/layouts');
}
?>
<div class="visforms visforms-data visforms-data-data com-visforms <?php echo $this->menu_params->get('pageclass_sfx'); ?>"><?php
    if ($this->menu_params->get('show_page_heading') == 1) {
		if (!$this->menu_params->get('page_heading') == "") { ?>
            <h1><?php echo $this->menu_params->get('page_heading'); ?></h1><?php
		}
		else if (!empty($this->visform->frontdetailtitle)) {
			echo '<h1>' . $this->visform->frontdetailtitle . '</h1>';
		}
		else if (!empty($this->visform->fronttitle)) {
			echo '<h1>' . $this->visform->fronttitle . '</h1>';
		}
		else {
			echo '<h1>' . $this->visform->title . '</h1>';
		}
	}
	?>
    <form action="<?php echo Route::_('index.php?option=com_visforms&view=visformsdata&layout=data&id=' . $this->id); ?>"
          method="post" name="<?php echo $this->uniqueContext;?>adminForm" id="<?php echo $this->uniqueContext;?>adminForm" class="vfdv-task-form"><?php
        foreach ($menuitems as $item) {
            if (isset($item->id) && ($item->id == $this->itemid)) {
                $linkback = "index.php?option=com_visforms&view=visformsdata&layout=data&Itemid=" . $this->itemid . "&id=" . $this->id. $this->tmplQuery;
                echo '<a class="btn btn-outline-primary" href="' . Route::_($linkback) . '">';
                echo Text::_('COM_VISFORMS_BACK_TO_LIST');
                echo '</a> ';
                break;
            }
        }
        // listbox document download
    echo LayoutHelper::render('visforms.datas.actionbar.select-datadetail-download', array('recordId' => $this->item->id, 'detailTemplates' => $this->singleRecordPdfTmplDisplay_detail, 'pdfTemplates' => $this->pdfTemplates, 'form' => $this->visform), null, array('component' => 'com_visforms')); ?>
        <input type="hidden" name="task" value="visformsdata.renderPdf"/>
        <input type="hidden" name="tmplid" value="" />
        <input type="hidden" name="return" value="<?php echo HTMLHelper::_('visforms.base64_url_encode', Uri::getInstance()->toString()); ?>"/>
        <input type="hidden" name="cid[]" value="<?php echo $this->item->id; ?>"/>
        <?php echo HTMLHelper::_('form.token'); ?>
    </form>
<?php


	echo $this->loadTemplate('detailtable');
	?>
    <?php
    if ($this->visform->poweredby == '1') { ?>
        <div id="vispoweredby"><a href="https://vi-solutions.de" target="_blank" rel="noopener"><?php echo Text::_('COM_VISFORMS_POWERED_BY'); ?></a></div><?php
    } ?>
</div>