<?php
/**
 * @author       Aicha Vack
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2021 vi-solutions
 * @since        Joomla 1.6
 */

namespace Visolutions\Module\Visforms\Site\Helper;

// no direct access
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\Event\DispatcherInterface;
use Visolutions\Component\Visforms\Site\Lib\Layout\LayoutAwareTrait;
use Visolutions\Component\Visforms\Site\Model\VisformsModel;
use Visolutions\Component\Visforms\Site\Event\Visforms\VisformsFormPrepareEvent;
use Visolutions\Component\Visforms\Site\Event\Visforms\VisformsAddWebAssetsEvent;
use Visolutions\Component\Visforms\Administrator\Helper\AefHelper;
use Visolutions\Component\Visforms\Administrator\Helper\VisformsHelper as VisformsCompontentHelper;

class VisformsHelper
{
    use LayoutAwareTrait;
    private $params;
    private $visforms;
    private $fields;
    private $formLink;
    private $return;
    private $menu_params = array();
    private $index;
    private $url;
    private $context;
    private $editLinks;
    private $canDo;
    private $successMessage;
    private $userStateBackendFormParameter;
    private $previewOnly;
    private $isArticleContext = false;
    private $article;
    private $alreadySubmittedMessage;
    private $steps;
    private $setFocus;
    private bool $hasPhpError = false;
    // variables set in: plugins/content/vfformview/tmpl/default.php
    private $nbFields;
    private $required;
    private $upload;
    private $textareaRequired;
    private $hasHTMLEditor;
    private $firstControl;

    public function __construct($params) {
       $this->params = $params;
    }

    public function getForm() {
        $app = Factory::getApplication();
        $wa = $app->getDocument()->getWebAssetManager();
        $id = $this->params->get('catid', 0);
        $context = $this->params->get('context', '');
        // Get an instance of the generic visforms model
        $model = new VisformsModel(array('ignore_request' => true, 'id' => $id, 'context' => $context));
        $this->visforms = $model->getForm();
        if (empty($this->visforms)) {
            return $this->visforms;
        }
        // check if user access level allows view
        $user = Factory::getApplication()->getIdentity();
        $groups = $user->getAuthorisedViewLevels();
        $access = (isset($this->visforms->access) && in_array($this->visforms->access, $groups)) ? true : false;
        if ($access == false) {
            $app->setUserState('com_visforms.' . $this->visforms->context, null);
            // don't process fields if user cannot view form (avoid "nothing to setup javascript error of data fields)
            return $this->visforms;
        }
        $currentDate = Factory::getDate()->format('Y-m-d H:i:s');
        $isNotPublishedYet = $this->visforms->publish_up > $currentDate;
        $isExpired = !is_null($this->visforms->publish_down) && $this->visforms->publish_down < $currentDate;
        $this->canDo = VisformsCompontentHelper::getActions($this->visforms->id);
        $this->hasPhpError = (isset($this->visforms->errors) && is_array($this->visforms->errors) && count($this->visforms->errors) > 0);
        // option singlesubmission is set and a logged in user
        if (!empty($this->visforms->singlesubmission) && $user->id !== 0 && AefHelper::checkAEF()) {
            // check if we already have a submission for this user and this form
            $datas = $model->getRecords();
            $hasAlreadySubmitted = 0;
            if (!empty($datas)) {
                $hasAlreadySubmitted = 1;
            }
            if ($hasAlreadySubmitted === 1) {
                // ToDo Implement Support for redirect $this->visforms->redirecttoeditview == 2; Handle potential infinte redirects problem
                // if ((!empty($this->visforms->redirecttoeditview)) && (!empty($this->visforms->dataEditMenuExists)) && ($this->visforms->redirecttoeditview == 1 || $this->visforms->redirecttoeditview == 2)) {
                if ((!empty($this->visforms->redirecttoeditview)) && (!empty($this->visforms->dataEditMenuExists)) && ($this->visforms->redirecttoeditview == 1)) {
                    $this->editLinks = array();
                    // check if user can edit their own data
                    // get a list of the id's of all data already submitted by this user
                    if ($this->canDo->get('core.edit.own.data')) {
                        if (!empty($datas)) {
                            foreach ($datas as $data) {
                                if ((is_object($data)) && (!empty($data)) && !empty($data->id) && isset($data->published)) {
                                    if (!empty($data->published) || $this->canDo->get('core.edit.data.state') || $this->canDo->get('core.edit.own.data.state')) {
                                        if (!empty($this->visforms->rtev_link_text) && (!empty(trim($this->visforms->rtev_link_text)))) {
                                            $linkText = LayoutHelper::render('visforms.datas.replace', array('form' => $this->visforms, 'data' => $data, 'text' => $this->visforms->rtev_link_text), null, array('component' => 'com_visforms'));
                                        }
                                        else {
                                            $linkText = Text::_('COM_VISFORMS_EDIT_LINK_TEXT') . $data->id;
                                        }
                                        $this->editLinks[] = array((int)$data->id, $linkText);
                                    }
                                }
                            }
                        }
                    }
                    // display an edit link or redirect to edit view
                    if (!empty($this->editLinks)) {
                        if ($this->visforms->redirecttoeditview == 1) {
                            $app->setUserState('com_visforms.' . $this->visforms->context, null);
                            PluginHelper::importPlugin('visforms');
                            // Add frontend web assets to edit link view
                            $visformsAddWebAssetsEvent = new VisformsAddWebAssetsEvent('onVisformsAddWebAssets', [
                                'context' => 'com_visforms.form.edit_link',
                                'fid' => $this->visforms->id
                            ]);
                            Factory::getContainer()->get(DispatcherInterface::class)->dispatch('onVisformsAddWebAssets', $visformsAddWebAssetsEvent);
                            $this->params->set('editLinks', $this->editLinks);
                            $this->params->set('layout', 'editlink');
                            return $this->visforms;
                        }
                        // ToDo Implement Support for redirect $visforms->redirecttoeditview == 2; Handle potential infinte redirects problem
                        /* if ($this->visforms->redirecttoeditview == 2) {
                            // empty page, if form is not published
                            if ($this->visforms->published != '1') {
                                return $this->visforms;
                            }
                            // pick first id from $this->editlinks
                            // redirect to edit view of this record set
                            $app->setUserState('com_visforms.' . $this->visforms->context, null);
                            $recordId = $this->editLinks[0];
                            $redirectUri = '&return=' . HTMLHelper::_('visforms.base64_url_encode', 'index.php?Itemid=' . $visforms->dataEditMenuExists);
                            $link = Uri::base() . 'index.php?option=com_visforms&view=edit&layout=edit&task=edit.editdata&id=' . (int)$this->visforms->id . '&cid=' . (int)$recordId . $redirectUri . '&Itemid=' . $this->visforms->dataEditMenuExists;
                            $app->redirect($link, 200);
                        } */
                    }
                    // default to display message 'form can only be submitted once'
                    else {
                        $this->alreadySubmittedMessage = Text::_('COM_VISFORMS_FORM_WAS_ALREADY_SUBMITTED');
                        $app->setUserState('com_visforms.' . $this->visforms->context, null);
                        PluginHelper::importPlugin('visforms');
                        // Add frontend web assets to edit link view
                        $visformsAddWebAssetsEvent = new VisformsAddWebAssetsEvent('onVisformsAddWebAssets', [
                            'context' => 'com_visforms.form.already_submitted_message',
                            'fid' => $this->visforms->id
                        ]);
                        Factory::getContainer()->get(DispatcherInterface::class)->dispatch('onVisformsAddWebAssets', $visformsAddWebAssetsEvent);
                        $this->params->set('alreadySubmittedMessage', $this->alreadySubmittedMessage);
                        $this->params->set('layout', 'alreadysubmittedmessage');
                        return $this->visforms;
                    }
                }
                // display message 'form can only be submitted once'
                else {
                    $this->alreadySubmittedMessage = Text::_('COM_VISFORMS_FORM_WAS_ALREADY_SUBMITTED');
                    $app->setUserState('com_visforms.' . $this->visforms->context, null);
                    PluginHelper::importPlugin('visforms');
                    // Add frontend web assets to edit link view
                    $visformsAddWebAssetsEvent = new VisformsAddWebAssetsEvent('onVisformsAddWebAssets', [
                        'context' => 'com_visforms.form.already_submitted_message',
                        'fid' => $this->visforms->id
                    ]);
                    Factory::getContainer()->get(DispatcherInterface::class)->dispatch('onVisformsAddWebAssets', $visformsAddWebAssetsEvent);
                    $this->params->set('alreadySubmittedMessage', $this->alreadySubmittedMessage);
                    $this->params->set('layout', 'alreadysubmittedmessage');
                    return $this->visforms;
                }
            }
        }
        $this->fields = $model->getFields();
        $this->successMessage = $app->getUserState('com_visforms.messages.' . $this->visforms->context, '');
        PluginHelper::importPlugin('content');
        $this->successMessage = (!empty($this->successMessage)) ? HTMLHelper::_('content.prepare', $this->successMessage) : $this->successMessage;
        $app->setUserState('com_visforms.messages.' . $this->visforms->context, null);
        $app->setUserState('com_visforms.' . $this->visforms->context . '.fields', null);
        $app->setUserState('com_visforms.' . $this->visforms->context, null);
        $this->visforms->fields = $this->fields;
        $this->visforms->parentFormId = 'mod-visform' . $this->visforms->id;
        //Trigger onFormPrepare event
        PluginHelper::importPlugin('visforms');
        $formPrepareEvent = new VisformsFormPrepareEvent('onVisformsFormPrepare', [
            'subject' => $this->visforms,
            'context' => 'mod_visforms.form',
            'menuparams' => $this->params
        ]);
        Factory::getContainer()->get(DispatcherInterface::class)->dispatch('onVisformsFormPrepare', $formPrepareEvent);
        // empty page, if form is not published
        if ($this->visforms->published != '1') {
            return $this->visforms;
        }
        // empty page, if form is published down
        if ($isNotPublishedYet || $isExpired) {
            return $this->visforms;
        }
        // Add frontend web assets and all js to form view
        foreach ($this->visforms->fields as $field) {
            if (!empty($field->customJs) && is_array($field->customJs)) {
                $script = implode(' ', $field->customJs);
                $wa->addInlineScript($script);
            }
        }
        // Add frontend web assets to form view
        $visformsAddWebAssetsEvent = new VisformsAddWebAssetsEvent('onVisformsAddWebAssets', [
            'context' => 'com_visforms.form.form',
            'fid' => $this->visforms->id
        ]);
        Factory::getContainer()->get(DispatcherInterface::class)->dispatch('onVisformsAddWebAssets', $visformsAddWebAssetsEvent);
        $this->nbFields = count($this->visforms->fields);
        // get some infos to look whether it's neccessary to add Javascript or special HTML-Code or not
        // variables are set to true if they are true for at least one field
        $this->required = false;
        $this->upload = false;
        $this->textareaRequired = false;
        $this->hasHTMLEditor = false;
        //helper, used to set focus on first visible field default is no focus
        $this->firstControl = true;
        $this->setFocus = (!empty($this->visforms->setfocus)) ? true : false;
        $this->steps = (!empty($this->visforms->steps)) ? (int) $this->visforms->steps : (int) 1;
        for ($i = 0; $i < $this->nbFields; $i++) {
            $field = $this->visforms->fields[$i];
            // set the controll variables
            if (isset($field->attribute_required) && ($field->attribute_required == "required")) {
                $this->required = true;
            }
            if (isset($field->typefield) && $field->typefield == "file") {
                $this->upload = true;
            }
            if (isset($field->textareaRequired) && $field->textareaRequired === true) {
                // we have some work to do to use Javascript to validate that the textarea has content
                $this->textareaRequired = true;
            }
            if (isset($field->hasHTMLEditor) && $field->hasHTMLEditor == true) {
                $this->hasHTMLEditor = true;
            }
        }

        // push helper variables into params
        $this->params->set('nbFields', $this->nbFields);
        $this->params->set('required', $this->required);
        $this->params->set('upload', $this->upload);
        $this->params->set('textareaRequired', $this->textareaRequired);
        $this->params->set('hasHTMLEditor', $this->hasHTMLEditor);
        $this->params->set('firstControl', $this->firstControl);
        $this->params->set('setFocus', $this->setFocus);
        $this->params->set('steps', $this->steps);
        $this->params->set('successMessage', $this->successMessage);
        $this->params->set('hasPhpError', $this->hasPhpError);
        //add layout specific css
        $this->setFormLayout($this->visforms);
        $oLayout = $this->getFormLayout();
        if (is_object($oLayout)) {
            $oLayout->addCss();
        }
        return $this->visforms;
    }

	public function getParams() {
        return $this->params;
    }
}