<?php
/**
 * Itemlist controller for Visforms
 * @author       Aicha Vack
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */

namespace Visolutions\Component\Visforms\Administrator\Controller;

defined('_JEXEC') or die( 'Restricted access' );

use Joomla\CMS\Application\CMSApplicationInterface;
use Joomla\CMS\Factory;
use Joomla\CMS\Form\FormFactoryInterface;
use Joomla\CMS\MVC\Controller\FormController;
use Joomla\CMS\MVC\Factory\MVCFactoryInterface;
use Joomla\CMS\Session\Session;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Table\Extension;
use Joomla\Database\DatabaseInterface;
use Joomla\Input\Input;
use Visolutions\Component\Visforms\Administrator\Helper\SqlHelper;

class ItemControllerBase extends FormController
{
	protected $app;
	public function __construct($config = array(), ?MVCFactoryInterface $factory = null, ?CMSApplicationInterface $app = null, ?Input $input = null, ?FormFactoryInterface $formFactory = null) {
		parent::__construct($config, $factory, $app, $input);
		$this->app = Factory::getApplication();
		$this->registerTask('testSqlStatementSingleResult', 'testSqlStatement');
		// stored for later use
		// $this->registerTask('showStepBadges', 'hideStepBadges');
	}

	public function testSqlStatement() {
		$data = $this->getAjaxRequestData();
		// test sql with a single result or with an array of results?
		$task = $this->input->getCmd('task', 'testSqlStatement');
		$queryFunction = ($task === 'testSqlStatementSingleResult') ? 'loadResult' : 'loadObjectList';
		if (!$this->checkAjaxSessionToken()) {
			$count = null;
			$message = Text::_("COM_VISFORMS_AJAX_INVALID_TOKEN");
			$result = false;
		}
		else if (!$this->app->getIdentity()->authorise('core.create.sql.statement', 'com_visforms')) {
			$count = null;
			$message = Text::_("COM_VISFORMS_CREATE_SQL_ACL_MISSING");
			$result = false;
		}
		else {
			$sql = json_decode(json_encode($data->statement), true);
			$count = 0;
			try {
				$sqlHelper = new SqlHelper($sql);
				$items = $sqlHelper->getItemsFromSQL($queryFunction);
				if ('loadResult' == $queryFunction) {
					$message = 'success: found 1 entry';
				}
				else {
					$count = count($items);
					$message = 'success: found ' . $count . ' entries';
				}
				$result = true;
			}
			catch (\Exception $e) {
				$message = $e->getMessage();
				$result = false;
			}
		}

		// return data
		// clean php notices and warnings from output buffer
		ob_clean();
		$response = array("success" => true, 'count' => $count, 'message' => $message, 'result' => $result);
		$document = $this->app->getDocument();
		$document->setMimeEncoding('application/json');
		echo json_encode($response);
		$this->app->close();
	}

	protected function getAjaxRequestData() {
		// get the data
		$input = $this->app->getInput();
		$json = $input->get('data', '', 'raw');
		$data = json_decode($json);
		return $data;
	}

	protected function checkAjaxSessionToken() {
		$data = $this->getAjaxRequestData();
		$token = Session::getFormToken();
		if ((!isset($data->$token)) || !((int) $data->$token === 1)) {
			return false;
		}
		return true;
	}

    public function saveAjaxTextarea() {
	    if (!Session::checkToken()) {
            $message = Text::_("COM_VISFORMS_AJAX_INVALID_TOKEN");
            $success = false;
        }
        else {
            $model = $this->getModel();
            try {
                $model->saveAjaxTextareaInDatabase();
                $message = Text::_('COM_VISFORMS_AJAX_SUBMIT_SUCCESS_MESSAGE');
                $success = true;
            }
            catch (\RuntimeException $e) {
                $message = $e->getMessage();
                $success = false;
            }
        }
        ob_clean();
        $response = array("success" => $success, 'message' => $message, 'result' => true);
        $document = $this->app->getDocument();
        $document->setMimeEncoding('application/json');
        echo json_encode($response);
        $this->app->close();
    }

	// stored for later use
	/*public function hideStepBadges() {
		if ('hideStepBadges' === $this->getTask()) {
			$this->storeParam('hideStepBadges', 1);
		}
		else {
			$this->storeParam('hideStepBadges', 0);
		}
		$this->setRedirect(Route::_('index.php?option=com_visforms&view=visfields' . $this->getRedirectToListAppend(), false));
	}*/

	/*protected function storeParam($name, $value) {
	    $db = Factory::getContainer()->get(DatabaseInterface::class);
		$component = ComponentHelper::getComponent('com_visforms');
		$component->params->set($name, $value);
		$componentId = $component->id;
		$table = new Extension($db);
		$table->load($componentId);
		$table->bind(array('params' => $component->params->toString()));
		if (!$table->check()) {
			Factory::getApplication()->enqueueMessage('Invalid params', 'error');
			return false;
		}
		if (!$table->store()) {
			Factory::getApplication()->enqueueMessage('Problems saving params', 'error');
			return false;
		}
		return true;
	}*/
}