<?php
/**
 * Visform field parentoptionslist
 *
 * @author       Aicha Vack
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */
namespace Visolutions\Component\Visforms\Administrator\Field;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Form\Field\ListField;
use Visolutions\Component\Visforms\Administrator\Model\VisformModel;

class FieldgridwidthField extends ListField
{
	protected $type = 'FieldGridWidth';

	protected function getOptions() {
		$options = array();
		//extract form id
		$fid = Factory::getApplication(array('ignore_request' => true))->getInput()->getInt('fid', 0);
		$model = new VisformModel();
		$visform = $model->getItem($fid);
		$layout = $visform->layoutsettings['formlayout'];
        if ($layout == 'bt5') {
            // num 1, 2, 3, 4, 6, 12 are old values which represent fields per row i.e 4 translates into col-3
            // num 11, 10, 9, 8, 7, 5 are new values which represent direct grid width i.E. 11 translates into col-11
            $options[] = $this->createOptionObj(1,12,12);
            $options[] = $this->createOptionObj(11,11,12);
            $options[] = $this->createOptionObj(10,10,12);
            $options[] = $this->createOptionObj(9,9,12);
            $options[] = $this->createOptionObj(8,8,12);
            $options[] = $this->createOptionObj(7,7,12);
            $options[] = $this->createOptionObj(2,6, 12);
            $options[] = $this->createOptionObj(5,5,12);
            $options[] = $this->createOptionObj(3, 4, 12);
            $options[] = $this->createOptionObj(4, 3, 12);
            $options[] = $this->createOptionObj(6, 2, 12);
            $options[] = $this->createOptionObj(12,1, 12);
        }
		if ($layout == 'uikit3') {
			$options[] = $this->createOptionObj(1, 6,6);
			$options[] = $this->createOptionObj(2, 3, 6);
			$options[] = $this->createOptionObj(3, 2, 6);
			$options[] = $this->createOptionObj(6, 1, 6);
		}
		// Merge any additional options in the XML definition.
		$options = array_merge(parent::getOptions(), $options);
		return $options;
	}

	private function createOptionObj($num, $fraction, $max) {
		$o = new \StdClass();
		$o->value = $num;
		$o->text = $fraction . ' / ' . $max . ' '. Text::_('COM_VISFORMS_OF_LINE_WIDTH');
		$o->disabled = false;
		$o->checked = false;
		$o->selected = false;
		return $o;
	}
}
