<?php
/**
 * Visform field parentoptionslist
 *
 * @author       Aicha Vack
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */
namespace Visolutions\Component\Visforms\Administrator\Field;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Form\Field\ListField;
use Joomla\Database\DatabaseInterface;
use Visolutions\Component\Visforms\Administrator\Helper\VisformsHelper;

class ReloadtriggerfieldsField extends ListField
{
	protected $type = 'ReloadTriggerFields';
	protected $isRestricted = array();
	protected $dbFields = array();

	protected function getOptions() {
		$options = array();
		$dbFields = $this->getFieldList();
		if (!empty($dbFields)) {
			foreach ($dbFields as $field) {
				$options[] = $this->createOptionObj($field);
			}
		}
		// Merge any additional options in the XML definition.
		$options = array_merge(parent::getOptions(), $options);
		return $options;
	}

	private function createOptionObj($field) {
		$o = new \StdClass();
		$o->value = 'field'.$field->id;
		$o->text = $field->label;
		$o->disabled = false;
		$o->checked = false;
		$o->selected = false;
		return $o;
	}

	protected function getFieldList() {
		$form = $this->form;
		$fid = $form->getValue('fid', '', 0);
		$id = $form->getValue('id', '', 0);
		if (empty($fid) || empty($id)) {
			return false;
		}
		$db = Factory::getContainer()->get(DatabaseInterface::class);
		$query = $db->createQuery();
		$query->select($db->qn(array('id', 'typefield', 'label', 'restrictions', 'defaultvalue')))
			->from($db->qn('#__visfields'))
            // allow all field types, except
            ->where($db->qn('fid') . ' = ' . $fid . ' AND' . $db->qn('published') . ' = 1' . ' AND ' . $db->qn('typefield') . 'NOT IN  (' . $db->quote('file') . ', ' . $db->quote('location') . ', ' . $db->quote('signature') . ', ' . $db->quote('submit')  . ', ' . $db->quote('reset')  . ', ' . $db->quote('image')  . ', ' . $db->quote('fieldsep') . ', ' . $db->quote('pagebreak') . ')' .
				' AND NOT ' . $db->qn('editonlyfield') . ' = 1')
			->order($db->qn('label') . ' ASC');
		try {
			$db->setQuery($query);
			$this->dbFields =  $db->loadObjectList();
		}
		catch (\RuntimeException $e) {
			return false;
		}
		if (!empty($this->dbFields)) {
			// select sql with 'Render as data list' enabled
            $this->removeFieldsWithIncompatibleOption('f_selectsql_render_as_datalist');
            // textarea with 'HTML Editor' enabled
			$this->removeFieldsWithIncompatibleOption('f_textarea_HTMLEditor');
			$this->getRestrictedIds($id);
		}
		$allowedFields = array();
		foreach ($this->dbFields as $dbField) {
			if (!(in_array($dbField->id, $this->isRestricted))) {
				$allowedFields[] = $dbField;
			}
		}
		return $allowedFields;
	}

	private function getRestrictedIds($id) {
		// add id to list with restsricted id's.
		// on first call: don't show ourselfs in option list
		$this->isRestricted[] = $id;

		foreach ($this->dbFields as $field) {
			if ($field->id == $id) {
				// extract db field restrictions
				$restrictions = VisformsHelper::registryArrayFromString($field->restrictions);
				// as we allow to use select sql in calculation:
                // Prevent Circular processes:
                // Remove all calucalation fields in which the select sql field is used
				if (isset($restrictions['usedInCal'])) {
                    if (is_array($restrictions['usedInCal'])) {
                        foreach ($restrictions['usedInCal'] as $name => $key) {
                            $this->isRestricted[] = $key;
                        }
                    }
                }

				if (!isset($restrictions['usedAsReloadTrigger'])) {
					return;
				}

				// when we have a usedAsReloadTrigger item, call ourself with the id retrieved from $value
				foreach ($restrictions['usedAsReloadTrigger'] as $key => $value) {
					$this->getRestrictedIds($value);
				}
			}
		}
	}

	// some field types may have options in default, which makes it impossible to use them as trigger fields
	private function removeFieldsWithIncompatibleOption($optionName) {
        if (empty($this->dbFields)) {
            return;
        }
        $count = count($this->dbFields);
        for ($i=0; $i < $count; $i++) {
            $defaultValues = VisformsHelper::registryArrayFromString($this->dbFields[$i]->defaultvalue);
            if (!empty($defaultValues[$optionName])) {
                unset($this->dbFields[$i]);
            }
        }
        $this->dbFields = array_values($this->dbFields);
    }
}