<?php

/**
 * Visform field SQLTextarea
 *
 * @author       Ingmar Vack
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2025 vi-solutions
 * @since        Joomla 5.3.1
 */

namespace Visolutions\Component\Visforms\Administrator\Field;

use Joomla\CMS\Form\Field\TextareaField;
use Joomla\CMS\Layout\FileLayout;
use Joomla\CMS\Session\Session;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Factory;

defined('_JEXEC') or die;

class SQLTextareaField extends TextareaField  {
    protected $type = 'SQLTextarea';
	protected $supportedTasks = array(
		'visAdmin.visField.testSqlStatement',
		'visPDF.testSqlData',
		'visPDF.testSqlStatement'
);

    protected function getInput(): string {
		// textarea field for sql statements is used in different views
	    // field, form, pdf
	    // form and field views use the admin/visforms.js
	    // pdf view currently only use inline js, added in the tmpl files (edit.php in the tmpl folder)
	    // all views use the layout file 'div.sql_test_controls' to render the textarea plus test button
	    // in pdf view, different sql fields use different JS click handler functions (secondary sql statements vs. data select sql statements)
	    // test sql button click handler is set in JS Code using data attributes
	    // make sure all necessary data attributes are set
	    if (!isset($this->dataAttributes)) {
		    $this->dataAttributes = array();
	    }

		// user has permission to create a sql statement
		if (Factory::getApplication()->getIdentity()->authorise('core.create.sql.statement', 'com_visforms')) {
			// currently only used in tmpl/visPDF/edit
			if (!isset($this->dataAttributes['data-js-task'])) {
				$this->dataAttributes['data-js-task'] = 'visAdmin.visField.testSqlStatement';
			}
			// currently only used if admin/visforms.js is loaded in view (form and field)
			// therefore set to visfield.testSqlStatement
			if (!isset($this->dataAttributes['data-php-task'])) {
				$this->dataAttributes['data-php-task'] = 'visfield.testSqlStatement';
			}
			$this->dataAttributes['data-token'] = Session::getFormToken();
			if (!isset($this->dataAttributes['data-empty-message'])) {
				$this->dataAttributes['data-empty-message'] = Text::_('COM_VISFORMS_EMPTY_SQL_STATEMENT', true);
			}
		}

		// user has no permission to create a sql statement
		// do not add click handler to button
		// disable textarea
		else {
			unset($this->dataAttributes['data-js-task']);
			unset($this->dataAttributes['data-php-task']);
			unset($this->dataAttributes['data-token']);
			unset($this->dataAttributes['data-empty-message']);
			$this->disabled = true;
		}

        // render the custom field
        return (new FileLayout('div.sql_test_controls'))->render(array('input' => parent::getInput()));
    }
}