<?php
/**
 * @author       Aicha Vack
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2021 vi-solutions
 * @since        Joomla 1.6
 */
namespace Visolutions\Component\Visforms\Administrator\Field;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Form\Field\ListField;
use Visolutions\Component\Visforms\Administrator\Model\VisdatasModel;

/**
 * Form Field class for the Joomla Framework.
 *
 * @package		Joomla.Administrator
 * @subpackage	com_categories
 * @since		1.6
 */
class SignatureApiField extends ListField
{
	public $type = 'SignatureApi';

	protected function getInput() {
        // get field defaultvalues
        $model = new VisdatasModel();
        $datas = $model->getItems();
        $id = Factory::getApplication()->getInput()->getInt('id', 0);
        // as soon as user inputs are stored we show an alert
        if ((isset($datas)) && is_array($datas) && (count($datas) > 0)) {
            $fname = 'F'.$id;
            foreach ($datas as $data) {
                if (isset($data->$fname) && ($data->$fname != '')) {
                    $this->dataAttributes['data-protected-value'] = $this->value;
                    $this->onchange = 'if (!confirm(\''.Text::sprintf(("COM_VISFORMS_SINGNATURE_API_CHANGE_WARNING"), array('jsSafe' => true)).'\')) 
                    {event.stopImmediatePropagation(); this.value = this.getAttribute(\'data-protected-value\'); return false;} else {this.setAttribute(\'data-protected-value\', this.value)}';
                    break;
                }
            }
        }

		$data = $this->getLayoutData();
		$data['options'] = (array) $this->getOptions();
		return $this->getRenderer($this->layout)->render($data);
	}

	protected function getOptions() {
		// Initialise variables.
		$options = array();
		// Merge any additional options in the XML definition.
		$options = array_merge(parent::getOptions(), $options);

		return $options;
	}
}
