<?php
/**
 * @author       Aicha Vack
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 *
 */

namespace Visolutions\Component\Visforms\Administrator\Helper;

defined('_JEXEC') or die;

use Joomla\Filesystem\Path;

class AefHelper
{
    public static function checkAEF() {
        // return false;
        return (self::featureExists(JPATH_ROOT . '/administrator/manifests/packages/pkg_vfsubscription.xml'));
    }

    protected static function featureExists($file) {
        if (!(file_exists(Path::clean($file)))) {
            return false;
        }
        else {
            return true;
        }
    }

    public static function getVersion() {
        return self::extractVersionFromXMLFile(JPATH_ROOT . '/administrator/manifests/packages/pkg_vfsubscription.xml');
    }

    protected static function extractVersionFromXMLFile($file) {
        if (!(file_exists(Path::clean($file)))) {
            return false;
        }
        else {
            // suppress warnings
            libxml_use_internal_errors(true);
            $xml = simplexml_load_file($file);
            if ($xml === false) {
                return false;
            }
            return $xml->version;
        }
    }
}
