<?php
/**
 * @author       Aicha Vack
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */
namespace Visolutions\Component\Visforms\Administrator\Helper;
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\Filesystem\File;
use Joomla\Filesystem\Path;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Access\Access;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\Registry\Registry;
use Joomla\Database\DatabaseInterface;

class VisformsHelper
{
	public static $extension = 'com_visforms';

	public static function addSubmenu() {
	    // make sure, visforms plugins are loaded
        // so that the 'onPreprocessMenuItems' event handled
        PluginHelper::importPlugin('visforms');
	}

	// ToDo: basically Joomla does not use this function anymore, why?
	public static function getActions($formId = 0, $objectId = 0, $object = 'visfield') {
		$user = Factory::getApplication()->getIdentity();
		$result = new Registry(null, '');
		if (empty($formId) && empty($objectId)) {
			$assetName = 'com_visforms';
		}
		else if (empty($objectId)) {
			$assetName = 'com_visforms.visform.' . (int) $formId;
		}
		else {
			$assetName = 'com_visforms.visform.' . (int) $formId . '.'.$object.'.' . (int) $objectId;
		}
		$actions = Access::getActionsFromFile(Path::clean(JPATH_ADMINISTRATOR . '/components/com_visforms/access.xml'), "/access/section[@name='component']/");
		foreach ($actions as $action) {
			$result->set($action->name, $user->authorise($action->name, $assetName));
		}
		return $result;
	}

	/**
	 * Checks if the file can be uploaded
	 *
	 * @param array  $file File information
	 * @param string $err  An error message to be returned
	 *
	 * @return  boolean
	 *
	 * @since   3.2
	 */
	public static function canUpload($file, $allowedExtensions = "") {
		if (empty($file['name'])) {
			$app = Factory::getApplication();
			$app->enqueueMessage(Text::_('COM_VISFORMS_ERROR_UPLOAD_INPUT'), 'error');
			return false;
		}
		// Media file names should never have executable extensions buried in them.
		$executable = array(
			'exe', 'phtml', 'java', 'perl', 'py', 'asp', 'dll', 'go', 'jar',
			'ade', 'adp', 'bat', 'chm', 'cmd', 'com', 'cpl', 'hta', 'ins', 'isp',
			'jse', 'lib', 'mde', 'msc', 'msp', 'mst', 'pif', 'scr', 'sct', 'shb',
			'sys', 'vb', 'vbe', 'vbs', 'vxd', 'wsc', 'wsf', 'wsh'
		);
		$explodedFileName = explode('.', $file['name']);
		if (count($explodedFileName) > 2) {
			foreach ($executable as $extensionName) {
				if (in_array($extensionName, $explodedFileName)) {
					$app = Factory::getApplication();
					$app->enqueueMessage(Text::_('COM_VISFORMS_ERROR_EXECUTABLE'), 'error');
					return false;
				}
			}
		}
		if ($file['name'] !== File::makeSafe($file['name']) || preg_match('/\s/', File::makeSafe($file['name']))) {
			$app = Factory::getApplication();
			$app->enqueueMessage(Text::_('COM_VISFORMS_ERROR_WARNFILENAME'), 'error');
			return false;
		}
		$format = strtolower(File::getExt($file['name']));
		$allowable = array($allowedExtensions);
		if ($format == '' || $format == false || (!in_array($format, $allowable))) {
			$app = Factory::getApplication();
			$app->enqueueMessage(Text::_('COM_VISFORMS_ERROR_WARNFILETYPE'), 'error');
			return false;
		}
		// Max upload size set to 2 MB for Template Manager
		$maxSize = (int) (2 * 1024 * 1024);
		if ($maxSize > 0 && (int) $file['size'] > $maxSize) {
			$app = Factory::getApplication();
			$app->enqueueMessage(Text::_('COM_VISFORMS_ERROR_WARNFILETOOLARGE'), 'error');
			return false;
		}
		$xss_check = file_get_contents($file['tmp_name'], false, null, -1, 256);
		$html_tags = array(
			'abbr', 'acronym', 'address', 'applet', 'area', 'audioscope', 'base', 'basefont', 'bdo', 'bgsound', 'big', 'blackface', 'blink', 'blockquote',
			'body', 'bq', 'br', 'button', 'caption', 'center', 'cite', 'code', 'col', 'colgroup', 'comment', 'custom', 'dd', 'del', 'dfn', 'dir', 'div',
			'dl', 'dt', 'em', 'embed', 'fieldset', 'fn', 'font', 'form', 'frame', 'frameset', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'head', 'hr', 'html',
			'iframe', 'ilayer', 'img', 'input', 'ins', 'isindex', 'keygen', 'kbd', 'label', 'layer', 'legend', 'li', 'limittext', 'link', 'listing',
			'map', 'marquee', 'menu', 'meta', 'multicol', 'nobr', 'noembed', 'noframes', 'noscript', 'nosmartquotes', 'object', 'ol', 'optgroup', 'option',
			'param', 'plaintext', 'pre', 'rt', 'ruby', 's', 'samp', 'script', 'select', 'server', 'shadow', 'sidebar', 'small', 'spacer', 'span', 'strike',
			'strong', 'style', 'sub', 'sup', 'table', 'tbody', 'td', 'textarea', 'tfoot', 'th', 'thead', 'title', 'tr', 'tt', 'ul', 'var', 'wbr', 'xml',
			'xmp', '!DOCTYPE', '!--'
		);
		foreach ($html_tags as $tag) {
			// a tag is '<tagname ', so we need to add < and a space or '<tagname>'
			if (stristr($xss_check, '<' . $tag . ' ') || stristr($xss_check, '<' . $tag . '>')) {
				$app = Factory::getApplication();
				$app->enqueueMessage(Text::_('COM_VISFORMS_ERROR_WARNIEXSS'), 'error');
				return false;
			}
		}
		return true;
	}

	public static function addCommonViewStyleCss() {
		$wa = Factory::getApplication()->getDocument()->getWebAssetManager();
		$css =
			' .icon-visform {background:url(../administrator/components/com_visforms/images/visforms_logo_32.png) no-repeat;}' .
			' [class^="icon-visform"] {height: 32px !important; line-height: 32px !important; width: 32px !important; vertical-align: middle;} .control-group.field-spacer .control-label {width: 100%;}';
		$wa->addInlineStyle($css);
		$wa->registerAndUseStyle('visforms.admin.visforms',  'administrator/components/com_visforms/css/visforms.css');
	}

	public static function addCommonVisformsJS() {
		$wa = Factory::getApplication()->getDocument()->getWebAssetManager();
		$wa->registerAndUseScript('com_visforms.admin.visforms', 'administrator/components/com_visforms/js/visforms.js', [], ['defer' => true]);
	}

	// registry helper functions
	public static function registryArrayFromString($settings = '') {
		if (empty($settings)) {
			return array();
		}
		try {
			$registry = new Registry;
			$registry->loadString($settings);
			return $registry->toArray();
		}
		catch (\RuntimeException $e) {
			return array();
		}
	}

	public static function registryStringFromArray($values = array()) {
		if (is_string($values)) {
			return $values;
		}
		try {
			$registry = new Registry;
			$registry->loadArray($values);
			return (string) $registry;
		}
		catch (\RuntimeException $e) {
			return '';
		}
	}

	public static function registryObjectFromString($settings = '') {
		if (empty($settings)) {
			return new \stdClass;
		}
		try {
			$registry = new Registry;
			$registry->loadString($settings);
			return $registry->toObject();
		}
		catch (\RuntimeException $e) {
			return new \stdClass;
		}
	}

	// form title functions
	public static function showTitleWithPreFix($title) {
		if (!empty($title)) {
			$title = ' - ' . $title;
		}
		ToolbarHelper::title(Text::_('COM_VISFORMS') . $title, 'visform');
	}

	public static function appendTitleAppendixFormat($text) {
		return ' <small><small>[ ' . $text . ' ]</small></small>';
	}

	public static function getFormattedServerDateTime($value, $format = 'Y-m-d H:i:s') {
		if ($value && $value !== Factory::getContainer()->get(DatabaseInterface::class)->getNullDate()) {
			$date = Factory::getDate($value, 'UTC');
			$date->setTimezone(new \DateTimeZone(Factory::getApplication()->getConfig()->get('offset')));
			$value = $date->format($format, true, false);
		}
		return $value;
	}

	public static function checkValueIsEmpty($test, $type, $checkForEmptyCal = false) {
		switch ($type) {
			case 'calculation' :
				if ($checkForEmptyCal) {
					return self::checkNumberValueIsZero($test);
				}
				else {
					return false;
				}
			case 'location' :
				return self::checkLocationValueIsEmpty($test);
			default:
				return empty($test);
		}
	}

	public static function checkNumberValueIsZero($test) {
		if (is_null($test)) {
			return false;
		}
		$number = str_replace(",", ".", $test);
		$isZero = (0 == $number) ? true : false;
		return $isZero;
	}

	public static function checkLocationValueIsEmpty($test) {
		if (empty($test)) {
			return true;
		}
		if (($test['lat'] === '') || ($test['lng'] === '')) {
			return true;
		}
		return false;
	}

	public static function getDataLogFilename($formid) {
		$logPath = 'visforms_datalogs';
		return $logPath . '/form_' . $formid . '.php';
	}

    // Single Select Option is stored as string in database
    // Multiselect Option is stored as array in database
    // Convert old stored string values into array before use
    public static function fixInvalidMultiSelectOption($value, $checkAEF = true) {
	    if ($checkAEF && (empty(AefHelper::checkAEF()))) {
	        return array();
        }
        if (!empty($value)) {
            if (!is_array($value)) {
                $value = array($value);
            }
        }
        else {
            $value = array();
        }
        return $value;
    }
    public static function getPdfDownlaodLinkTitle($pdfTmptId, $pdfTemplates) {
        $name = Text::_('COM_VISFORMS_DOWNLOAD_PDF');
        if (!empty($pdfTemplates)) {
            foreach ($pdfTemplates as $pdfTemplate) {
                if ($pdfTemplate->id === (int) $pdfTmptId && !empty(trim($pdfTemplate->title))) {
                    $name = trim($pdfTemplate->title);
                    break;
                }
            }
        }
        return $name;
    }

	public static function checkPdfTmplIdValid($pdfTmplId): bool {
		// without subscription there is no Vispdf Table!
		try {
			$pdfTable = new \Visolutions\Component\Visforms\Administrator\Table\VispdfTable(Factory::getContainer()->get(DatabaseInterface::class));
		}
		catch (\RuntimeException $e) {
			return false;
		}
		$loaded = $pdfTable->load((int) $pdfTmplId);
		if ($loaded === false) {
			return false;
		}
		if (!$pdfTable->published) {
			return false;
		}
		return true;
	}

	public static function getJoomlaCacheSettings() {
		$globalCaching = !empty(Factory::getApplication()->getConfig()->get('caching'));
		$pageCache = (PluginHelper::isEnabled('system', 'cache'));
		return array('globalCaching' => $globalCaching, 'pageCache' => $pageCache);
	}
}