<?php
/**
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2018 vi-solutions
 */

namespace Visolutions\Component\Visforms\Administrator\Service\HTML;

// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\Filesystem\Folder;
use Joomla\Filesystem\Exception\FilesystemException;
use Visolutions\Component\Visforms\Administrator\Helper\SignatureToolsBase30;

class Signature
{
	public static $sigImgPath = '/images/visforms/sigtmp';

	// get img src as file name
	public static function createPngFile($base30Data, $canvasWidth = 280, $canvasHeight = 120) {
		if (empty($base30Data)) {
			return '';
		}
		if (!(str_starts_with($base30Data, 'image/jsignature;base30'))) {
		    return '';
        }
		$xyArray = self::convertBase30ToxyArray($base30Data);
		if (empty($xyArray)) {
			return '';
		}
		$im = self::getBinaryImg($xyArray, $canvasWidth, $canvasHeight);
		$path = JPATH_ROOT . self::$sigImgPath;
		try {
            Folder::create($path);
        }
        catch (FilesystemException $e) {
		    return false;
        }

		$hash = self::createHash();
		$fileName = $hash . '.png';
		$success = imagepng($im, $path . '/' . $fileName);
		imagedestroy($im);
		if ($success) {
			return $fileName;
		}
		return $success;
	}

	// get img src as base46 encoded binary
	public static function createBinaryPng($base30Data, $canvasWidth = 280, $canvasHeight = 120) {
		if (empty($base30Data)) {
			return '';
		}
        if (!(str_starts_with($base30Data, 'image/jsignature;base30'))) {
            return '';
        }
		$xyArray = self::convertBase30ToxyArray($base30Data);
		if (empty($xyArray)) {
			return '';
		}
		$im = self::getBinaryImg($xyArray, $canvasWidth, $canvasHeight);
		ob_start();
		$success = imagepng($im);
		$image_data = ob_get_contents();
		ob_end_clean();
		imagedestroy($im);
		if ($success) {
			$base64 = base64_encode($image_data);
			return ('data:image/png;base64,' . $base64);
		}
		return '';
	}

	// get image as svg xml
	protected static function getSvgXml($base30Data) {
		//works but does not scale properly
		if (empty($base30Data)) {
			return '';
		}
		$xyArray = self::convertBase30ToxyArray($base30Data);
		if (empty($xyArray)) {
			return '';
		}
		$svgConverter = new \Visolutions\Component\Visforms\Administrator\Helper\SignatureToolsSVG();
		$img = $svgConverter->NativeToSVG($xyArray);
		return $img;
	}

	protected static function convertBase30ToxyArray($base30Data) {
		$data = str_replace('image/jsignature;base30,', '', $base30Data);
		if (empty($data)) {
			return array();
		}
		$signature = new SignatureToolsBase30();
		return $signature->Base64ToNative($data);
	}

	protected static function getBinaryImg($xyArray, $width, $height) {
		$im = imagecreatetruecolor($width, $height);
		imagesavealpha($im, true);
		$trans_colour = imagecolorallocatealpha($im, 0, 0, 0, 127);
		imagefill($im, 0, 0, $trans_colour);
		imagesetthickness($im, 5);
		$color = imagecolorallocate($im, 0, 0, 0);
		for ($i = 0; $i < count($xyArray); $i++)
		{
			for ($j = 0; $j < count($xyArray[$i]['x']); $j++)
			{
				if ( ! isset($xyArray[$i]['x'][$j]) or ! isset($xyArray[$i]['x'][$j+1])) break;
				imageline($im, $xyArray[$i]['x'][$j], $xyArray[$i]['y'][$j], $xyArray[$i]['x'][$j+1], $xyArray[$i]['y'][$j+1], $color);
			}
		}
		return $im;
	}

	protected static function createHash() {
		if (function_exists('openssl_random_pseudo_bytes')) {
			$rand = openssl_random_pseudo_bytes(16);
			if ($rand === false) {
				// Broken or old system
				$rand = mt_rand();
			}
		} else {
			$rand = mt_rand();
		}
		$hashThis = microtime() . $rand;
		if (function_exists('hash')) {
			$hash = hash('sha256', $hashThis);
		} else if (function_exists('sha1')) {
			$hash = sha1($hashThis);
		} else {
			$hash = md5($hashThis);
		}
		return $hash;
	}

	public static function loadSignatureJs ($api = "") {
		// add inline css
		$wa = Factory::getApplication()->getDocument()->getWebAssetManager();
        $wa->addInlineStyle('.visCanvas {border:1px dotted gray !important;}');
        // load js files
        if ($api === "1") {
            // JS file not yet in installation
            self::loadSignaturePadApi();
        }
        else {
            self::loadSignatureApi();
        }
	}

	protected static function loadSignatureApi() {
        $wa = Factory::getApplication()->getDocument()->getWebAssetManager();
        $wa->useScript('jquery');
        $wa->useScript('jquery-noconflict');
        $wa->registerAndUseScript('com_visforms.flashcancas', 'media/com_visforms/js/flashcanvas.js', array('version' => 'auto', 'relative' => false, 'detectBrowser' => false, 'detectDebug' => false, 'conditional' => 'lt IE 9'));
        $wa->registerAndUseScript('com_visforms.jSignature', 'media/com_visforms/js/jSignature.min.noconflict.js', array('version' => 'auto', 'relative' => false, 'detectBrowser' => false, 'detectDebug' => false));
	}

	// js file is not yet part of the installation!
    protected static function loadSignaturePadApi() {
        $wa = Factory::getApplication()->getDocument()->getWebAssetManager();
        $wa->registerAndUseScript('com_visforms.signaturePad', 'media/com_visforms/js/signature_pad.umd.min.js', array('version' => 'auto', 'relative' => false, 'detectBrowser' => false, 'detectDebug' => false));
    }
}