<?php
/**
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2018 vi-solutions
 */
namespace Visolutions\Component\Visforms\Administrator\Visfield\PlaceholderEntry;

// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\User\User;
use Visolutions\Component\Visforms\Administrator\Visfield\VisfieldPlaceholderEntry;

class CreatedByEntry extends VisfieldPlaceholderEntry {

    protected static $customParams = array(
        'NAME' => 'COM_VISFORMS_PLACEHOLDER_PARAM_USER_NAME',
    );

    protected static $customSubscriptionParams = array (
        'DIE' => 'COM_VISFORMS_PLACEHOLDER_CREATED_BY_DIE'
    );

    public function getReplaceValue() {
        // if data is empty string,
        // check if this ist a 'DIE' parameter
        // return proper CSS class or replace the placeholder with nothing
        if (isset($this->rawData) && ($this->rawData === '')) {
            return '';
        }
        $customParams = array_merge(self::$customParams, self::$customSubscriptionParams);
        if (!empty($this->param) && array_key_exists($this->param, $customParams)) {
            switch ($this->param) {
                case 'NAME' :
                    // user id 0
                    // we can get no name
                    if (empty($this->rawData)) {
                        // return empty string to remove the placeholder
                        return '';
                    }
                    return $this->getUserName();
                case 'DIE' :
                    // user id 0
                    if (empty($this->rawData)) {
                        return 'die';
                    }
                    // return empty string to remove the placeholder
                    return '';
                default:
                    return $this->rawData;
            }
        }
        return $this->rawData;
    }

    protected function getUserName() {
        $user = new User((int) $this->rawData);
        if (!empty($user)) {
            return $user->name;
        }
        return '';
    }
}