<?php
/**
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2018 vi-solutions
 */
namespace Visolutions\Component\Visforms\Administrator\Visfield\PlaceholderEntry;

// no direct access
defined('_JEXEC') or die('Restricted access');

use Visolutions\Component\Visforms\Administrator\Visfield\VisfieldPlaceholderEntry;

class DefaultEntry extends VisfieldPlaceholderEntry {

    protected static $customSubscriptionParams = array (
        'DIE' => 'COM_VISFORMS_PLACEHOLDER_DIE'
    );

	public function getReplaceValue() {
	    // if data is empty string,
        // check if this ist a 'DIE' parameter
        // return proper CSS class or replace the placeholder with nothing
        if (isset($this->rawData) && ($this->rawData === '')) {
            if (!empty($this->param) && $this->param === 'DIE' && $this->hasSub) {
                return 'die';
            }
            // return empty string to remove the placeholder
            return '';
        }
        $customParams =  array_merge(self::$labelParams, self::$customSubscriptionParams);
        if (!empty($this->param) && array_key_exists($this->param, $customParams)) {
            switch ($this->param) {
                case 'DIE' :
                    return '';
                case 'DISPLAYLABEL' :
                    return $this->field->label;
                case 'DISPLAYLABELPLUSSPACE' :
                    return $this->field->label . ' ';
                default:
                    return $this->rawData;
            }
        }
        return $this->rawData;
    }
}