<?php
/**
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2018 vi-solutions
 */
namespace Visolutions\Component\Visforms\Administrator\Visfield\Restriction;

// no direct access
defined('_JEXEC') or die('Restricted access');

use Visolutions\Component\Visforms\Administrator\Visfield\VisfieldRestriction;

class UsedAsEqualTo extends VisfieldRestriction {

	public function __construct($value, $id, $name, $fid = null) {
		$this->type = 'usedAsEqualTo';
		parent::__construct($value, $id, $name, $fid);
	}

	protected function addRestricts() {
		if ((str_starts_with($this->value, '#field'))) {
			$restrict = array();
			$restrict['type'] = $this->type;
			$restrict['restrictedId'] = parent::getRestrictedId($this->value);
			$restrict['restrictorId'] = $this->id;
			$restrict['restrictorName'] = $this->name;
			$this->restricts[] = $restrict;
		}
	}
}