<?php
/**
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2018 vi-solutions
 */
namespace Visolutions\Component\Visforms\Administrator\Visfield;

// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Language\Text;
use Visolutions\Component\Visforms\Administrator\Helper\AefHelper;

abstract class VisfieldPlaceholderEntry {

	protected $param;
	protected $rawData;
	protected $field;
	// always list all customParams in the child class
	protected static $customParams = array();
    // always list all customSubscriptionParams in the child class
    // alternatively we could set basic option her and use late static binding to merge values from parent and child classes
    // we would then need declare the parameters in every child class
    // as the parameters, which are available, differ greatly between child classes,
    // this probably does not make it much easier to read and maintain
	protected static $customSubscriptionParams = array();
	protected static $labelParams = array (
        'DISPLAYLABEL' => 'COM_VISFORMS_PLACEHOLDER_PARAM_LABEL',
        'DISPLAYLABELPLUSSPACE' => 'COM_VISFORMS_PLACEHOLDER_PARAM_LABEL_PLUS_SPACE',
    );

	// used to create placeholder list in modal editor-xtd-button view
	// we do not provide checked_out and checked_out_time in this list
	public static $nonFieldPlaceholder = array(
        'formid' => 'COM_VISFORMS_PLACEHOLDER_FORM_ID',
		'formtitle' => 'COM_VISFORMS_PLACEHOLDER_FORM_TITLE',
		'id' => 'COM_VISFORMS_ID',
		'created' => 'COM_VISFORMS_PARAM_CREATED_DATE_TIME',
		'created_by' => 'COM_VISFORMS_PARAM_CREATED_BY',
		'modified' => 'COM_VISFORMS_PARAM_MODIFIED_AT_DATE_TIME',
		'modified_by' => 'COM_VISFORMS_PARAM_MODIFIED_BY',
		'ismfd' => 'COM_VISFORMS_MODIFIED',
		'ipaddress' => 'COM_VISFORMS_IP',
		'currentdate' => 'COM_VISFORMS_CURRENT_CURRENT_DATE'
	);

	public static $subscriptionNonFieldPlaceholder = array(
		
	);

	protected $hasSub;

	public function __construct($param, $rawData, $field) {
		$this->param = $param;
		$this->rawData = $rawData;
		$this->field = $field;
		$this->hasSub = AefHelper::checkAEF();
	}

	public static function getInstance ($pParam, $rawData, $pType = null, $field = null) {
		if (empty($pParam)) {
		    $pParam = '';
        }
		$pType = self::prepareClassName($pType);
	    $className = 'Visolutions\\Component\\Visforms\\Administrator\\Visfield\\PlaceholderEntry\\' . $pType . 'Entry';
		if (!class_exists($className)) {
		    $className = 'Visolutions\\Component\\Visforms\\Administrator\\Visfield\\PlaceholderEntry\\DefaultEntry';
		}
		if (class_exists($className)) {
			return new $className($pParam, $rawData, $field);
		}
		return false;
	}

	// returns an array of strings that can be added as params to the placeholder
    // Example (not implemented): using late static binding to merge parameters form parent and child classes
    // Parameters must then be declared in both classes
    // child classes can extend the list in the parent class then
    /* if (__CLASS__ == static::class) {
            return self::$meta;
        }
        return array_merge(self::$meta, static::$meta);*/

	public static function getParamStringsArrayForType($pType = null) {
		$var = 'customParams';
		$subscriptionVar = 'customSubscriptionParams';
		$labelVar = 'labelParams';
        $pType = self::prepareClassName($pType);
		$className = 'Visolutions\\Component\\Visforms\\Administrator\\Visfield\\PlaceholderEntry\\' . $pType . 'Entry';
        if (!class_exists($className)) {
            $className = 'Visolutions\\Component\\Visforms\\Administrator\\Visfield\\PlaceholderEntry\\DefaultEntry';
        }
		if (class_exists($className)) {
			$vars = get_class_vars($className);
			if (!empty($vars) && is_array($vars)) {
				if (AefHelper::checkAEF()) {
					$customParams = array_merge($className::$$var, $className::$$labelVar, $className::$$subscriptionVar);
				}
				else {
					$customParams = array_merge($className::$$var, $className::$$labelVar);
				}
				foreach ($customParams as $key => $description) {
					$customParams[$key] = Text::_($description);
				}
				return $customParams;
			}
		}
		// no special params for this type
		return self::$$var;
	}

	// returns an array of strings that con be added as params to field placeholder
    public static function getParamStringsArrayForOverhead($pType = null) {
        $pType = self::prepareClassName($pType);
        $className = 'Visolutions\\Component\\Visforms\\Administrator\\Visfield\\PlaceholderEntry\\' . $pType . 'Entry';
        if (class_exists($className)) {
            $vars = get_class_vars($className);
            if (!empty($vars) && is_array($vars)) {
                $customParams = (AefHelper::checkAEF()) ? array_merge($className::$customParams, $className::$customSubscriptionParams) : $className::$customParams;
                foreach ($customParams as $key => $description) {
                    $customParams[$key] = Text::_($description);
                }
                return $customParams;
            }
        }
        return array();
    }
	
	public static function getStaticPlaceholderList() {
		return (AefHelper::checkAEF()) ? array_merge(self::$nonFieldPlaceholder, self::$subscriptionNonFieldPlaceholder) : self::$nonFieldPlaceholder;
	}

	protected static function prepareClassName($pType) {
        if (empty($pType)) {
            $pType = 'Default';
        }
        // Adapt some class names
        switch ($pType) {
            case 'created_by':
                $pType = 'CreatedBy';
                break;
            case 'modified_by' :
                $pType = 'ModifiedBy';
                break;
            case 'currentdate':
                $pType = 'CurrentDate';
                break;
            case 'ipaddress':
                $pType = 'IpAddress';
                break;
            default:
                $pType = ucfirst($pType);
        }
        return $pType;
    }

	abstract public function getReplaceValue();
}