<?php
/**
 * @author       Aicha Vack
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2021 vi-solutions
 * @since        Joomla 1.6
 */

// no direct access
defined('_JEXEC') or die( 'Restricted access' );

use Joomla\CMS\Factory;
use Joomla\CMS\Session\Session;
use Joomla\CMS\Router\Route;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Layout\FileLayout;
use Visolutions\Component\Visforms\Administrator\Visfield\VisfieldPlaceholderEntry;

if (Factory::getApplication()->isClient('site')) {
	Session::checkToken() or die(Text::_('JINVALID_TOKEN'));
}

$wa = $this->getDocument()->getWebAssetManager();
$wa->useScript('core')
    ->useScript('multiselect')
    ->useScript('modal-content-select')
    ->registerAndUseScript('com_visforms.admin-visformfields-modal', 'com_visforms/admin-visformfields-modal.js', [], ['defer' => true]);

// only render placeholder for overhead on first page and if no search filter are set
$search = $this->state->get('filter.search');
$hasActiveFilter = !empty($this->activeFilters);
$defaultOrdering = ($this->listOrdering === 'a.id' && strtolower($this->listDirection) === strtolower('ASC'));
$showOverheadFields = (((empty ($this->pagination->pagesCurrent) || $this->pagination->pagesCurrent === 1)) && (!$hasActiveFilter) && (empty($search)) && ($defaultOrdering));

// @todo: Use of Function and Editor is deprecated and should be removed in 6.0. It stays only for backward compatibility.
$linkeditorname = '';
$function	= Factory::getApplication()->getInput()->getCmd('function', 'jSelectVisformfield');
$editor = Factory::getApplication()->getInput()->getCmd('editor', '');

$linkeditorname = '&amp;editor=' . $editor;
if (!empty($editor)) {
    // This view is used also in com_menus. Load the xtd script only if the editor is set!
    Factory::getApplication()->getDocument()->addScriptOptions('xtd-visformfields', array('editor' => $editor));
    $onclick = "jSelectVisformfield";
}

// Add field types that should not be available as placeholder to this list
$hiddenFieldTypes = array('submit', 'reset', 'image', 'fieldsep', 'pagebreak');
// add fields which should not show a placeholder without any parameter
$fieldTypesWithoutDefaultParameter = array('select', 'selectsql', 'radio', 'radiosql', 'multicheckbox', 'multicheckboxsql');
$nonFieldPlaceholder = VisfieldPlaceholderEntry::getStaticPlaceholderList(); ?>
<div class="container-popup">
<form action="<?php echo Route::_('index.php?option=com_visforms&view=visplaceholders&fid=' . Factory::getApplication()->getInput()->getInt('fid', 0) . '&layout=modal&tmpl=component&function='.$function.'&'.Session::getFormToken().'=1'. $linkeditorname);?>" method="post" name="adminForm" id="adminForm">
	<?php echo LayoutHelper::render('joomla.searchtools.default', array('view' => $this)); ?>
	<table class="table table-striped table-condensed" id="articleList">
		<caption id="captionTable" class="sr-only">
			<?php echo Text::_('COM_CONTENT_ARTICLES_TABLE_CAPTION'); ?>, <?php echo Text::_('JGLOBAL_SORTED_BY'); ?>
		</caption>
		<thead>
			<tr>
				<th width="1%"class="center nowrap"><?php echo $this->getSortHeader('JGRID_HEADING_ID', 'a.id'); ?></th>
				<th class="center nowrap"><?php echo $this->getSortHeader('JGLOBAL_TITLE', 'a.label'); ?></th>
                <th width="10%" class="nowrap center"><?php echo $this->getSortHeader('COM_VISFORMS_TYPE', 'a.typefield'); ?></th>
			</tr>
		</thead>
		<tfoot>
			<tr>
				<td colspan="15">
					<?php echo $this->pagination->getListFooter(); ?>
				</td>
			</tr>
		</tfoot>
		<tbody> <?php
        // only render placeholder for overhead on first page and if no search filter are set
        if ($showOverheadFields) {
            foreach ($nonFieldPlaceholder as $placeholder => $title) { ?>
                <tr>
                    <td class="center"></td>
                    <td class="center">
                        <a href="javascript:void(0)" onclick="if (window.parent) window.<?php echo $this->escape($function);?>('<?php echo $this->escape(addslashes($placeholder)); ?>','<?php echo $this->escape(addslashes($editor)); ?>');">
                            <?php echo $this->escape(Text::_($title)); ?></a>
                    </td>
                    <td class="center nowrap"><?php echo Text::_('COM_VISFORMS_OVERHEAD_PLACEHOLDER'); ?></td>
                </tr> <?php
                $oParams = VisfieldPlaceholderEntry::getParamStringsArrayForOverhead($placeholder);
                if (!empty($oParams)) {
                    foreach ($oParams as $oParamValue => $oParamLabel) {
                        ?><tr>
                        <td class="center"></td>
                        <td class="center">
                            <a href="javascript:void(0)" onclick="if (window.parent) window.<?php echo $this->escape($function);?>('<?php echo $this->escape(addslashes($placeholder. '|' . $oParamValue)); ?>','<?php echo $this->escape(addslashes($editor)); ?>');">
                                <?php echo $this->escape($oParamLabel); ?></a>
                        </td>
                        <td class="center nowrap"><?php echo Text::_('COM_VISFORMS_OVERHEAD_PLACEHOLDER'); ?></td>
                        </tr>
                        <?php
                    }
                }
            }
        }
		foreach ($this->items as $i => $item) {
			if (!(in_array($item->typefield, $hiddenFieldTypes)) && $item->published) {
				$placeholder = new stdClass();
				$placeholder->counter = $i;
				$placeholder->id = $item->id;
				$placeholder->name = $item->name;
				$placeholder->label = $item->label;
				$placeholder->function = $function;
				$placeholder->typefield = $item->typefield;
				$placeholder->editor = $editor;
				// some field types do not have a parameter free default placeholder
				if (!(in_array($item->typefield, $fieldTypesWithoutDefaultParameter))) {
                    echo LayoutHelper::render('modal.visplaceholders.placeholder', array('view' => $this, 'placeholder' => $placeholder));
                }
				$params = VisfieldPlaceholderEntry::getParamStringsArrayForType($item->typefield);
				if (!empty($params)) {
					foreach ($params as $pParamValue => $pParamLabel) {
						$placeholder->name = $item->name . '|' . $pParamValue;
						$placeholder->label = $item->label . ' (' . $pParamLabel . ')';
						echo LayoutHelper::render('modal.visplaceholders.placeholder', array('view' => $this, 'placeholder' => $placeholder));
					}
				}
				unset($placeholder);
				unset($params);
			}
		} ?>
		</tbody>
	</table>

	<div><?php
        $layout = new FileLayout('div.form_hidden_inputs');
        echo $layout->render(); ?>
	</div>
</form>
</div>
