const visFormData = {
    version : '5.4.0',
    // action task in item row (publish, unpublish, download a single pdf document)
    vflistItemTask : function ( id, task, context, url, urlOrg, fid) {
        let f = document.getElementById(context + 'adminForm');
        let i = 0, cbx, tmplId;
        let parts = task.split('_');
        task = parts[0];
        tmplId = (parts[1]) ? parts[1] : 0;
        // access form control by its id (i.e. input id=cb0)
        // get hidden checkbox for selected record
        let cb = f[ id ];
        // record does not exist
        if ( !cb ) return false;
        // clean up; uncheck all hidden checkboxes
        while ( true ) {
            cbx = f[ "cb" + i ];
            if ( !cbx ) break;
            cbx.checked = false;
            i++;
        }
        // check hidden checkbox of selected record
        cb.checked = true;
        // if boxchecked is not set to 1 Joomla will throw an alert "you must check a box"
        f.boxchecked.value = 1;
        // if we have an additional id (pdf template id) set it in a hidden input
        f.tmplid.value = tmplId;
        // use a specified alternative action url
        if (typeof url !== 'undefined') {
            f.action = url;
        }
        // task from mysubmissions
        // form id must be passed
        if (typeof fid !== 'undefined') {
            f.id.value = fid;
        }
        // Joomla.submitform clones the (admin) form, which should not have a submit button of its own, adds a submit button and clicks the button
        Joomla.submitform( task, f );
        // clear task and tmplid and reset action url
        f.task.value='';
        f.tmplid.value = '0';
        if (typeof urlOrg !== 'undefined') {
            f.action = urlOrg;
        }
        if (typeof fid !== 'undefined') {
            f.id.value = '0';
        }
        return false;
    },
    // helper for action task in item row (publish, unpublish, download a single pdf document)
    prepareListItemTask: function (event) {
        let item = event.target;
        if (item.nodeName === 'SPAN' && ['A', 'BUTTON'].includes(item.parentNode.nodeName)) {
            item = item.parentNode;
        }
        if (item.nodeName === 'A') {
            event.preventDefault();
        }
        if (item.hasAttribute('disabled') || !item.hasAttribute('data-item-task')) {
            return;
        }
        const {
            itemId
        } = item.dataset;
        const {
            itemTask
        } = item.dataset;
        const {
            itemContext
        } = item.dataset;
        const {
            itemUrl
        } = item.dataset;
        const {
            itemUrlOrg
        } = item.dataset;
        const {
            itemFid
        } = item.dataset;
        visFormData.vflistItemTask(itemId, itemTask, itemContext, itemUrl, itemUrlOrg, itemFid);
    },
    // download listbox
    vflistTask : function () {
        let list = this;
        if (list.value === '') {
            return false;
        }
        let listBaseUrl = list.dataset.listBaseUrl || '';
        let formId = list.getAttribute('data-form-id');
        let f = list.form;
        let orgUrl = f.action;
        let url = listBaseUrl + 'index.php?option=com_visforms&view=visformsdata&id='+formId;
        let value = list.value;
        let parts = value.split('_');
        let task = 'visformsdata.' + parts[0];
        let tmplId = (parts[1]) ? parts[1] : 0;
        f.tmplid.value = (parts[1]) ? parts[1] : 0;
        f.action = url;
        // Joomla.submitform clones the (admin) form, which should not have a submit button of its own, adds a submit button and clicks the button
        Joomla.submitform( task, f );
        // clear task and tmplid and reset action url
        f.task.value='';
        f.tmplid.value = '0';
        f.action = orgUrl;
        return false;
    },
    // order listbox in search tools
    vttableFullOrdering : function(event) {
        let element = event.target;
        let form = element.form;
        let idx = element.selectedIndex;
        let sel = element[idx].value;
        if (sel && (typeof sel === 'string')) {
            let opts = sel.split(' ');
            if (Array.isArray(opts) && opts.length === 2) {
                const {
                    formContext
                } = element.dataset;
                let order = opts[0].trim();
                let orderDirection = opts[1].trim();
                let orderInput = formContext + 'filter_order';
                let orderDirInput = formContext + 'filter_order_Dir';
                form.elements[orderInput].value = order;
                form.elements[orderDirInput].value = orderDirection;
                Joomla.submitform('', form);
            }
        }
    },
    // order link in table header
    vftableOrdering : function (event) {
        let item = event.target;
        if (item.nodeName === 'SPAN' && ['A', 'BUTTON'].includes(item.parentNode.nodeName)) {
            item = item.parentNode;
        }
        if (item.nodeName === 'A') {
            event.preventDefault();
        }
        const {
            formContext
        } = item.dataset;
        let form = document.getElementById(formContext + 'adminForm');
        const {
            order
        } = item.dataset;
        const {
            orderDirection
        } = item.dataset;
        const {
            orderTask
        } = item.dataset;
        let orderInput = formContext + 'filter_order';
        let orderDirInput = formContext + 'filter_order_Dir';
        form.elements[orderInput].value = order;
        form.elements[orderDirInput].value = orderDirection;
        Joomla.submitform(orderTask, form);
    },
    // standard task in detail view like publish/unpublish
    vfDetailTask : function (event) {
        let item = event.target;
        if (item.nodeName === 'SPAN' && ['A', 'BUTTON'].includes(item.parentNode.nodeName)) {
            item = item.parentNode;
        }
        if (item.nodeName === 'A') {
            event.preventDefault();
        }
        const {
            itemId
        } = item.dataset;
        const {
            itemTask
        } = item.dataset;
        const {
            itemContext
        } = item.dataset;
        const {
            itemUrl
        } = item.dataset;
        let f = document.getElementById(itemContext + 'adminForm');
        // Joomla.submitform clones the (admin) form, which should not have a submit button of its own, adds a submit button and clicks the button
        Joomla.submitform(itemTask, f);
        // clear task and tmplid and reset action url
        f.task.value = '';
        f.tmplid.value = '0';
        return false;
    },
    geocodeSearchAddress : function (event) {
        geocodeSearchAddress(event.target);
    }
}
const setupVfDataViewTasks = ({target}) => {
    target.querySelectorAll('.vfdv-task').forEach(
        element => element.addEventListener('click', visFormData.prepareListItemTask)
    );
    target.querySelectorAll('.vfdv-column-order').forEach(
        element => element.addEventListener('click', visFormData.vftableOrdering)
    );
    target.querySelectorAll('.select-list-vfdv-order').forEach(
        element => element.addEventListener('change', visFormData.vttableFullOrdering)
    );
    target.querySelectorAll('.select-list-pdf-download').forEach(
        element => element.addEventListener('change', visFormData.vflistTask)
    );
    target.querySelectorAll('.vfdv-detail-task').forEach(
        element => element.addEventListener('click', visFormData.vfDetailTask)
    );
    target.querySelectorAll('.placessearchbox').forEach(
        element => element.addEventListener('change', visFormData.geocodeSearchAddress)
    );
};
setupVfDataViewTasks({
    target: document
});
document.addEventListener('DOMContentLoaded', setupVfDataViewTasks);