<?php
/**
 * Visforms captcha html for default layout
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */
// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Language\Text;
use Visolutions\Component\Visforms\Site\Recaptcha\Recaptcha;

if (!empty($displayData)) :
	if (isset($displayData['form'])) :
        $form = $displayData['form'];
		$captcha = New Recaptcha($form);
		if ($captcha->isEnabled()) :
			$input = $captcha->render();
			$name = 'g-recaptcha-response';
			$html = array();
			if (isset($form->captcha) && (int) $form->captcha === 5) {
				$html[] = '<div class="captchaCont required">';
                $html[] = '<label id="captcha-lbl'.$form->context.'" for="' . $name . '">';
                $html[] = '<span class="visually-hidden">' . Text::_('COM_VISFORMS_INVISIBLE_GOOGLE_CAPTCHA_LABEL') . '</span>';
                $html[] = '</label>';
				$html[] = $input;
				$html[] = '</div>';
			}
			echo implode('', $html);
		endif;
	endif;
endif;

        