<?php
/**
 * Visforms control html for radio for default layout
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */

use Joomla\Utilities\ArrayHelper;
use Joomla\CMS\Layout\FileLayout;

// no direct access
defined('_JEXEC') or die('Restricted access');

if (!empty($displayData)) :
	if (isset($displayData['field'])) :
		$field = $displayData['field'];
        $clabel = $field->clabel;
        $ccustomtext = $field->ccustomtext;
        $class = (isset($field->isConditional) && ($field->isConditional == true)) ? 'conditional field' . $field->id  : 'field' . $field->id;
        $class .= (isset($field->isDisabled) && ($field->isDisabled == true)) ? ' vishidden' : '';
        $required = (isset($field->attribute_required) && ($field->attribute_required == true)) ? ' required' : '';
		$html = array();
		// render control group wrappter html
        $html[] = '<div class="';
        $html[] = $class;
        $html[] = $required;
        $html[] = (!empty($field->controlGroupCSSclass)) ? ' ' . $field->controlGroupCSSclass : '';
        $html[] ='"';
        $html[] = ' role="radiogroup"';
        $html[] = (isset($field->{'attribute_aria-readonly'}) && ($field->{'attribute_aria-readonly'} === 'true')) ?  ' aria-readonly="true"'  : '';
        $html[] = ' aria-labelledby="' . $field->name. 'lbl"';
        $html[] = '>';
        if (($ccustomtext != '') && (isset($field->customtextposition)) && (($field->customtextposition == 0) || ($field->customtextposition == 1))) {
            $html[] = $ccustomtext;
        }
        $layout = new FileLayout('visforms.decorators.default_error_div', null);
        $layout->setOptions(array('component' => 'com_visforms'));
        $html[] = $layout->render($displayData);
        $html[] = $clabel;
        // render options
		$k = count($field->opts);
		$checked = "";
		$asList = (isset($field->display) && $field->display == 'LST') ? true : false;
		if ($asList) {
			// Show radios as a list; Wrap them in an div
			$html[] = '<div class="visCSSclear ' . $field->fieldCSSclass . '">';
		}
		else {
			$html[] = '<p class="visCSStop0 visCSSmargLeft visCSSrbinl ' . $field->fieldCSSclass . '">';
		}
		for ($j = 0; $j < $k; $j++) {
			// option specific label class
			$labelClass = (!empty($field->opts[$j]['labelclass'])) ? $field->opts[$j]['labelclass'] . ' ': '';
			$inputAttributes = (!empty($field->attributeArray)) ? ArrayHelper::toString($field->attributeArray, '=', ' ', true) : '';
			if ($field->opts[$j]['selected'] != false) {
				$checked = 'checked="checked" ';
			}
			else {
				$checked = "";
			}
			if (!empty($field->opts[$j]['disabled'])) {
				$disabled = ' disabled="disabled" data-disabled="disabled" ';
			}
			else {
				$disabled = "";
			}
			if ($asList) {
				if ($j != 0) {
					$html[] = '<br />';
				}
				$labelClass .= ' visCSSbot5 visCSSrllst ';
				$html[] = '<label class="' . $labelClass . ' ' . $field->labelCSSclass . '" id="' . $field->name . 'lbl_' . $j . '" for="field' . $field->id . '_' . $j . '">' . $field->opts[$j]['label'] . '</label>';
				$html[] = '<input id="field' . $field->id . '_' . $j . '" name="' . $field->name . '" value="' . $field->opts[$j]['value'] . '" ' . $checked . $disabled . $inputAttributes . ' aria-labelledby="' . $field->name . 'lbl_' . $j . '" data-error-container-id="fc-tbxfield' . $field->id . '" />';
			}
			else {
				$labelClass .= 'visCSStop10 visCSSright20 visCSSrlinl ';
				$html[] = '<input id="field' . $field->id . '_' . $j . '" name="' . $field->name . '" value="' . $field->opts[$j]['value'] . '" ' . $checked . $disabled . $inputAttributes . '  aria-labelledby="' .$field->name . 'lbl_' . $j . '" data-error-container-id="fc-tbxfield' . $field->id . '" />';
				$html[] = '<label class="' . $labelClass . ' ' . $field->labelCSSclass . '" id="' . $field->name . 'lbl_' . $j . '" for="field' . $field->id . '_' . $j . '">' . $field->opts[$j]['label'] . '</label>';
			}
		}
		if ($asList) {
			$html[] = '</div>';
		}
		else {
			$html[] = '</p>';
		}
        if (($ccustomtext != '') && (((isset($field->customtextposition)) && ($field->customtextposition == 2)) || !(isset($field->customtextposition)))) {
            $html[] = $ccustomtext;
        }
        $html[] = '<p class="visCSSclear"><!-- --></p>';
        $html[] = '</div>';
		echo implode('', $html);
	endif;
endif;