<?php
/**
 * VisformsPrepareDoiMailText Event for Visforms
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 5.0.0
 */

namespace Visolutions\Component\Visforms\Site\Event\Visforms;
// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

use Visolutions\Component\Visforms\Administrator\Event\Visforms\VisformsAbstractEvent;

class VisformsPrepareDoiMailTextEvent extends VisformsAbstractEvent{

    public function __construct($name, array $arguments = []) {
        parent::__construct($name, $arguments);

        if (!\array_key_exists('subject', $this->arguments)) {
            throw new \BadMethodCallException("Argument 'subject' of event {$name} is required but has not been provided");
        }

        if (!\array_key_exists('context', $this->arguments)) {
            throw new \BadMethodCallException("Argument 'context' of event {$name} is required but has not been provided");
        }

        if (!\array_key_exists('text', $this->arguments)) {
            throw new \BadMethodCallException("Argument 'text' of event {$name} is required but has not been provided");
        }
    }

    public function getForm(): object  {
        return $this->arguments['subject'];
    }

    public function getContext(): string {
        return $this->arguments['context'];
    }

    public function getText(): string {
        return $this->arguments['text'];
    }

}