<?php
/**
 * Visforms field email business class
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */
namespace  Visolutions\Component\Visforms\Site\Lib\Business;

// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\String\StringHelper;
use Joomla\CMS\HTML\HTMLHelper;
use Visolutions\Component\Visforms\Site\Lib\Message\MaxCalculationValueMessage;
use Visolutions\Component\Visforms\Site\Lib\Message\MinCalculationValueMessage;
use Visolutions\Component\Visforms\Site\Lib\Validation\MinNumberValidation;
use Visolutions\Component\Visforms\Site\Lib\Validation\MaxNumberValidation;
use Visolutions\Component\Visforms\Site\Lib\Validation\EqualToValidation;
use Visolutions\Component\Visforms\Site\Lib\Message\EqualToMessage;
use Visolutions\Component\Visforms\Site\Lib\Validation\CustomValidation;
use Visolutions\Component\Visforms\Site\Lib\Message\DefaultMessage;

class CalculationFieldBusiness extends Business
{
    public function __construct($field, $form, array $fields) {
		parent::__construct($field, $form, $fields);
	}

	public function getFields() {
		$this->setField();
		return $this->fields;
	}

	protected function setField() {
		$this->setCustomJs();
		$this->setIsDisabled();
		if (isset($this->field->dataSource) && $this->field->dataSource == 'post') {
			$this->calculate($this->field);
            $this->validatePostValue();
		}
		$this->addShowWhenForForm();
	}

	protected function validatePostValue(): void {
        // rules for calculation are: minlength, maxlength, equalTo, custom validation
        // update $this->field with value from $this->fields
        $this->updateField();
        $valid = true;
        // only to perform when the value is not empty
        if ($this->field->dbValue != "") {
            // do not validate the value in attribute_value for disabled fields, if attribute_value and configurationDefault are exactly identical
            if ((!empty($this->field->isDisabled)) && ($this->field->dbValue === $this->field->unchecked_value)) {
                return;
            }
            // check for right minlength
            if ((isset($this->field->mincalvalue)) && (is_numeric($this->field->mincalvalue)) && ($this->field->mincalvalue != '')) {
                $min = floatval($this->field->mincalvalue);
                // we have already made sure that we deal with a number
                $number = floatval($this->field->dbValue);
                $validation = new MinNumberValidation(array('count' => $number, 'mincount' => $min));
                if (!$validation->validate()) {
                    // invalid value
                    $valid = false;
                    $message = new MinCalculationValueMessage($this->field->label, $this->field->custom_php_error, array('min' => $min));
                    $error = $message->getMessage();
                    // attach error to form
                    $this->setErrors($error);
                }
            }

            // check for right maxlength
            if ((isset($this->field->maxcalvalue)) && (is_numeric($this->field->maxcalvalue)) && ($this->field->maxcalvalue != '')) {
                $max = floatval($this->field->maxcalvalue);
                // we have already made sure that we deal with a number
                $number = floatval($this->field->dbValue);
                $validation = new MaxNumberValidation(array('count' => $number, 'maxcount' => $max));
                if (!$validation->validate()) {
                    // invalid value
                    $valid = false;
                    $message = new MaxCalculationValueMessage($this->field->label, $this->field->custom_php_error, array('max' => $max));
                    $error = $message->getMessage();
                    // attach error to form
                    $this->setErrors($error);
                }
            }

            // perform equalTo validation
            if ((isset($this->field->validate_equalTo)) && ($this->field->validate_equalTo != '0')) {
                $value = $this->field->dbValue;
                $id = str_replace("#field", "", $this->field->validate_equalTo);
                foreach ($this->fields as $equalToField) {
                    if ($equalToField->id == $id) {
                        $validation = new EqualToValidation(array('value' => $value, 'cvalue' => $equalToField->dbValue));
                        if (!$validation->validate()) {
                            // invalid value
                            $valid = false;
                            $message = new EqualToMessage($this->field->label, $this->field->custom_php_error, array('equalToLabel' => $equalToField->label));
                            $error = $message->getMessage();
                            // attach error to form
                            $this->setErrors($error);
                            break;
                        }
                    }

                }
            }

            // perform custom validation
            $regex = isset($this->field->customvalidation) ? "/" . $this->field->customvalidation . "/" : "";
            if ($regex != "") {
                $validation = new CustomValidation(array('value' => $this->field->dbValue, 'regex' => $regex));
                if (!$validation->validate()) {
                    // invalid value
                    $valid = false;
                    $message = new DefaultMessage($this->field->label, $this->field->custom_php_error);
                    $error = $message->getMessage();
                    // attach error to form
                    $this->setErrors($error);
                }
            }
            // validate unique field value in database
            $this->validateUniqueValue();
        }

        // at least one validation failed
        if (!$valid) {
            $this->field->isValid = false;
        }
	}


	public function validateRequired() {
		return $this->field;
	}

	protected function setCustomJs() {
		// add calculation js to field
		$equation = $this->field->equation;
		if (empty($equation)) {
			return true;
		}
		$precision = (int) $this->field->precision;
		$rounding = (!empty($this->field->fixed)) ? ' n = parseFloat(Math.round(n * Math.pow(10, ' . $precision . ' )) /  Math.pow(10, ' . $precision . ')).toFixed(' . $precision . ')' : 'n = parseFloat(Math.round(n * Math.pow(10, ' . $precision . ' )) /  Math.pow(10, ' . $precision . ')).toString()';

		$fixSeparator = ((!empty($this->field->decseparator)) && ($this->field->decseparator == ",")) ? 'n = n.replace(".", ",");' : '';
		$pattern = '/\[[A-Z0-9]{1}[A-Z0-9\-]*]/';
		$eval_vars = array();
		if (preg_match_all($pattern, $equation, $matches)) {
			$unique_matches = array_unique($matches[0]);
			// found matches are store in the $matches[0] array
			foreach ($unique_matches as $match) {
				$str = trim($match, '\[]');
				$fieldname = $this->form->context . StringHelper::strtolower($str);
				foreach ($this->fields as $placeholder) {
					if ($placeholder->name == $fieldname) {
						$replace = 'field' . $placeholder->id;
						if (($placeholder->typefield === 'radio') || ($placeholder->typefield === 'radiosql')) {
							$this->field->customJs[] = "
	                        jQuery(document).ready(function () {jQuery('[name=" . $placeholder->name . "]').on('change recalculate', function (e) {jQuery('#field" . $this->field->id . "').trigger('update');});});";
						}
						else {
							$this->field->customJs[] = "
	                        jQuery(document).ready(function () {jQuery('#" . $replace . "').on('change recalculate', function (e) {jQuery('#field" . $this->field->id . "').trigger('update');});});";
						}
						// replace Comma with dot
						if ($placeholder->typefield === 'checkbox') {
							$eval_vars[$fieldname] = '
                            if (jQuery("#' . $replace . '").prop("checked")) {var ' . $replace . ' = parseFloat(jQuery("#' . $replace . '").val().replace(",", "."))} else {var ' . $replace . ' = parseFloat("' . $placeholder->unchecked_value . '".replace(",", "."))};';
						}
						else if ($placeholder->typefield === 'date') {
							$eval_vars[$fieldname] = '
								if (jQuery("#' . $replace . '").val()) {var dateval, parts, i = 0, fmt = {}, format, offset, ' . $replace . ';  dateval = jQuery("#' . $replace . '").val(); parts = dateval.match(/(\d+)/g); format = (dateval.indexOf(".") > -1) ? "dd.mm.yyyy" : ((dateval.indexOf("/") > -1) ? "mm/dd/yyyy" : "yyyy-mm-dd"); format.replace(/(yyyy|dd|mm)/g, function(part) { fmt[part] = i++; }); offset = new Date().getTimezoneOffset(); ' . $replace . ' = new Date(parts[fmt["yyyy"]], parts[fmt["mm"]]-1, parts[fmt["dd"]],0,0,0,0); ' . $replace . ' = ((((' . $replace . '.valueOf())/1000) - (offset*60))/86400);} else {var ' . $replace . ' = 0};';
						}
						else if (($placeholder->typefield === 'radio') || ($placeholder->typefield === 'radiosql')) {
							$eval_vars[$fieldname] = '
								var selected = jQuery("[id^='.$replace.'_]:checked").val();
								if (typeof selected !== "undefined") {var '.$replace.' = parseFloat(selected.replace(",","."));} else {var '.$replace.' = parseFloat("'.$placeholder->unchecked_value.'".replace(",","."))};
								 ';
						}
						else if ((isset($placeholder->unchecked_value))) {
							$eval_vars[$fieldname] = '
                            if(jQuery("#'.$replace.'").val()) {
                            var ' . $replace . ' = parseFloat(jQuery("#' . $replace . '").val().replace(",", "."))} else {var '.$replace.' = parseFloat("' . $placeholder->unchecked_value . '".replace(",", "."))};';
						}
						else {
							$eval_vars[$fieldname] = '
                            var ' . $replace . ' = parseFloat(jQuery("#' . $replace . '").val().replace(",", "."));';
						}
						// replace the match in equation with eval_var value (= id-attribute of placeholder field in form)
						$newEquation = preg_replace('\'' . preg_quote($match) . '\'', $replace, $equation);
						$equation = $newEquation;
						break;
					}
				}
			}
		}
		// replace php math functions signature with javascript math function signature (Math.)
		$pattern2 = '/(?:abs\s*\(|a?(?:sin|cos|tan)h?\s*\(|ceil\s*\(|exp\s*\(|floor\s*\(|max\s*\(|min\s*\(|log(?:10|1p)?\s*\(|pow\s*\(|round\s*\(|sqrt\s*\()/';
		if (preg_match_all($pattern2, $equation, $matches2)) {
			$unique_matches2 = array_unique($matches2[0]);
			// found matches are store in the $matches[0] array
			foreach ($unique_matches2 as $match) {
				$newEquation = preg_replace('\'' . preg_quote($match) . '\'', "Math." . $match, $equation);
				$equation = $newEquation;
			}
		}

		// create eval function
		$vars = implode('', $eval_vars);
		$script = 'function field' . $this->field->id . 'FormatNumber(n) {' . $rounding . '; ' . $fixSeparator . 'return n;}';
		$script .= '
        jQuery(document).ready(function () {jQuery("#field' . $this->field->id . '").on("update", function (e) {
        let revalidate = (jQuery(this).hasClass("error") || jQuery(this).hasClass("valid")); if (revalidate) {jQuery(this).valid()};
        ' . $vars . ' var res = eval("' . $equation . '"); 
        jQuery(this).val(field' . $this->field->id . 'FormatNumber(res)); jQuery(this).trigger("change");});jQuery("#field' . $this->field->id . '").trigger("update"); 
        });';
		$this->field->customJs[] = $script;
	}
}