<?php
/**
 * Visforms field text business class
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */
namespace  Visolutions\Component\Visforms\Site\Lib\Business;

// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Visolutions\Component\Visforms\Site\Lib\Message\DefaultMessage;
use Visolutions\Component\Visforms\Administrator\Helper\SqlHelper;
use Visolutions\Component\Visforms\Site\Lib\Validation\EqualToValidation;

class HiddenFieldBusiness extends Business
{
	public function getFields() {
		$this->setField();
		return $this->fields;
	}

	protected function setField() {
        $this->setCustomJs();
		if (isset($this->field->dataSource) && $this->field->dataSource == 'post') {
			$this->validatePostValue();
		}
	}

	protected function validatePostValue(): void {
		// rules for text are: minlength, maxlength, equalTo, custom validation, unique field
		// update $this->field with value from $this->fields
		$this->updateField();
		$valid = true;
        // validate value from sql (option toggle_value_from_sql = 1)
        // edit view: only if option sql_process_in_edit_view is 1
        if (!empty($this->field->toggle_value_from_sql)) {
	        // Edit View option sql_process_in_edit_view = 0
	        if (($this->isRedisplayEditTask && empty($this->field->sql_process_in_edit_view))) {
		        // nothing to do
	        }
	        // Form View, always validate sql value
	        else {
		        $value = $this->field->attribute_value;
		        try {
			        $sqlHelper = new SqlHelper($this->field->sql, (isset($this->form->context) ? $this->form->context : ''));
			        $sqlValue = $sqlHelper->getItemsFromSQL('loadResult');
		        }
		        catch (\Exception $e) {
			        $sqlValue = '';
		        }
		        // validate that submitted values equals the value we expect, if we process the sql statement with all the submitted user inputs
		        $validation = new EqualToValidation(array('value' => $value, 'cvalue' => $sqlValue));
		        if (!$validation->validate()) {
			        // invalid value
			        $valid = false;
			        $message = new DefaultMessage($this->field->label, $this->field->custom_php_error);
			        $error = $message->getMessage();
			        // attach error to form
			        $this->setErrors($error);
		        }
	        }
        }
		// validate unique field value in database
		$this->validateUniqueValue();


		// at least one validation failed
		if (!$valid) {
			$this->field->isValid = false;
		}
	}

    public function validateRequired() {
        return $this->field;
    }

    protected function setCustomJs() {
        if (empty($this->field->toggle_value_from_sql)) {
            return true;
        }
        // no value reload, if we do not process SQL in Edit View but use stored values as input.
        if (!empty($this->field->noEditSqlProcess)) {
            return true;
        }
        // add record id as cid to event.data, needed if we are in an edit view
        $cid = 0;
        if ($this->form->displayState === $this->isEditTask || $this->form->displayState === $this->isRedisplayEditTask) {
            $cid = Factory::getApplication()->getInput()->getCmd('cid', 0);
        }
        $cidJs = ", cid: " . $cid;
        // Reload once, after form is loaded in order to set the proper value in the edit view
        $this->setOnloadReloadJs($cidJs, 'reloadValue');
        // set onchange reload event handler
        $this->reloadTriggerFields = isset($this->field->reload) ? $this->field->reload : array();
        if (empty($this->reloadTriggerFields)) {
            return true;
        }
        $this->removeDuplicateReloadTriggerFields();
        // foreach trigger field add a onchange handler which reloads the value for this field
        foreach ($this->reloadTriggerFields as $trigger) {
            foreach ($this->fields as $triggerField) {
                $this->setReloadJs($triggerField, $trigger, $cidJs, 'reloadValue');
            }
        }
    }
}