<?php
/**
 * Visforms field file class
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */
namespace  Visolutions\Component\Visforms\Site\Lib\Field;

// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\PluginHelper;
use Visolutions\Component\Visforms\Site\Event\Visforms\VisfieldBeforeCreateEvent;
use Visolutions\Component\Visforms\Administrator\Helper\MediaHelper;

class FileField extends Field
{
	public function __construct($field, $form) {
		parent::__construct($field, $form);
		// file inputs are not sumitted with the post
		$this->postValue = "";
		// no edit or queryValue for file upload fields
	}

	protected function setField(): void {
		// preprocessing field
		$this->extractDefaultValueParams();
		$this->extractGridSizesParams();
		$this->extractRestrictions();
		$this->mendBooleanAttribs();
        $this->setPropertiesFromFormConfiguration();
        $this->unsetDeselectedEditViewValidations();
        $this->addValidationAttribsForUpload();
        $this->setCustomPhpErrorMsg();
        PluginHelper::importPlugin('visforms');
        $dispatcher = Factory::getApplication()->getDispatcher();
        $event = new VisfieldBeforeCreateEvent('onVisfieldBeforeCreate', [
            'subject' => $this->field,
            'context' => 'com_visforms.field',
            'form' => $this->form
        ]);
        $dispatcher->dispatch('onVisfieldBeforeCreate', $event);
		$this->setIsConditional();
		$this->setFieldDefaultValue();
		$this->setCustomJs();
		$this->setFieldsetCounter();
		$this->setShowRequiredAsterix();
        $this->replaceLabelWithCustomText();
        $this->setIsTmpUpload();
	}

	protected function setFieldDefaultValue(): void {

		// file upload fields do not use the post value but the $_FILES var, but if we have a POST Value, we set dataSource property
		if ((count($_POST) > 0) && isset($_POST['postid']) && ($_POST['postid'] == $this->form->id)) {
			$this->field->dataSource = 'post';
			return;
		}
		// Nothing to do
	}

	protected function setDbValue(): void {
        // Nothing to do
	}

	protected function setRedirectParam(): void {
        // Nothing to do
	}

	protected function setPropertiesFromFormConfiguration() {
        // if no specific maxfilesize value is set in field configuration, use value set in the form configuration
        // $maxfilesize is a number in KiloByte (byte such a big number and more difficult for users to use)
        // this value is used in the javascript validation error message
        if (!isset($this->field->maxfilesize) || (int) $this->field->maxfilesize === 0) {
            $this->field->maxfilesize = $this->form->maxfilesize;
        }
        // if no specific maxfilesize value is set in field configuration, use value set in the form configuration
        $this->field->allowedextensions = (!empty($this->field->allowedextensions)) ? $this->field->allowedextensions : $this->form->allowedextensions;
    }

	protected function addValidationAttribsForUpload() {
        // Get a valid maximum upload file size
        // if the user sets a value in the form/field configuration that is bigger than the php ini value, then the value is set to php ini value
        $maxFileSizeInByte = MediaHelper::getMaxFileSizeInByte($this->field->maxfilesize);
        // in edit view with validation disabled use php ini value
        if ($this->isEditOrSaveEditTask && (!empty($this->field->maxfilesize_nevv))) {
            $maxFileSizeInByte = MediaHelper::toBytes(ini_get('upload_max_filesize'));
        }
        // validation works with the size in byte
        // $maxFileSizeInByte is the number in bytes
		$this->field->validate_filesize = $maxFileSizeInByte;
        // add file extension validation
        if (!$this->isEditOrSaveEditTask || (empty($this->field->allowedextensions_nevv))) {
            $this->field->validate_fileextension = "'" . $this->field->allowedextensions . "'";
        }
	}

	protected function setIsTmpUpload() {
	    if (!empty($this->form->tmp_upload)) {
	        $this->field->tmpUpload = true;
        }
	    else {
            $this->field->tmpUpload = false;
        }
    }

    protected function setConfigurationDefault(): void {
        // Nothing to do
    }

    protected function setEditOnlyFieldDbValue(): void {
        // Nothing to do
    }
}