<?php
/**
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2017 vi-solutions
 */
namespace  Visolutions\Component\Visforms\Site\Lib\Field;

// no direct access
defined('_JEXEC') or die('Restricted access');

use Visolutions\Component\Visforms\Site\Model\VisformsModel as VisformsModelSite;
use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Filter\InputFilter;
use Visolutions\Component\Visforms\Site\Event\Visforms\VisfieldBeforeCreateEvent;

class LocationField extends Field
{
	public function __construct($field, $form) {
		parent::__construct($field, $form);
		$this->postValue = $this->input->post->get($field->name, array(), 'ARRAY');
	}

	protected function setField(): void {
		$this->extractDefaultValueParams();
		$this->extractGridSizesParams();
		$this->extractRestrictions();
		$this->mendBooleanAttribs();
        $this->unsetDeselectedEditViewValidations();
        $this->setCustomPhpErrorMsg();
        PluginHelper::importPlugin('visforms');
        $dispatcher = Factory::getApplication()->getDispatcher();
        $event = new VisfieldBeforeCreateEvent('onVisfieldBeforeCreate', [
            'subject' => $this->field,
            'context' => 'com_visforms.field',
            'form' => $this->form
        ]);
        $dispatcher->dispatch('onVisfieldBeforeCreate', $event);
        $this->setIsConditional();
		$this->fillWith();
		$this->setEditValue();
		$this->setConfigurationDefault();
		$this->setEditOnlyFieldDbValue();
		$this->setFieldDefaultValue();
		$this->setDbValue();
		$this->setRedirectParam();
		$this->setCustomJs();
		$this->setFieldsetCounter();
		$this->setMapCounter();
		$this->setShowRequiredAsterix();
        $this->replaceLabelWithCustomText();
	}

	protected function setFieldDefaultValue(): void {
		if ($this->form->displayState === VisformsModelSite::$displayStateIsNewEditData) {
			if ((isset($this->field->editValue_lat)) && (isset($this->field->editValue_lng))) {
				$this->field->attribute_value_lat = $this->field->editValue_lat;
				$this->field->attribute_value_lng = $this->field->editValue_lng;
			}
			$this->field->dataSource = 'db';

			return;
		}
		if ((count($_POST) > 0) && isset($_POST['postid']) && ($_POST['postid'] == $this->form->id)) {
			if (isset($_POST[$this->field->name])) {
				$this->validateUserInput('postValue');
				$this->field->attribute_value_lat = $this->postValue['lat'];
				$this->field->attribute_value_lng = $this->postValue['lng'];
			}
			// reset to configuration default
			// set to empty, if the field is disabled and the form is re-displayed it will be reset to the default after business logic is performed
			else {
				$this->field->attribute_value_lat = $this->field->configurationDefault_lat;
				$this->field->attribute_value_lng = $this->field->configurationDefault_lng;
			}
			$this->field->dataSource = 'post';
		}
	}

	protected function setDbValue(): void {
		if (isset($this->field->dataSource) && $this->field->dataSource == 'post') {
			$this->field->dbValue = HTMLHelper::_('visformslocation.createDbValue', $this->postValue);
		}
	}

	// not yet used, no support for location as edit only field yet
	protected function setEditOnlyFieldDbValue(): void {
		$this->field->editOnlyFieldDbValue =  HTMLHelper::_('visformslocation.createDbValue', array($this->field->configurationDefault_lat, $this->field->configurationDefault_lng));
	}

	protected function setRedirectParam(): void {
		// nothing to do
	}

	protected function fillWith(): void {
		if ((isset($this->field->fillWith) && $this->field->fillWith != "0")) {
			$this->field->attribute_value_lat = '';
			$this->field->attribute_value_lng = '';
		}
	}

	protected function setConfigurationDefault(): void {
		$this->field->configurationDefault_lat = $this->field->attribute_value_lat;
		$this->field->configurationDefault_lng = $this->field->attribute_value_lng;
	}

	protected function setEditValue(): void {
		if ($this->isEditOrSaveEditTask) {
			$this->field->editValue = "";
			$data = $this->form->data;
			$dataFieldName = $this->getParameterFieldNameForEditValue();
			if (isset($data->$dataFieldName)) {
				$filter = InputFilter::getInstance();
				$tmp = $filter->clean($data->$dataFieldName, 'STRING');
				$inputs = HTMLHelper::_('visformslocation.extractDbValue', $tmp);
				if (!isset($inputs['lat']) || !isset($inputs['lng'])) {
					$this->field->editValue_lat = '';
					$this->field->editValue_lng = '';
				} else {
					$this->field->editValue_lat = $inputs['lat'];
					$this->field->editValue_lng = $inputs['lng'];
				}
			}
		}
	}

	protected function setMapCounter() {
		// always include location field js and Google Maps api, if a location field is in form
		if ((isset($this->form->mapCounter)) && (is_numeric($this->form->mapCounter))) {
			$this->form->mapCounter++;
		}
		else {
			$this->form->mapCounter = (int) 1;
		}
		$this->field->mapCounter = $this->form->mapCounter;
	}

	protected function validateUserInput($inputType) {
		$values = $this->$inputType;
		if (count($values) !== 2 || !is_array($values)) {
			$this->field->isValid = false;
			$error = Text::sprintf('COM_VISFORMS_OPTION_HAS_INVALID_POST_VALUE', $this->field->label);
			$this->setErrorMessageInForm($error);
		}

		$filter = new InputFilter();
		$cleanValues = array();
		$cleanValues['lat'] = $filter->clean($values[0]);
		$cleanValues['lng'] = $filter->clean($values[1]);
		$this->$inputType = $cleanValues;
	}
}