<?php
/**
 * Visforms field text class
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */
namespace  Visolutions\Component\Visforms\Site\Lib\Field;

// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Visolutions\Component\Visforms\Site\Model\VisformsModel as VisformsModelSite;
use Joomla\CMS\Plugin\PluginHelper;
use Visolutions\Component\Visforms\Site\Event\Visforms\VisfieldBeforeCreateEvent;

class TextField extends Field
{
	public function __construct($field, $form) {
		parent::__construct($field, $form);
		// store potential query Values for this field in the session
		$this->setQueryValue();
		$this->postValue = $this->input->post->get($field->name, '', 'STRING');
	}

	protected function setField(): void {
		// preprocessing field
		$this->extractDefaultValueParams();
		$this->extractGridSizesParams();
		$this->extractRestrictions();
		$this->mendBooleanAttribs();
        $this->prepareFieldForNoEditSqlProcess();
        $this->unsetDeselectedEditViewValidations();
        $this->setCustomPhpErrorMsg();
        PluginHelper::importPlugin('visforms');
        $dispatcher = Factory::getApplication()->getDispatcher();
        $event = new VisfieldBeforeCreateEvent('onVisfieldBeforeCreate', [
            'subject' => $this->field,
            'context' => 'com_visforms.field',
            'form' => $this->form
        ]);
        $dispatcher->dispatch('onVisfieldBeforeCreate', $event);
		$this->setIsConditional();
        // if we have a special default value set in field declaration we use this
		$this->fillWith();
		$this->setEditValue();
		$this->setConfigurationDefault();
		$this->setEditOnlyFieldDbValue();
		$this->setFieldDefaultValue();
		$this->setDbValue();
		$this->setRedirectParam();
		$this->escapeCustomRegex();
		$this->setCustomJs();
		$this->setFieldsetCounter();
		$this->mendInvalidUncheckedValue();
		$this->setEnterKeyAction();
		$this->setShowRequiredAsterix();
        $this->replaceLabelWithCustomText();
	}

	protected function setFieldDefaultValue(): void {
		$field = $this->field;
		// Could we just start with attribute_value = config default and only change it, if a post is set?
		if ($this->form->displayState === VisformsModelSite::$displayStateIsNewEditData) {
			if ((isset($this->field->editValue))) {
				$this->field->attribute_value = $this->field->editValue;
			}
			$this->field->dataSource = 'db';
			return;
		}
		// if we have a POST value, we use this
		if ((count($_POST) > 0) && isset($_POST['postid']) && ($_POST['postid'] == $this->form->id)) {
			if (isset($_POST[$field->name])) {
				$this->field->attribute_value = $this->postValue;
			}
			// reset to configuration default
			// set to empty, if the field is disabled and the form is re-displayed it will be reset to the default after business logic is performed
			else {
				$this->field->attribute_value = $this->field->configurationDefault;
			}
			$this->field->dataSource = 'post';
			return;
		}

		// if we have a GET value and field may use GET values, we use it
		if (isset($field->allowurlparam) && ($field->allowurlparam == true)) {
			$urlparams = Factory::getApplication()->getUserState('com_visforms.urlparams.' . $this->form->context, null);
			if (!empty($urlparams) && (is_array($urlparams)) && (isset($urlparams[$this->field->name]))) {
				$queryValue = $urlparams[$this->field->name];
			}
			if (isset($queryValue)) {
				// only return, if a query value exists; This value is already validated!
				$this->field->attribute_value = $queryValue;
				$this->field->dataSource = 'query';
			}
		}
        // we use default values
	}

	protected function setDbValue(): void {
		if (isset($this->field->dataSource) && $this->field->dataSource == 'post') {
			$this->field->dbValue = $this->postValue;
		}
	}

	protected function setEditOnlyFieldDbValue(): void {
		$this->field->editOnlyFieldDbValue = $this->field->configurationDefault;
	}

	protected function setRedirectParam(): void {
		if (isset($this->field->dataSource) && $this->field->dataSource == 'post' && (!empty($this->field->addtoredirecturl))) {
			$this->field->redirectParam = $this->postValue;
		}
	}

	protected function setConfigurationDefault(): void {
		$this->field->configurationDefault = $this->field->attribute_value;
		if (!$this->isEditOrSaveEditTask) {
			$urlparams = Factory::getApplication()->getUserState('com_visforms.urlparams.' . $this->form->context, null);
			if (!empty($urlparams) && (is_array($urlparams)) && (isset($urlparams[$this->field->name]))) {
				$queryValue = $urlparams[$this->field->name];
			}
			// if form was originally called with valid url params, reset to this url params
			$this->field->configurationDefault = (isset($this->field->allowurlparam) && ($this->field->allowurlparam == true) && isset($queryValue)) ? $queryValue : $this->field->attribute_value;
		}
	}
}