<?php
/**
 * Visforms decorator class for HTML controls
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6 
 */
namespace  Visolutions\Component\Visforms\Site\Lib\Html\Control\Decorator;

// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\PluginHelper;
use Visolutions\Component\Visforms\Site\Event\Visforms\VisformsAfterHtmlPrepareEvent;
use Visolutions\Component\Visforms\Site\Event\Visforms\VisformsBeforeHtmlPrepareEvent;
use Joomla\Event\DispatcherInterface;
use Visolutions\Component\Visforms\Site\Lib\Html\Control\Control;

abstract class Decorator
{
	protected $control;
	protected $breakPoints;
    protected $fieldHelper;

	public function __construct(Control $control) {
        $this->control = $control;
		$this->breakPoints = array('Sm', 'Md', 'Lg', 'Xl');
    }

	public function getControlHtml() {
		$field = $this->control->getField()->getField();
		$layout = $this->control->getLayout();

		PluginHelper::importPlugin('visforms');
		// Trigger onVisformsBeforeHtmlPrepare event to allow changes on field properties before control html is created
        $beforeHtmlPrepareEvent = new VisformsBeforeHtmlPrepareEvent('onVisformsBeforeHtmlPrepare', [
            'context' => 'com_visforms.field',
            'layout' => $layout,
            'field' => $field
        ]);
        Factory::getContainer()->get(DispatcherInterface::class)->dispatch('onVisformsBeforeHtmlPrepare', $beforeHtmlPrepareEvent);
		if ($this->control->getField()->getDecorable() == true) {
			// return decorated html string
			$html = $this->decorate();
		} 
		else {
			// return html string
			$html = $this->control->getControlHtml();
		}

		// Trigger onVisformsAfterHtmlPrepare event to allow changes on field properties after control html is created
        $afterHtmlPrepareEvent = new VisformsAfterHtmlPrepareEvent('onVisformsAfterHtmlPrepare', [
            'context' => 'com_visforms.field',
            'layout' => $layout,
            'html' => $html,
            'field' => $field
        ]);
        $html = Factory::getContainer()->get(DispatcherInterface::class)->dispatch('onVisformsAfterHtmlPrepare', $afterHtmlPrepareEvent)->getArgument('html', $html);

		return $html;
	}

	// bootstrap 5
	protected function getCtrlGroupBtClasses() {
		$field = $this->control->getField()->getField();
		// show_label: 0 => show 1 => hide !
        $hasNoLabel = ((!empty($field->show_label)) && (empty($field->label_icon)));
		$classes = ($hasNoLabel && $field->labelBootstrapWidth != "12") ? 'offset-' . $field->labelBootstrapWidth . ' col-' . (12 - $field->labelBootstrapWidth) : (($field->labelBootstrapWidth != "12") ? ' col-' . (12 - $field->labelBootstrapWidth) : ' col-12');
		foreach ($this->breakPoints as $breakPoint) {
			$name = 'labelBootstrapWidth' . $breakPoint;
			$lcBreakPoint = lcfirst($breakPoint);
			$classes .= ($hasNoLabel && $field->$name != "12") ? ' offset-' . $lcBreakPoint . '-' . $field->$name . ' col-' . $lcBreakPoint . '-' . (12 - $field->$name) : (((!$hasNoLabel) && $field->$name != "12") ? ' col-' . $lcBreakPoint . '-' . (12 - $field->$name) : ' offset-' . $lcBreakPoint . '-0 col-' . $lcBreakPoint . '-12');
		}
		return $classes;
	}

	// use for indentation of error div in bootstrap 4 and bootstrap 5
	protected function getIndentedBtClasses() {
		$field = $this->control->getField()->getField();
		$indentedBtClasses = ($field->labelBootstrapWidth != "12") ? 'offset-' . $field->labelBootstrapWidth . ' col-' . (12 - $field->labelBootstrapWidth) : 'col-12';
		foreach ($this->breakPoints as $breakPoint) {
			$name = 'labelBootstrapWidth' . $breakPoint;
			$lcBreakPoint = lcfirst($breakPoint);
			$indentedBtClasses .= ($field->$name != "12") ? ' offset-' . $lcBreakPoint . '-' . $field->$name . ' col-' . $lcBreakPoint . '-' . (12 - $field->$name) : '  offset-' . $lcBreakPoint . '-0 col-' . $lcBreakPoint . '-12';
		}
		return $indentedBtClasses;
	}

	abstract protected function decorate();
}