<?php
/**
 * Visforms create control HTML class
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6 
 */
namespace  Visolutions\Component\Visforms\Site\Lib\Html\Control;

// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Layout\FileLayout;

class NoneTextareaControl extends Control {

   public function getControlHtml () {
        $field = $this->field->getField();
        //input
        $html = '';
        $layout = new FileLayout('visforms.default.textarea.control', null);
        $layout->setOptions(array('component' => 'com_visforms'));
        $html .= $layout->render(array('field' => $field));      
        return $html; 
   }

   public function createLabel() {
        $field = $this->field->getField();
        $labelClass = $this->getLabelClass();
        $field->labelClass = $labelClass;
        // label
        $html = '';
        $layout = new FileLayout('visforms.default.textarea.label', null);
        $layout->setOptions(array('component' => 'com_visforms'));
        $html .= $layout->render(array('field' => $field));      
        return $html;
   }

   protected function getLabelClass () {
       $labelClass = ' visCSSlabel ';
       if ($this->field->getField()->custominfo != "")
       {
           $labelClass = ' visCSSbot5 visCSSlabel ';
       }
       return $labelClass;
   }
}